// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{POWER_SCALE_FACTOR,SAMPLE_RATE,SAMPLES_PER_POWER_BAR,SAMPLES_PER_SLICE}from"./audio_constants.js";import{computed,signal}from"./reactive/signal.js";import{SodaEventTransformer,Transcription}from"./soda/soda.js";import{assert,assertExists}from"./utils/assert.js";import{AsyncJobQueue}from"./utils/async_job_queue.js";import{InteriorMutableArray}from"./utils/interior_mutable_array.js";import{clamp}from"./utils/utils.js";const AUDIO_MIME_TYPE="audio/webm;codecs=opus";const TIME_SLICE_MS=100;const POWER_GROUP_SIZE=Math.round(SAMPLES_PER_POWER_BAR/SAMPLES_PER_SLICE);const SAMPLE_SIZE=16;function getMicrophoneStream(micId,echoCancellation){return navigator.mediaDevices.getUserMedia({audio:{autoGainControl:{exact:false},deviceId:{exact:micId},echoCancellation:{exact:echoCancellation}}})}let audioCtxGlobal=null;async function getAudioContext(){if(audioCtxGlobal===null){audioCtxGlobal=new AudioContext({sampleRate:SAMPLE_RATE,sinkId:{type:"none"}});await audioCtxGlobal.audioWorklet.addModule("./static/audio_worklet.js")}return audioCtxGlobal}export class RecordingSession{constructor(audioCtx,config){this.audioCtx=audioCtx;this.config=config;this.dataChunks=[];this.currentSodaSession=null;this.sodaEnableQueue=new AsyncJobQueue("keepLatest");this.powers=signal(new InteriorMutableArray([]));this.transcription=signal(null);this.processedSamples=0;this.micAudioSourceNode=null;this.systemAudioSourceNode=null;this.micMuted=false;this.everPausedInternal=false;this.everMutedInternal=false;this.powerCounts=0;this.progress=computed((()=>{const powers=this.powers.value;const length=powers.length*SAMPLES_PER_POWER_BAR/SAMPLE_RATE;return{length:length,powers:powers,transcription:this.transcription.value}}));this.sodaEventTransformer=new SodaEventTransformer(config.speakerLabelEnabled);this.combinedInputNode=audioCtx.createMediaStreamDestination();this.audioProcessor=new AudioWorkletNode(audioCtx,"audio-processor");this.mediaRecorder=new MediaRecorder(this.combinedInputNode.stream,{mimeType:AUDIO_MIME_TYPE});this.mediaRecorder.addEventListener("dataavailable",(e=>{this.onDataAvailable(e)}));this.mediaRecorder.addEventListener("error",(e=>{this.onError(e)}));this.audioProcessor.port.addEventListener("message",(ev=>{this.powerCounts=(this.powerCounts+1)%POWER_GROUP_SIZE;const samples=ev.data;if(this.powerCounts===0){const squaredSum=samples.slice(0,SAMPLE_SIZE).map((v=>v*v)).reduce(((x,y)=>x+y),0);const power=Math.sqrt(squaredSum/SAMPLE_SIZE);const scaledPower=clamp(Math.floor(Math.sqrt(power)*POWER_SCALE_FACTOR),0,POWER_SCALE_FACTOR-1);this.powers.value=this.powers.value.push(scaledPower)}this.currentSodaSession?.session.addAudio(samples);this.processedSamples+=samples.length}))}setMicMuted(muted){this.micMuted=muted;if(muted){this.everMutedInternal=true}if(this.micAudioSourceNode!==null){for(const track of this.micAudioSourceNode.mediaStream.getTracks()){track.enabled=!muted}}}setSpeakerLabelEnabled(enabled){this.sodaEventTransformer.speakerLabelEnabled=enabled}get everPaused(){return this.everPausedInternal}get everMuted(){return this.everMutedInternal}connectSourceNode(node){node.connect(this.combinedInputNode);node.connect(this.audioProcessor)}async initMicAudioSourceNode(){if(this.micAudioSourceNode!==null){return}const micStream=await getMicrophoneStream(this.config.micId,this.config.canCaptureSystemAudioWithLoopback);this.micAudioSourceNode=this.audioCtx.createMediaStreamSource(micStream);this.connectSourceNode(this.micAudioSourceNode);this.setMicMuted(this.micMuted)}async initSystemAudioSourceNode(){if(this.systemAudioSourceNode!==null){return}if(!this.config.includeSystemAudio||!this.config.canCaptureSystemAudioWithLoopback){return}const systemAudioStream=await this.config.platformHandler.getSystemAudioMediaStream();this.systemAudioSourceNode=this.audioCtx.createMediaStreamSource(systemAudioStream);this.connectSourceNode(this.systemAudioSourceNode)}closeAudioSourceNode(node){for(const track of node.mediaStream.getTracks()){track.stop()}node.disconnect()}closeMicAudioSourceNode(){if(this.micAudioSourceNode!==null){this.closeAudioSourceNode(this.micAudioSourceNode);this.micAudioSourceNode=null}}closeSystemAudioSourceNode(){if(this.systemAudioSourceNode!==null){this.closeAudioSourceNode(this.systemAudioSourceNode);this.systemAudioSourceNode=null}}async setPaused(paused){if(paused){await this.audioCtx.suspend();this.mediaRecorder.pause();this.closeMicAudioSourceNode();this.everPausedInternal=true}else{await this.initMicAudioSourceNode();this.mediaRecorder.resume();await this.audioCtx.resume()}}onDataAvailable(event){this.dataChunks.push(event.data)}onError(event){console.error(event)}async isSodaInstalled(language){const{platformHandler:platformHandler}=this.config;const sodaState=platformHandler.getSodaState(language);assert(sodaState.value.kind!=="unavailable",`Trying to install SODA when it's unavailable`);await platformHandler.installSoda(language);return sodaState.value.kind==="installed"}tryStartSodaSession(language){return this.sodaEnableQueue.push((async()=>{if(!await this.isSodaInstalled(language)){return}if(this.currentSodaSession!==null){return}if(this.transcription.value===null){this.transcription.value=new Transcription([],language)}if(this.sodaEnableQueue.hasPendingJob()){return}const session=await this.config.platformHandler.newSodaSession(language);const unsubscribe=session.subscribeEvent((ev=>{this.sodaEventTransformer.addEvent(ev,assertExists(this.currentSodaSession).startOffsetMs);this.transcription.value=this.sodaEventTransformer.getTranscription(language)}));this.currentSodaSession={language:language,session:session,unsubscribe:unsubscribe,startOffsetMs:this.processedSamples/SAMPLE_RATE*1e3};await session.start()}))}stopSodaSession(){return this.sodaEnableQueue.push((async()=>{if(this.currentSodaSession===null){return}await this.currentSodaSession.session.stop();this.currentSodaSession.unsubscribe();this.sodaEventTransformer.finalizeTokens();this.transcription.value=this.sodaEventTransformer.getTranscription(this.currentSodaSession.language);this.currentSodaSession=null}))}async start(transcriptionEnabled,language=null){await this.audioCtx.suspend();if(transcriptionEnabled&&language!==null){this.tryStartSodaSession(language)}await Promise.all([this.initMicAudioSourceNode(),this.initSystemAudioSourceNode()]);await this.audioCtx.resume();this.audioProcessor.port.start();this.mediaRecorder.start(TIME_SLICE_MS)}async finish(){const stopped=new Promise((resolve=>{this.mediaRecorder.addEventListener("stop",resolve,{once:true})}));this.mediaRecorder.stop();this.audioProcessor.port.close();await this.stopSodaSession().result;await stopped;this.closeMicAudioSourceNode();this.closeSystemAudioSourceNode();return new Blob(this.dataChunks,{type:AUDIO_MIME_TYPE})}static async create(config){const audioCtx=await getAudioContext();return new RecordingSession(audioCtx,config)}}