// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{signal}from"../reactive/signal.js";import{assertExists}from"../utils/assert.js";import{startViewTransition}from"../utils/utils.js";function createRoute(path,parameterKeys){return{path:path,parameterKeys:parameterKeys}}const routes={main:createRoute("/",[]),playback:createRoute("/playback",["id"]),record:createRoute("/record",["includeSystemAudio","micId"]),dev:createRoute("/dev",[]),test:createRoute("/test",[])};export const currentRoute=signal(null);function extractCurrentRouteInfo(url){const routeInHash=new URL(url.hash.slice(1),document.location.origin);const path=routeInHash.pathname;const search=new URLSearchParams(routeInHash.search);for(const[name,info]of Object.entries(routes)){if(path!==info.path){continue}const parameters={};for(const key of info.parameterKeys){parameters[key]=search.get(key)}return{name:name,parameters:parameters}}return null}function handleTransition(oldRouteName,newRouteName){if(oldRouteName==="main"&&newRouteName==="record"){const app=assertExists(document.querySelector("recorder-app"));const root=document.documentElement;const part=app.mainPage.actionsContainer;const rect=part.getBoundingClientRect();const{left:left,top:top}=rect;const right=window.innerWidth-rect.right;const bottom=window.innerHeight-rect.bottom;const round=Math.min(rect.width,rect.height)/2;const clipPath=`inset(${top}px ${right}px ${bottom}px ${left}px round ${round}px)`;root.style.setProperty("--start-clip-path",clipPath);return()=>{root.style.removeProperty("--start-clip-path")}}return null}function updateRoute(){const url=new URL(window.location.href);const oldRoute=currentRoute.value;const newRoute=extractCurrentRouteInfo(url);const html=document.documentElement;const oldRouteName=oldRoute?.name??null;const newRouteName=newRoute?.name??null;const transitionClassName=`transition-${oldRouteName??"none"}-${newRouteName??"none"}`;const cleanup=handleTransition(oldRouteName,newRouteName);html.classList.add(transitionClassName);void startViewTransition((()=>{currentRoute.value=newRoute})).then((()=>{html.classList.remove(transitionClassName);cleanup?.()}))}function navigateToImpl(path){window.history.pushState({},"",`#${path}`);updateRoute()}export function navigateTo(name,parameters={}){const{path:path}=routes[name];const params=new URLSearchParams(parameters);navigateToImpl(`${path}?${params.toString()}`)}export function installRouter(){document.body.addEventListener("click",(e=>{if(e.defaultPrevented||e.button!==0||e.altKey||e.ctrlKey||e.shiftKey||e.metaKey){return}const anchor=e.composedPath().find((el=>el instanceof Node&&el.nodeName==="A"));if(anchor===undefined||anchor.target!==""||anchor.download!==""||anchor.rel==="external"){return}const href=anchor.href;let url;try{url=new URL(href);if(url.origin!==window.location.origin){return}}catch(_e){return}e.preventDefault();if(href!==window.location.href){navigateToImpl(url.pathname)}}));window.addEventListener("popstate",(()=>{updateRoute()}));updateRoute()}