// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{bindSignal}from"../reactive/local_storage.js";import{signal}from"../reactive/signal.js";import{LanguageCode}from"../soda/language_info.js";import*as localStorage from"../utils/local_storage.js";import{z}from"../utils/schema.js";export var RecordingSortType;(function(RecordingSortType){RecordingSortType["DATE"]="DATE";RecordingSortType["NAME"]="NAME"})(RecordingSortType||(RecordingSortType={}));export var TranscriptionEnableState;(function(TranscriptionEnableState){TranscriptionEnableState["ENABLED"]="ENABLED";TranscriptionEnableState["DISABLED_FIRST"]="DISABLED_FIRST";TranscriptionEnableState["DISABLED"]="DISABLED";TranscriptionEnableState["UNKNOWN"]="UNKNOWN"})(TranscriptionEnableState||(TranscriptionEnableState={}));export var SummaryEnableState;(function(SummaryEnableState){SummaryEnableState["ENABLED"]="ENABLED";SummaryEnableState["DISABLED"]="DISABLED";SummaryEnableState["UNKNOWN"]="UNKNOWN"})(SummaryEnableState||(SummaryEnableState={}));export var SpeakerLabelEnableState;(function(SpeakerLabelEnableState){SpeakerLabelEnableState["ENABLED"]="ENABLED";SpeakerLabelEnableState["DISABLED_FIRST"]="DISABLED_FIRST";SpeakerLabelEnableState["DISABLED"]="DISABLED";SpeakerLabelEnableState["UNKNOWN"]="UNKNOWN"})(SpeakerLabelEnableState||(SpeakerLabelEnableState={}));export var ExportAudioFormat;(function(ExportAudioFormat){ExportAudioFormat["WEBM_ORIGINAL"]="WEBM_ORIGINAL"})(ExportAudioFormat||(ExportAudioFormat={}));export var ExportTranscriptionFormat;(function(ExportTranscriptionFormat){ExportTranscriptionFormat["TXT"]="TXT"})(ExportTranscriptionFormat||(ExportTranscriptionFormat={}));export const exportSettingsSchema=z.object({audio:z.boolean(),audioFormat:z.nativeEnum(ExportAudioFormat),transcription:z.boolean(),transcriptionFormat:z.nativeEnum(ExportTranscriptionFormat)});export const settingsSchema=z.object({exportSettings:exportSettingsSchema,hasOpenedMicMenu:z.withDefault(z.boolean(),false),includeSystemAudio:z.boolean(),keepScreenOn:z.withDefault(z.boolean(),false),onboardingDone:z.boolean(),recordingSortType:z.nativeEnum(RecordingSortType),transcriptionEnabled:z.nativeEnum(TranscriptionEnableState),transcriptionLanguage:z.withDefault(z.nullable(z.nativeEnum(LanguageCode)),null),summaryEnabled:z.nativeEnum(SummaryEnableState),speakerLabelEnabled:z.withDefault(z.nativeEnum(SpeakerLabelEnableState),SpeakerLabelEnableState.UNKNOWN),systemAudioConsentDone:z.withDefault(z.boolean(),false)});const defaultSettings={exportSettings:{audio:true,audioFormat:ExportAudioFormat.WEBM_ORIGINAL,transcription:false,transcriptionFormat:ExportTranscriptionFormat.TXT},hasOpenedMicMenu:false,includeSystemAudio:false,keepScreenOn:false,onboardingDone:false,recordingSortType:RecordingSortType.DATE,transcriptionEnabled:TranscriptionEnableState.UNKNOWN,transcriptionLanguage:null,summaryEnabled:SummaryEnableState.UNKNOWN,speakerLabelEnabled:SpeakerLabelEnableState.UNKNOWN,systemAudioConsentDone:false};export const settings=signal(defaultSettings);export function init(){bindSignal(settings,localStorage.Key.SETTINGS,settingsSchema,defaultSettings)}