// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{createTranscriptionModelDownloadPerf}from"../events_sender.js";import{usePlatformHandler}from"../lit/context.js";import{assertExhaustive}from"../utils/assert.js";import{settings,TranscriptionEnableState}from"./settings.js";export function disableTranscription(firstTime=false){settings.mutate((s=>{s.transcriptionEnabled=firstTime?TranscriptionEnableState.DISABLED_FIRST:TranscriptionEnableState.DISABLED}))}export function installSoda(language){const platformHandler=usePlatformHandler();if(platformHandler.getSodaState(language).value.kind==="notInstalled"){platformHandler.perfLogger.start(createTranscriptionModelDownloadPerf(language))}void platformHandler.installSoda(language)}export function enableTranscriptionSkipConsentCheck(){settings.mutate((s=>{s.transcriptionEnabled=TranscriptionEnableState.ENABLED}));const platformHandler=usePlatformHandler();const selectedLanguage=platformHandler.getSelectedLanguage();if(selectedLanguage!==null){installSoda(selectedLanguage)}}export function setTranscriptionLanguage(language){settings.mutate((s=>{s.transcriptionLanguage=language}));installSoda(language)}export function toggleTranscriptionEnabled(){switch(settings.value.transcriptionEnabled){case TranscriptionEnableState.ENABLED:disableTranscription();return true;case TranscriptionEnableState.DISABLED:enableTranscriptionSkipConsentCheck();return true;case TranscriptionEnableState.UNKNOWN:case TranscriptionEnableState.DISABLED_FIRST:return false;default:assertExhaustive(settings.value.transcriptionEnabled)}}export function enableTranscription(){switch(settings.value.transcriptionEnabled){case TranscriptionEnableState.ENABLED:return true;case TranscriptionEnableState.DISABLED:enableTranscriptionSkipConsentCheck();return true;case TranscriptionEnableState.UNKNOWN:case TranscriptionEnableState.DISABLED_FIRST:return false;default:assertExhaustive(settings.value.transcriptionEnabled)}}