// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{SAMPLES_PER_SLICE}from"./audio_constants.js";import{usePlatformHandler,useRecordingDataManager}from"./lit/context.js";import{LanguageCode}from"./soda/language_info.js";import{Transcription}from"./soda/soda.js";import{navigateTo}from"./state/route.js";import{settings,SpeakerLabelEnableState,SummaryEnableState,TranscriptionEnableState}from"./state/settings.js";import{assertExists,checkEnumVariant}from"./utils/assert.js";function base64ToBlob(data){const mimeType="audio/webm;codecs=opus";const dataPart=assertExists(data.split(",")[1],"Invalid audio data");const byteCharacters=atob(dataPart);const n=byteCharacters.length;const byteArray=new Uint8Array(n);for(let i=0;i<n;i++){byteArray[i]=byteCharacters.charCodeAt(i)}return new Blob([byteArray],{type:mimeType})}function stringToLanguageCode(language){const languageCode=checkEnumVariant(LanguageCode,language);return languageCode??LanguageCode.EN_US}export class TestHelper{static goToMainPage(){navigateTo("main")}static async removeCacheData(){localStorage.clear();await useRecordingDataManager().clear()}static configureSettingsForTest(config){settings.mutate((s=>{s.includeSystemAudio=config.includeSystemAudio;if(!config.showOnboardingDialog){s.onboardingDone=true}if(config.speakerLabelForceEnabled){s.speakerLabelEnabled=SpeakerLabelEnableState.ENABLED}if(config.summaryForceEnabled){s.summaryEnabled=SummaryEnableState.ENABLED}if(config.transcriptionForceEnabled){s.transcriptionEnabled=TranscriptionEnableState.ENABLED;s.transcriptionLanguage=stringToLanguageCode(config.transcriptionLanguage)}}))}static async importRecordings(recordings){for(const data of recordings){const{audio:audio,durationMs:durationMs,powers:powers,title:title,textTokens:tokens,language:language}=data;const blob=base64ToBlob(audio);const params={title:title,durationMs:durationMs,recordedAt:Date.now(),powers:powers,samplesPerDataPoint:SAMPLES_PER_SLICE,transcription:tokens!==undefined?new Transcription(tokens,stringToLanguageCode(language??"en-US")):null};await useRecordingDataManager().createRecording(params,blob)}}static installTranscriptionModel(language="en-US"){void usePlatformHandler().installSoda(stringToLanguageCode(language))}static isTranscriptionModelInstalled(language="en-US"){const state=usePlatformHandler().getSodaState(stringToLanguageCode(language)).value;return state.kind==="installed"}static installGenAiModel(){usePlatformHandler().downloadGenAiModel()}static isGenAiModelInstalled(){const state=usePlatformHandler().getGenAiModelState();return state.kind==="installed"}static resolveComponent(key){return UI_COMPONENTS[key]()}static getRecordingFileCount(){return app().mainPage.recordingFileListForTest.recordingFileCountForTest()}static getNthSuggestedTitle(index){return app().playbackPageForTest.recordingTitleForTest.titleSuggestionForTest.nthSuggestedTitleForTest(index)}static getSummaryContent(){return app().playbackPageForTest.summarizationViewForTest.getSummaryContentForTest()}}function app(){return assertExists(document.querySelector("recorder-app"))}const UI_COMPONENTS={firstSuggestedTitle:()=>app().playbackPageForTest.recordingTitleForTest.titleSuggestionForTest.firstSuggestedTitleForTest,firstRecordingCard:()=>app().mainPage.recordingFileListForTest.firstRecordingForTest.recordingCardForTest,mainPage:()=>app().mainPage,playbackBackButton:()=>app().playbackPageForTest.backButtonForTest,playbackPage:()=>app().playbackPageForTest,playbackPauseButton:()=>app().playbackPageForTest.pauseButtonForTest,playbackRecordingTitle:()=>app().playbackPageForTest.recordingTitleForTest,playbackTranscriptionToggleButton:()=>app().playbackPageForTest.transcriptionToggleButtonForTest,recordPage:()=>app().recordPageForTest,renameTitleText:()=>app().playbackPageForTest.recordingTitleForTest.renameContainerForTest,suggestTitleButton:()=>app().playbackPageForTest.recordingTitleForTest.suggestTitleButtonForTest,summaryContainer:()=>app().playbackPageForTest.summarizationViewForTest.summaryContainerForTest,startRecordingButton:()=>app().mainPage.startRecordingButtonForTest,stopRecordingButton:()=>app().recordPageForTest.stopRecordingButtonForTest};