// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{cacheLatest}from"./utils.js";function padZero(num){return num.toString().padStart(2,"0")}export function formatDuration(duration,digits=0,fullDigitalFormat=false){let secs=(duration.seconds??0)+(duration.milliseconds??0)/1e3;secs=Number(secs.toFixed(digits));let mins=Math.floor(secs/60);secs%=60;const hours=Math.floor(mins/60);mins%=60;digits=digits===0&&fullDigitalFormat?1:digits;const secsStr=secs.toFixed(digits).padStart(digits===0?2:3+digits,"0");if(hours>0||fullDigitalFormat){return`${hours}:${padZero(mins)}:${secsStr}`}else{return`${padZero(mins)}:${secsStr}`}}const useDateFormat=cacheLatest((locale=>new Intl.DateTimeFormat(locale,{month:"short",day:"numeric"})));export function formatDate(locale,timestamp){return useDateFormat(locale).format(new Date(timestamp))}const useTimeFormat=cacheLatest((locale=>new Intl.DateTimeFormat(locale,{hour:"numeric",minute:"2-digit",hour12:true})));export function formatTime(locale,timestamp){return useTimeFormat(locale).format(new Date(timestamp))}const useFullDatetimeFormat=cacheLatest((locale=>new Intl.DateTimeFormat(locale,{dateStyle:"long",timeStyle:"medium"})));export function formatFullDatetime(locale,timestamp){return useFullDatetimeFormat(locale).format(new Date(timestamp))}export function getToday(){const today=new Date;today.setHours(0);today.setMinutes(0);today.setSeconds(0);today.setMilliseconds(0);return today.getTime()}export function getYesterday(){const dayInMilliseconds=24*60*60*1e3;const yesterday=new Date(getToday());return yesterday.getTime()-dayInMilliseconds}const useMonthFormat=cacheLatest((locale=>new Intl.DateTimeFormat(locale,{month:"long",year:"numeric"})));export function getMonthLabel(locale,timestamp){return useMonthFormat(locale).format(new Date(timestamp))}export function isInThisMonth(timestamp){const now=new Date;const date=new Date(timestamp);return date.getMonth()===now.getMonth()&&date.getFullYear()===now.getFullYear()}