// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"./assert.js";const tag=Symbol("draft");const deleted=Symbol("deleted");function isDraftable(x){return typeof x==="object"&&x!==null}function isDraft(x){return isDraftable(x)&&Reflect.has(x,tag)}function createDraft(base){assert(isDraftable(base));const shadowMap=new Map;return new Proxy(base,{get(target,prop,receiver){if(prop===tag){if(shadowMap.size===0){return base}const copy=Array.isArray(base)?[...base]:{...base};for(const[key,value]of shadowMap.entries()){if(value===deleted){Reflect.deleteProperty(copy,key)}else{Reflect.set(copy,key,isDraft(value)?finalizeDraft(value):value)}}return copy}if(shadowMap.has(prop)){const shadow=shadowMap.get(prop);return shadow===deleted?undefined:shadow}const value=Reflect.get(target,prop,receiver);if(!isDraftable(value)){return value}const shadow=createDraft(value);shadowMap.set(prop,shadow);return shadow},set(_target,prop,newValue){shadowMap.set(prop,isDraftable(newValue)?createDraft(newValue):newValue);return true},has(target,prop){return prop===tag||Reflect.has(target,prop)},deleteProperty(target,prop){const found=shadowMap.has(prop)?shadowMap.get(prop)!==deleted:Reflect.has(target,prop);if(found){shadowMap.set(prop,deleted)}return found}})}function finalizeDraft(draft){return draft[tag]}export function produce(base,recipe){if(isDraftable(base)){const draft=createDraft(base);const maybeNewValue=recipe(draft);return maybeNewValue!==undefined?maybeNewValue:finalizeDraft(draft)}else{const maybeNewValue=recipe(base);return maybeNewValue!==undefined?maybeNewValue:base}}