// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assertExists,assertNotReached,checkEnumVariant}from"./assert.js";export class ValidationError extends Error{constructor(issue){const{path:path,message:message}=issue;super(`${path.join(".")}: ${message}`);this.issue=issue;this.name="ValidationError"}}class Context{constructor(){this.path=["$"];this.issue=null}pushKey(key){this.path.push(key)}popKey(){this.path.pop()}setIssue(msg){this.issue={path:this.path.slice(),message:msg}}}const DECODE_ERROR=Symbol("SCHEMA_DECODE_ERROR");export class Schema{constructor({test:test,decode:decode,encode:encode}){this.test=test;this.decode=decode;this.encode=encode}parse(input){const ctx=new Context;const val=this.decode(input,ctx);if(val!==DECODE_ERROR){return val}throw new ValidationError({schema:this,...ctx.issue??{path:["$"],message:"validation error"}})}parseJson(input){const data=JSON.parse(input);return this.parse(data)}stringifyJson(val){return JSON.stringify(this.encode(val))}}function identity(val){return val}function createPrimitiveSchema(test,error){return new Schema({test:test,decode(input,ctx){if(test(input)){return input}ctx.setIssue(error);return DECODE_ERROR},encode:identity})}const nullSchema=createPrimitiveSchema((input=>input===null),"expect null");const booleanSchema=createPrimitiveSchema((input=>typeof input==="boolean"),"expect boolean");const numberSchema=createPrimitiveSchema((input=>typeof input==="number"),"expect number");const bigintSchema=createPrimitiveSchema((input=>typeof input==="bigint"),"expect bigint");const stringSchema=createPrimitiveSchema((input=>typeof input==="string"),"expect string");function createLiteralSchema(literal){return createPrimitiveSchema((input=>input===literal),`expect ${literal}`)}function createNativeEnumSchema(enumObj){return createPrimitiveSchema((input=>checkEnumVariant(enumObj,input)!==null),"expect enum")}function createOptionalSchema(schema){return new Schema({test(input){if(input===undefined){return true}return schema.test(input)},decode(input,ctx){if(input===undefined){return undefined}return schema.decode(input,ctx)},encode(val){if(val===undefined){return undefined}return schema.encode(val)}})}function createNullableSchema(schema){return new Schema({test(input){if(input===null){return true}return schema.test(input)},decode(input,ctx){if(input===null){return null}return schema.decode(input,ctx)},encode(val){if(val===null){return null}return schema.encode(val)}})}function createAutoNullOptionalSchema(schema){return new Schema({test(input){if(input===null){return true}return schema.test(input)},decode(input,ctx){if(input===null||input===undefined){return null}return schema.decode(input,ctx)},encode(val){if(val===null){return null}return schema.encode(val)}})}function createCatchSchema(schema,fallback){return new Schema({test:schema.test,decode(input,ctx){const val=schema.decode(input,ctx);if(val===DECODE_ERROR){return fallback}return val},encode(val){return schema.encode(val)}})}function createArraySchema(elem){return new Schema({test(input){if(!Array.isArray(input)){return false}return input.every((v=>elem.test(v)))},decode(input,ctx){if(!Array.isArray(input)){ctx.setIssue("expect array");return DECODE_ERROR}const ret=[];for(let i=0;i<input.length;i++){ctx.pushKey(`${i}`);const val=elem.decode(input[i],ctx);if(val===DECODE_ERROR){return DECODE_ERROR}ret.push(val);ctx.popKey()}return ret},encode(val){return val.map((v=>elem.encode(v)))}})}function createTupleSchema(schemas){return new Schema({test(input){if(!Array.isArray(input)||input.length!==schemas.length){return false}return schemas.every(((schema,i)=>{const el=assertExists(input[i]);return schema.test(el)}))},decode(input,ctx){if(!Array.isArray(input)||input.length!==schemas.length){ctx.setIssue(`expect tuple of length ${schemas.length}`);return DECODE_ERROR}const ret=[];for(const[i,schema]of schemas.entries()){ctx.pushKey(`${i}`);const el=assertExists(input[i]);const val=schema.decode(el,ctx);if(val===DECODE_ERROR){return DECODE_ERROR}ret.push(val);ctx.popKey()}return ret},encode(val){return schemas.map(((schema,i)=>schema.encode(val[i])))}})}function createObjectSchema(spec){return new Schema({test(input){if(typeof input!=="object"||input===null){return false}for(const[key,schema]of Object.entries(spec)){const value=Object.hasOwn(input,key)?input[key]:undefined;if(!schema.test(value)){return false}}return true},decode(input,ctx){if(typeof input!=="object"){ctx.setIssue("expect object");return DECODE_ERROR}if(input===null){ctx.setIssue("expect non-null object");return DECODE_ERROR}const obj={};for(const[key,schema]of Object.entries(spec)){ctx.pushKey(key);const value=Object.hasOwn(input,key)?input[key]:undefined;const decodedValue=schema.decode(value,ctx);if(decodedValue===DECODE_ERROR){return DECODE_ERROR}obj[key]=decodedValue;ctx.popKey()}return obj},encode(val){const ret={};for(const[key,schema]of Object.entries(spec)){const value=Object.hasOwn(val,key)?val[key]:undefined;ret[key]=schema.encode(value)}return ret}})}function createUnionSchema(schemas){return new Schema({test(input){return schemas.some((s=>s.test(input)))},decode(input,ctx){const altCtx=new Context;for(const schema of schemas){const val=schema.decode(input,altCtx);if(val!==DECODE_ERROR){return val}}ctx.setIssue("expect union but all alternatives failed");return DECODE_ERROR},encode(val){for(const schema of schemas){if(schema.test(val)){return schema.encode(val)}}assertNotReached("union schema encode value with no alternatives matched")}})}function createIntersectionSchema(schemas){return new Schema({test(input){return!schemas.some((s=>!s.test(input)))},decode(input,ctx){const obj={};for(const schema of schemas){const decodedValue=schema.decode(input,ctx);if(decodedValue===DECODE_ERROR){return DECODE_ERROR}if(typeof decodedValue!=="object"||decodedValue===null){ctx.setIssue("decoded value in intersection is not object");return DECODE_ERROR}for(const[key,val]of Object.entries(decodedValue)){if(Object.hasOwn(obj,key)){ctx.setIssue("duplicate key in intersection alternatives");return DECODE_ERROR}obj[key]=val}}return obj},encode(val){const obj={};for(const schema of schemas){const encodedValue=schema.encode(val);if(typeof encodedValue!=="object"||encodedValue===null){throw new Error("encoded value in intersection is not object")}for(const[key,val]of Object.entries(encodedValue)){if(Object.hasOwn(obj,key)){throw new Error("duplicate key in intersection alternatives")}obj[key]=val}}return obj}})}function createTransformSchema(schema,{test:test,decode:decode,encode:encode}){return new Schema({test:test,decode(input,ctx){const val=schema.decode(input,ctx);if(val===DECODE_ERROR){return DECODE_ERROR}return decode(val)},encode(val){return schema.encode(encode(val))}})}function createWithDefaultSchema(schema,defaultValue){return new Schema({test:schema.test,decode(val,ctx){if(val===undefined){return defaultValue}return schema.decode(val,ctx)},encode(val){return schema.encode(val)}})}export const z={null:()=>nullSchema,boolean:()=>booleanSchema,number:()=>numberSchema,bigint:()=>bigintSchema,string:()=>stringSchema,literal:createLiteralSchema,nativeEnum:createNativeEnumSchema,optional:createOptionalSchema,nullable:createNullableSchema,autoNullOptional:createAutoNullOptionalSchema,catch:createCatchSchema,array:createArraySchema,tuple:createTupleSchema,object:createObjectSchema,union:createUnionSchema,intersection:createIntersectionSchema,transform:createTransformSchema,withDefault:createWithDefaultSchema};