// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert,assertExists}from"./assert.js";export function clamp(val,low,high){return Math.min(high,Math.max(low,val))}export function sliceWhen(values,shouldSlice){if(values.length===0){return[]}const ret=[];let slice=[assertExists(values[0])];for(let i=1;i<values.length;i++){const val=assertExists(values[i]);if(shouldSlice(assertExists(slice[slice.length-1]),val)){ret.push(slice);slice=[]}slice.push(val)}ret.push(slice);return ret}export function parseNumber(val){if(val===null||val===undefined){return null}const num=Number(val);if(isNaN(num)){return null}return num}export function getWordCount(s,locale){const segmenter=new Intl.Segmenter(locale,{granularity:"word"});const segments=segmenter.segment(s);let wordCount=0;for(const segment of segments){wordCount+=segment.isWordLike===true?1:0}return wordCount}export function chunkContentByWord(content,chunkSize,locale){const segmenter=new Intl.Segmenter(locale,{granularity:"word"});const segments=segmenter.segment(content);const chunks=[];let chunk=[];let wordCount=0;for(const{segment:segment,isWordLike:isWordLike}of segments){if(wordCount<chunkSize){chunk.push(segment)}else{wordCount=0;chunks.push(chunk.join(""));chunk=[segment]}wordCount+=isWordLike===true?1:0}if(chunk.length>0){chunks.push(chunk.join(""))}return chunks}export function shorten(s,maxWords){const words=s.match(/\s*\S+\s*/g);if(words===null||words.length<=maxWords){return s}const half=Math.floor(maxWords/2);const begin=words.slice(0,half).join("");const end=words.slice(-half).join("");return`${begin}\n(...)\n${end}`}export function sleep(ms){return new Promise((resolve=>{setTimeout(resolve,ms)}))}export function downloadFile(filename,blob){const url=URL.createObjectURL(blob);const a=document.createElement("a");a.href=url;a.download=filename;a.style.display="none";document.body.appendChild(a);a.click();document.body.removeChild(a);URL.revokeObjectURL(url)}const UNINITIALIZED=Symbol("UNINITIALIZED");export function lazyInit(fn){let output=UNINITIALIZED;return()=>{if(output===UNINITIALIZED){output=fn()}return output}}export function asyncLazyInit(fn){let val=UNINITIALIZED;return async()=>{if(val===UNINITIALIZED){val=await fn()}return val}}export function cacheLatest(fn){let output=UNINITIALIZED;let lastInput=UNINITIALIZED;return input=>{if(input!==lastInput){lastInput=input;output=fn(input)}assert(output!==UNINITIALIZED);return output}}export function isObjectEmpty(obj){for(const k in obj){if(Object.hasOwn(obj,k)){return false}}return true}export function startViewTransition(fn){if(document.startViewTransition===undefined){fn();return Promise.resolve()}else{const transition=document.startViewTransition(fn);return transition.finished}}