// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{LoadModelResultSpec as onDeviceModel_mojom_LoadModelResultSpec,OnDeviceModelPendingReceiver as onDeviceModel_mojom_OnDeviceModelPendingReceiver,SafetyInfoSpec as onDeviceModel_mojom_SafetyInfoSpec}from"./on_device_model.mojom-webui.js";import{FormatFeatureSpec as onDeviceModel_mojom_FormatFeatureSpec,SafetyFeatureSpec as onDeviceModel_mojom_SafetyFeatureSpec}from"./on_device_model_service.mojom-webui.js";import{SodaClientRemote as chromeos_machineLearning_mojom_SodaClientRemote,SodaRecognizerPendingReceiver as chromeos_machineLearning_mojom_SodaRecognizerPendingReceiver}from"./soda.mojom-webui.js";import{String16Spec as mojoBase_mojom_String16Spec}from"//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import{UuidSpec as mojoBase_mojom_UuidSpec}from"//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js";export const ModelStateTypeSpec={$:mojo.internal.Enum()};export var ModelStateType;(function(ModelStateType){ModelStateType[ModelStateType["MIN_VALUE"]=0]="MIN_VALUE";ModelStateType[ModelStateType["MAX_VALUE"]=5]="MAX_VALUE";ModelStateType[ModelStateType["kUnavailable"]=0]="kUnavailable";ModelStateType[ModelStateType["kNotInstalled"]=1]="kNotInstalled";ModelStateType[ModelStateType["kInstalling"]=2]="kInstalling";ModelStateType[ModelStateType["kInstalled"]=3]="kInstalled";ModelStateType[ModelStateType["kError"]=4]="kError";ModelStateType[ModelStateType["kNeedsReboot"]=5]="kNeedsReboot"})(ModelStateType||(ModelStateType={}));export class ModelStateMonitorPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.recorder_app.mojom.ModelStateMonitor",scope)}}export class ModelStateMonitorRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ModelStateMonitorPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}update(state){this.proxy.sendMessage(0,ModelStateMonitor_Update_ParamsSpec.$,null,[state],false)}}export class ModelStateMonitorReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ModelStateMonitorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,ModelStateMonitor_Update_ParamsSpec.$,null,impl.update.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class ModelStateMonitor{static get $interfaceName(){return"ash.recorder_app.mojom.ModelStateMonitor"}static getRemote(){let remote=new ModelStateMonitorRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class ModelStateMonitorCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ModelStateMonitorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.update=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,ModelStateMonitor_Update_ParamsSpec.$,null,this.update.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class QuietModeMonitorPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.recorder_app.mojom.QuietModeMonitor",scope)}}export class QuietModeMonitorRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(QuietModeMonitorPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}update(inQuietMode){this.proxy.sendMessage(0,QuietModeMonitor_Update_ParamsSpec.$,null,[inQuietMode],false)}}export class QuietModeMonitorReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(QuietModeMonitorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,QuietModeMonitor_Update_ParamsSpec.$,null,impl.update.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class QuietModeMonitor{static get $interfaceName(){return"ash.recorder_app.mojom.QuietModeMonitor"}static getRemote(){let remote=new QuietModeMonitorRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class QuietModeMonitorCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(QuietModeMonitorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.update=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,QuietModeMonitor_Update_ParamsSpec.$,null,this.update.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PageHandlerPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.recorder_app.mojom.PageHandler",scope)}}export class PageHandlerRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getModelInfo(feature){return this.proxy.sendMessage(0,PageHandler_GetModelInfo_ParamsSpec.$,PageHandler_GetModelInfo_ResponseParamsSpec.$,[feature],false)}loadModel(modelId,model){return this.proxy.sendMessage(1,PageHandler_LoadModel_ParamsSpec.$,PageHandler_LoadModel_ResponseParamsSpec.$,[modelId,model],false)}formatModelInput(uuid,feature,fields){return this.proxy.sendMessage(2,PageHandler_FormatModelInput_ParamsSpec.$,PageHandler_FormatModelInput_ResponseParamsSpec.$,[uuid,feature,fields],false)}validateSafetyResult(safetyFeature,text,safetyInfo){return this.proxy.sendMessage(3,PageHandler_ValidateSafetyResult_ParamsSpec.$,PageHandler_ValidateSafetyResult_ResponseParamsSpec.$,[safetyFeature,text,safetyInfo],false)}addModelMonitor(modelId,monitor){return this.proxy.sendMessage(4,PageHandler_AddModelMonitor_ParamsSpec.$,PageHandler_AddModelMonitor_ResponseParamsSpec.$,[modelId,monitor],false)}getAvailableLangPacks(){return this.proxy.sendMessage(5,PageHandler_GetAvailableLangPacks_ParamsSpec.$,PageHandler_GetAvailableLangPacks_ResponseParamsSpec.$,[],false)}getDefaultLanguage(){return this.proxy.sendMessage(6,PageHandler_GetDefaultLanguage_ParamsSpec.$,PageHandler_GetDefaultLanguage_ResponseParamsSpec.$,[],false)}addSodaMonitor(language,monitor){return this.proxy.sendMessage(7,PageHandler_AddSodaMonitor_ParamsSpec.$,PageHandler_AddSodaMonitor_ResponseParamsSpec.$,[language,monitor],false)}installSoda(language){return this.proxy.sendMessage(8,PageHandler_InstallSoda_ParamsSpec.$,PageHandler_InstallSoda_ResponseParamsSpec.$,[language],false)}loadSpeechRecognizer(language,sodaClient,sodaRecognizer){return this.proxy.sendMessage(9,PageHandler_LoadSpeechRecognizer_ParamsSpec.$,PageHandler_LoadSpeechRecognizer_ResponseParamsSpec.$,[language,sodaClient,sodaRecognizer],false)}openAiFeedbackDialog(descriptionTemplate){this.proxy.sendMessage(10,PageHandler_OpenAiFeedbackDialog_ParamsSpec.$,null,[descriptionTemplate],false)}getMicrophoneInfo(sourceId){return this.proxy.sendMessage(11,PageHandler_GetMicrophoneInfo_ParamsSpec.$,PageHandler_GetMicrophoneInfo_ResponseParamsSpec.$,[sourceId],false)}addQuietModeMonitor(monitor){return this.proxy.sendMessage(12,PageHandler_AddQuietModeMonitor_ParamsSpec.$,PageHandler_AddQuietModeMonitor_ResponseParamsSpec.$,[monitor],false)}setQuietMode(quietMode){this.proxy.sendMessage(13,PageHandler_SetQuietMode_ParamsSpec.$,null,[quietMode],false)}canUseSpeakerLabel(){return this.proxy.sendMessage(14,PageHandler_CanUseSpeakerLabel_ParamsSpec.$,PageHandler_CanUseSpeakerLabel_ResponseParamsSpec.$,[],false)}recordSpeakerLabelConsent(consentGiven,consentDescriptionNames,consentConfirmationName){this.proxy.sendMessage(15,PageHandler_RecordSpeakerLabelConsent_ParamsSpec.$,null,[consentGiven,consentDescriptionNames,consentConfirmationName],false)}canCaptureSystemAudioWithLoopback(){return this.proxy.sendMessage(16,PageHandler_CanCaptureSystemAudioWithLoopback_ParamsSpec.$,PageHandler_CanCaptureSystemAudioWithLoopback_ResponseParamsSpec.$,[],false)}}export class PageHandlerReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandler_GetModelInfo_ParamsSpec.$,PageHandler_GetModelInfo_ResponseParamsSpec.$,impl.getModelInfo.bind(impl),false);this.helper_internal_.registerHandler(1,PageHandler_LoadModel_ParamsSpec.$,PageHandler_LoadModel_ResponseParamsSpec.$,impl.loadModel.bind(impl),false);this.helper_internal_.registerHandler(2,PageHandler_FormatModelInput_ParamsSpec.$,PageHandler_FormatModelInput_ResponseParamsSpec.$,impl.formatModelInput.bind(impl),false);this.helper_internal_.registerHandler(3,PageHandler_ValidateSafetyResult_ParamsSpec.$,PageHandler_ValidateSafetyResult_ResponseParamsSpec.$,impl.validateSafetyResult.bind(impl),false);this.helper_internal_.registerHandler(4,PageHandler_AddModelMonitor_ParamsSpec.$,PageHandler_AddModelMonitor_ResponseParamsSpec.$,impl.addModelMonitor.bind(impl),false);this.helper_internal_.registerHandler(5,PageHandler_GetAvailableLangPacks_ParamsSpec.$,PageHandler_GetAvailableLangPacks_ResponseParamsSpec.$,impl.getAvailableLangPacks.bind(impl),false);this.helper_internal_.registerHandler(6,PageHandler_GetDefaultLanguage_ParamsSpec.$,PageHandler_GetDefaultLanguage_ResponseParamsSpec.$,impl.getDefaultLanguage.bind(impl),false);this.helper_internal_.registerHandler(7,PageHandler_AddSodaMonitor_ParamsSpec.$,PageHandler_AddSodaMonitor_ResponseParamsSpec.$,impl.addSodaMonitor.bind(impl),false);this.helper_internal_.registerHandler(8,PageHandler_InstallSoda_ParamsSpec.$,PageHandler_InstallSoda_ResponseParamsSpec.$,impl.installSoda.bind(impl),false);this.helper_internal_.registerHandler(9,PageHandler_LoadSpeechRecognizer_ParamsSpec.$,PageHandler_LoadSpeechRecognizer_ResponseParamsSpec.$,impl.loadSpeechRecognizer.bind(impl),false);this.helper_internal_.registerHandler(10,PageHandler_OpenAiFeedbackDialog_ParamsSpec.$,null,impl.openAiFeedbackDialog.bind(impl),false);this.helper_internal_.registerHandler(11,PageHandler_GetMicrophoneInfo_ParamsSpec.$,PageHandler_GetMicrophoneInfo_ResponseParamsSpec.$,impl.getMicrophoneInfo.bind(impl),false);this.helper_internal_.registerHandler(12,PageHandler_AddQuietModeMonitor_ParamsSpec.$,PageHandler_AddQuietModeMonitor_ResponseParamsSpec.$,impl.addQuietModeMonitor.bind(impl),false);this.helper_internal_.registerHandler(13,PageHandler_SetQuietMode_ParamsSpec.$,null,impl.setQuietMode.bind(impl),false);this.helper_internal_.registerHandler(14,PageHandler_CanUseSpeakerLabel_ParamsSpec.$,PageHandler_CanUseSpeakerLabel_ResponseParamsSpec.$,impl.canUseSpeakerLabel.bind(impl),false);this.helper_internal_.registerHandler(15,PageHandler_RecordSpeakerLabelConsent_ParamsSpec.$,null,impl.recordSpeakerLabelConsent.bind(impl),false);this.helper_internal_.registerHandler(16,PageHandler_CanCaptureSystemAudioWithLoopback_ParamsSpec.$,PageHandler_CanCaptureSystemAudioWithLoopback_ResponseParamsSpec.$,impl.canCaptureSystemAudioWithLoopback.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandler{static get $interfaceName(){return"ash.recorder_app.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getModelInfo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandler_GetModelInfo_ParamsSpec.$,PageHandler_GetModelInfo_ResponseParamsSpec.$,this.getModelInfo.createReceiverHandler(true),false);this.loadModel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PageHandler_LoadModel_ParamsSpec.$,PageHandler_LoadModel_ResponseParamsSpec.$,this.loadModel.createReceiverHandler(true),false);this.formatModelInput=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PageHandler_FormatModelInput_ParamsSpec.$,PageHandler_FormatModelInput_ResponseParamsSpec.$,this.formatModelInput.createReceiverHandler(true),false);this.validateSafetyResult=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PageHandler_ValidateSafetyResult_ParamsSpec.$,PageHandler_ValidateSafetyResult_ResponseParamsSpec.$,this.validateSafetyResult.createReceiverHandler(true),false);this.addModelMonitor=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PageHandler_AddModelMonitor_ParamsSpec.$,PageHandler_AddModelMonitor_ResponseParamsSpec.$,this.addModelMonitor.createReceiverHandler(true),false);this.getAvailableLangPacks=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PageHandler_GetAvailableLangPacks_ParamsSpec.$,PageHandler_GetAvailableLangPacks_ResponseParamsSpec.$,this.getAvailableLangPacks.createReceiverHandler(true),false);this.getDefaultLanguage=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,PageHandler_GetDefaultLanguage_ParamsSpec.$,PageHandler_GetDefaultLanguage_ResponseParamsSpec.$,this.getDefaultLanguage.createReceiverHandler(true),false);this.addSodaMonitor=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,PageHandler_AddSodaMonitor_ParamsSpec.$,PageHandler_AddSodaMonitor_ResponseParamsSpec.$,this.addSodaMonitor.createReceiverHandler(true),false);this.installSoda=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,PageHandler_InstallSoda_ParamsSpec.$,PageHandler_InstallSoda_ResponseParamsSpec.$,this.installSoda.createReceiverHandler(true),false);this.loadSpeechRecognizer=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,PageHandler_LoadSpeechRecognizer_ParamsSpec.$,PageHandler_LoadSpeechRecognizer_ResponseParamsSpec.$,this.loadSpeechRecognizer.createReceiverHandler(true),false);this.openAiFeedbackDialog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,PageHandler_OpenAiFeedbackDialog_ParamsSpec.$,null,this.openAiFeedbackDialog.createReceiverHandler(false),false);this.getMicrophoneInfo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,PageHandler_GetMicrophoneInfo_ParamsSpec.$,PageHandler_GetMicrophoneInfo_ResponseParamsSpec.$,this.getMicrophoneInfo.createReceiverHandler(true),false);this.addQuietModeMonitor=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,PageHandler_AddQuietModeMonitor_ParamsSpec.$,PageHandler_AddQuietModeMonitor_ResponseParamsSpec.$,this.addQuietModeMonitor.createReceiverHandler(true),false);this.setQuietMode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,PageHandler_SetQuietMode_ParamsSpec.$,null,this.setQuietMode.createReceiverHandler(false),false);this.canUseSpeakerLabel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,PageHandler_CanUseSpeakerLabel_ParamsSpec.$,PageHandler_CanUseSpeakerLabel_ResponseParamsSpec.$,this.canUseSpeakerLabel.createReceiverHandler(true),false);this.recordSpeakerLabelConsent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,PageHandler_RecordSpeakerLabelConsent_ParamsSpec.$,null,this.recordSpeakerLabelConsent.createReceiverHandler(false),false);this.canCaptureSystemAudioWithLoopback=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,PageHandler_CanCaptureSystemAudioWithLoopback_ParamsSpec.$,PageHandler_CanCaptureSystemAudioWithLoopback_ResponseParamsSpec.$,this.canCaptureSystemAudioWithLoopback.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const ModelStateSpec={$:{}};export const ModelInfoSpec={$:{}};export const MicrophoneInfoSpec={$:{}};export const LangPackInfoSpec={$:{}};export const ModelStateMonitor_Update_ParamsSpec={$:{}};export const QuietModeMonitor_Update_ParamsSpec={$:{}};export const PageHandler_GetModelInfo_ParamsSpec={$:{}};export const PageHandler_GetModelInfo_ResponseParamsSpec={$:{}};export const PageHandler_LoadModel_ParamsSpec={$:{}};export const PageHandler_LoadModel_ResponseParamsSpec={$:{}};export const PageHandler_FormatModelInput_ParamsSpec={$:{}};export const PageHandler_FormatModelInput_ResponseParamsSpec={$:{}};export const PageHandler_ValidateSafetyResult_ParamsSpec={$:{}};export const PageHandler_ValidateSafetyResult_ResponseParamsSpec={$:{}};export const PageHandler_AddModelMonitor_ParamsSpec={$:{}};export const PageHandler_AddModelMonitor_ResponseParamsSpec={$:{}};export const PageHandler_GetAvailableLangPacks_ParamsSpec={$:{}};export const PageHandler_GetAvailableLangPacks_ResponseParamsSpec={$:{}};export const PageHandler_GetDefaultLanguage_ParamsSpec={$:{}};export const PageHandler_GetDefaultLanguage_ResponseParamsSpec={$:{}};export const PageHandler_AddSodaMonitor_ParamsSpec={$:{}};export const PageHandler_AddSodaMonitor_ResponseParamsSpec={$:{}};export const PageHandler_InstallSoda_ParamsSpec={$:{}};export const PageHandler_InstallSoda_ResponseParamsSpec={$:{}};export const PageHandler_LoadSpeechRecognizer_ParamsSpec={$:{}};export const PageHandler_LoadSpeechRecognizer_ResponseParamsSpec={$:{}};export const PageHandler_OpenAiFeedbackDialog_ParamsSpec={$:{}};export const PageHandler_GetMicrophoneInfo_ParamsSpec={$:{}};export const PageHandler_GetMicrophoneInfo_ResponseParamsSpec={$:{}};export const PageHandler_AddQuietModeMonitor_ParamsSpec={$:{}};export const PageHandler_AddQuietModeMonitor_ResponseParamsSpec={$:{}};export const PageHandler_SetQuietMode_ParamsSpec={$:{}};export const PageHandler_CanUseSpeakerLabel_ParamsSpec={$:{}};export const PageHandler_CanUseSpeakerLabel_ResponseParamsSpec={$:{}};export const PageHandler_RecordSpeakerLabelConsent_ParamsSpec={$:{}};export const PageHandler_CanCaptureSystemAudioWithLoopback_ParamsSpec={$:{}};export const PageHandler_CanCaptureSystemAudioWithLoopback_ResponseParamsSpec={$:{}};mojo.internal.Struct(ModelStateSpec.$,"ModelState",[mojo.internal.StructField("type",0,0,ModelStateTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("progress_$flag",4,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"progress_$value",originalFieldName:"progress"},undefined),mojo.internal.StructField("progress_$value",5,0,mojo.internal.Uint8,0,false,0,{isPrimary:false,originalFieldName:"progress"},undefined)],[[0,16]]);mojo.internal.Struct(ModelInfoSpec.$,"ModelInfo",[mojo.internal.StructField("modelId",0,0,mojoBase_mojom_UuidSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("inputTokenLimit",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("isLargeModel",12,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MicrophoneInfoSpec.$,"MicrophoneInfo",[mojo.internal.StructField("isDefault",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isInternal",0,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LangPackInfoSpec.$,"LangPackInfo",[mojo.internal.StructField("languageCode",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("displayName",8,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isGenAiSupported",16,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isSpeakerLabelSupported",16,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ModelStateMonitor_Update_ParamsSpec.$,"ModelStateMonitor_Update_Params",[mojo.internal.StructField("state",0,0,ModelStateSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(QuietModeMonitor_Update_ParamsSpec.$,"QuietModeMonitor_Update_Params",[mojo.internal.StructField("inQuietMode",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetModelInfo_ParamsSpec.$,"PageHandler_GetModelInfo_Params",[mojo.internal.StructField("feature",0,0,onDeviceModel_mojom_FormatFeatureSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetModelInfo_ResponseParamsSpec.$,"PageHandler_GetModelInfo_ResponseParams",[mojo.internal.StructField("modelInfo",0,0,ModelInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_LoadModel_ParamsSpec.$,"PageHandler_LoadModel_Params",[mojo.internal.StructField("modelId",0,0,mojoBase_mojom_UuidSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("model",8,0,mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_LoadModel_ResponseParamsSpec.$,"PageHandler_LoadModel_ResponseParams",[mojo.internal.StructField("result",0,0,onDeviceModel_mojom_LoadModelResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_FormatModelInput_ParamsSpec.$,"PageHandler_FormatModelInput_Params",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_UuidSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("feature",8,0,onDeviceModel_mojom_FormatFeatureSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("fields",16,0,mojo.internal.Map(mojo.internal.String,mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_FormatModelInput_ResponseParamsSpec.$,"PageHandler_FormatModelInput_ResponseParams",[mojo.internal.StructField("result",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ValidateSafetyResult_ParamsSpec.$,"PageHandler_ValidateSafetyResult_Params",[mojo.internal.StructField("safetyFeature",0,0,onDeviceModel_mojom_SafetyFeatureSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("text",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("safetyInfo",16,0,onDeviceModel_mojom_SafetyInfoSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_ValidateSafetyResult_ResponseParamsSpec.$,"PageHandler_ValidateSafetyResult_ResponseParams",[mojo.internal.StructField("isSafe",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddModelMonitor_ParamsSpec.$,"PageHandler_AddModelMonitor_Params",[mojo.internal.StructField("modelId",0,0,mojoBase_mojom_UuidSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("monitor",8,0,mojo.internal.InterfaceProxy(ModelStateMonitorRemote),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_AddModelMonitor_ResponseParamsSpec.$,"PageHandler_AddModelMonitor_ResponseParams",[mojo.internal.StructField("state",0,0,ModelStateSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetAvailableLangPacks_ParamsSpec.$,"PageHandler_GetAvailableLangPacks_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetAvailableLangPacks_ResponseParamsSpec.$,"PageHandler_GetAvailableLangPacks_ResponseParams",[mojo.internal.StructField("langPacks",0,0,mojo.internal.Array(LangPackInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetDefaultLanguage_ParamsSpec.$,"PageHandler_GetDefaultLanguage_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetDefaultLanguage_ResponseParamsSpec.$,"PageHandler_GetDefaultLanguage_ResponseParams",[mojo.internal.StructField("languageCode",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddSodaMonitor_ParamsSpec.$,"PageHandler_AddSodaMonitor_Params",[mojo.internal.StructField("language",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("monitor",8,0,mojo.internal.InterfaceProxy(ModelStateMonitorRemote),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_AddSodaMonitor_ResponseParamsSpec.$,"PageHandler_AddSodaMonitor_ResponseParams",[mojo.internal.StructField("state",0,0,ModelStateSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_InstallSoda_ParamsSpec.$,"PageHandler_InstallSoda_Params",[mojo.internal.StructField("language",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_InstallSoda_ResponseParamsSpec.$,"PageHandler_InstallSoda_ResponseParams",[],[[0,8]]);mojo.internal.Struct(PageHandler_LoadSpeechRecognizer_ParamsSpec.$,"PageHandler_LoadSpeechRecognizer_Params",[mojo.internal.StructField("language",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("sodaClient",8,0,mojo.internal.InterfaceProxy(chromeos_machineLearning_mojom_SodaClientRemote),null,false,0,undefined,undefined),mojo.internal.StructField("sodaRecognizer",16,0,mojo.internal.InterfaceRequest(chromeos_machineLearning_mojom_SodaRecognizerPendingReceiver),null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_LoadSpeechRecognizer_ResponseParamsSpec.$,"PageHandler_LoadSpeechRecognizer_ResponseParams",[mojo.internal.StructField("result",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenAiFeedbackDialog_ParamsSpec.$,"PageHandler_OpenAiFeedbackDialog_Params",[mojo.internal.StructField("descriptionTemplate",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetMicrophoneInfo_ParamsSpec.$,"PageHandler_GetMicrophoneInfo_Params",[mojo.internal.StructField("sourceId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetMicrophoneInfo_ResponseParamsSpec.$,"PageHandler_GetMicrophoneInfo_ResponseParams",[mojo.internal.StructField("info",0,0,MicrophoneInfoSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddQuietModeMonitor_ParamsSpec.$,"PageHandler_AddQuietModeMonitor_Params",[mojo.internal.StructField("monitor",0,0,mojo.internal.InterfaceProxy(QuietModeMonitorRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddQuietModeMonitor_ResponseParamsSpec.$,"PageHandler_AddQuietModeMonitor_ResponseParams",[mojo.internal.StructField("inQuietMode",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetQuietMode_ParamsSpec.$,"PageHandler_SetQuietMode_Params",[mojo.internal.StructField("quietMode",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_CanUseSpeakerLabel_ParamsSpec.$,"PageHandler_CanUseSpeakerLabel_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_CanUseSpeakerLabel_ResponseParamsSpec.$,"PageHandler_CanUseSpeakerLabel_ResponseParams",[mojo.internal.StructField("supported",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RecordSpeakerLabelConsent_ParamsSpec.$,"PageHandler_RecordSpeakerLabelConsent_Params",[mojo.internal.StructField("consentGiven",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("consentDescriptionNames",8,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("consentConfirmationName",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_CanCaptureSystemAudioWithLoopback_ParamsSpec.$,"PageHandler_CanCaptureSystemAudioWithLoopback_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_CanCaptureSystemAudioWithLoopback_ResponseParamsSpec.$,"PageHandler_CanCaptureSystemAudioWithLoopback_ResponseParams",[mojo.internal.StructField("supported",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);