// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{ModelExecutionError,ModelLoadError}from"../../core/on_device_model/types.js";import{bindSignal}from"../../core/reactive/local_storage.js";import{effect,signal}from"../../core/reactive/signal.js";import*as localStorage from"../../core/utils/local_storage.js";import{z}from"../../core/utils/schema.js";export var ColorTheme;(function(ColorTheme){ColorTheme["SYSTEM"]="system";ColorTheme["LIGHT"]="light";ColorTheme["DARK"]="dark"})(ColorTheme||(ColorTheme={}));export const devSettingsSchema=z.object({forceLanguageSelection:z.boolean(),forceTheme:z.optional(z.nativeEnum(ColorTheme)),forceGenAiModelExecutionError:z.withDefault(z.nullable(z.nativeEnum(ModelExecutionError)),null),forceGenAiModelLoadError:z.withDefault(z.nullable(z.nativeEnum(ModelLoadError)),null),genAiInstalled:z.withDefault(z.boolean(),false),sodaInstalled:z.boolean(),canUseSpeakerLabel:z.boolean(),canCaptureSystemAudioWithLoopback:z.boolean()});const defaultSettings={forceLanguageSelection:false,forceTheme:ColorTheme.LIGHT,forceGenAiModelExecutionError:null,forceGenAiModelLoadError:null,genAiInstalled:false,sodaInstalled:false,canUseSpeakerLabel:true,canCaptureSystemAudioWithLoopback:true};export const devSettings=signal(defaultSettings);const DEV_CSS=`\n:root.force-dark {\n  --dark-theme: 1;\n}\n:root.force-light {\n  --dark-theme: 0;\n}\n`;export function init(){const style=document.createElement("style");style.textContent=DEV_CSS;document.head.appendChild(style);bindSignal(devSettings,localStorage.Key.DEV_SETTINGS,devSettingsSchema,defaultSettings);effect((()=>{document.documentElement.classList.toggle("force-dark",devSettings.value.forceTheme===ColorTheme.DARK);document.documentElement.classList.toggle("force-light",devSettings.value.forceTheme===ColorTheme.LIGHT)}))}