// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{nothing}from"chrome://resources/mwc/lit/index.js";import{PerfLogger}from"../../core/perf.js";import{PlatformHandler as PlatformHandlerBase}from"../../core/platform_handler.js";import{computed,signal}from"../../core/reactive/signal.js";import{LanguageCode}from"../../core/soda/language_info.js";import{assertEnumVariant,assertExists,assertInstanceof,checkEnumVariant}from"../../core/utils/assert.js";import{parseTopFrameInfo}from"../../core/utils/errors.js";import{lazyInit}from"../../core/utils/utils.js";import{EventsSender}from"./metrics.js";import{mojoModelStateToModelState,SummaryModelLoader,TitleSuggestionModelLoader}from"./on_device_model.js";import{MojoSodaSession}from"./soda_session.js";import{ModelStateMonitorReceiver,PageHandler as MojoPageHandler,QuietModeMonitorReceiver,SodaClientReceiver,SodaRecognizerRemote}from"./types.js";const CRASH_SERVER_PRODUCT_NAME="ChromeOS_RecorderApp";export class PlatformHandler extends PlatformHandlerBase{static getStringF(id,...args){return loadTimeData.getStringF(id,...args)}static getDeviceType(){return loadTimeData.getStringF("deviceType")}constructor(){super();this.remote=MojoPageHandler.getRemote();this.sodaStates=new Map;this.langPacks=new Map;this.defaultLanguage=LanguageCode.EN_US;this.quietModeInternal=signal(false);this.canUseSpeakerLabel=signal(false);this.canCaptureSystemAudioWithLoopback=signal(false);this.eventsSender=new EventsSender;this.perfLogger=new PerfLogger(this.eventsSender);this.getLangPackList=lazyInit((()=>Array.from(this.langPacks.values())));this.summaryModelLoader=new SummaryModelLoader(this.remote,this);this.titleSuggestionModelLoader=new TitleSuggestionModelLoader(this.remote,this);this.quietMode=computed({get:()=>this.quietModeInternal.value,set:quietMode=>{this.remote.setQuietMode(quietMode);this.quietModeInternal.value=quietMode}})}mojoLangPackInfoToLangPackInfo(langPack){const languageCode=checkEnumVariant(LanguageCode,langPack.languageCode);if(languageCode===null){return null}return{languageCode:languageCode,displayName:langPack.displayName,isGenAiSupported:langPack.isGenAiSupported,isSpeakerLabelSupported:langPack.isSpeakerLabelSupported}}async init(){ColorChangeUpdater.forDocument().start();this.canUseSpeakerLabel.value=(await this.remote.canUseSpeakerLabel()).supported;this.canCaptureSystemAudioWithLoopback.value=(await this.remote.canCaptureSystemAudioWithLoopback()).supported;const mojoLangPacks=(await this.remote.getAvailableLangPacks()).langPacks;for(const mojoLangPack of mojoLangPacks){const langPack=this.mojoLangPackInfoToLangPackInfo(mojoLangPack);if(langPack===null){continue}this.langPacks.set(langPack.languageCode,langPack)}for(const language of this.langPacks.keys()){const sodaState=signal({kind:"unavailable"});this.sodaStates.set(language,sodaState);function update(state){sodaState.value=mojoModelStateToModelState(state)}const monitor=new ModelStateMonitorReceiver({update:update});const{state:state}=await this.remote.addSodaMonitor(language,monitor.$.bindNewPipeAndPassRemote());update(state)}const languageCodeString=(await this.remote.getDefaultLanguage()).languageCode;const languageCode=assertEnumVariant(LanguageCode,languageCodeString);if(this.getSodaState(languageCode).value.kind!=="unavailable"){this.defaultLanguage=languageCode}const quietModeMonitor=new QuietModeMonitorReceiver({update:inQuietMode=>{this.quietModeInternal.value=inQuietMode}});const{inQuietMode:inQuietMode}=await this.remote.addQuietModeMonitor(quietModeMonitor.$.bindNewPipeAndPassRemote());this.quietModeInternal.value=inQuietMode;await this.summaryModelLoader.init();await this.titleSuggestionModelLoader.init();this.initPerfEventWatchers()}getDefaultLanguage(){return this.defaultLanguage}getLangPackInfo(language){return assertExists(this.langPacks.get(language))}isMultipleLanguageAvailable(){let count=0;for(const state of this.sodaStates.values()){if(state.value.kind!=="unavailable"){count+=1}}return count>1}async installSoda(language){await this.remote.installSoda(language)}isSodaAvailable(){for(const state of this.sodaStates.values()){if(state.value.kind!=="unavailable"){return true}}return false}getSodaState(language){return assertExists(this.sodaStates.get(language))}async newSodaSession(language){const recognizer=new SodaRecognizerRemote;const session=new MojoSodaSession(recognizer);const client=new SodaClientReceiver(session);const{result:result}=await this.remote.loadSpeechRecognizer(language,client.$.bindNewPipeAndPassRemote(),recognizer.$.bindNewPipeAndPassReceiver());if(!result){throw new Error("Load soda failed")}return session}async getMicrophoneInfo(deviceId){const info=(await this.remote.getMicrophoneInfo(deviceId)).info;return info??{isDefault:false,isInternal:false}}renderDevUi(){return nothing}handleUncaughtError(errorRaw){const error=assertInstanceof(errorRaw,Error);const stackStr=error.stack??"";const{lineNo:lineNo,colNo:colNo}=parseTopFrameInfo(stackStr);chrome.crashReportPrivate.reportError({product:CRASH_SERVER_PRODUCT_NAME,url:self.location.href,message:`${error.name}: ${error.message}`,lineNumber:lineNo,stackTrace:stackStr,columnNumber:colNo},(()=>{}))}showAiFeedbackDialog(description){this.remote.openAiFeedbackDialog(description)}async getSystemAudioMediaStream(){return navigator.mediaDevices.getDisplayMedia({video:false,audio:{autoGainControl:{ideal:false},echoCancellation:{ideal:false},noiseSuppression:{ideal:false}},systemAudio:"include"})}recordSpeakerLabelConsent(consentGiven,consentDescriptionNames,consentConfirmationName){this.remote.recordSpeakerLabelConsent(consentGiven,consentDescriptionNames,consentConfirmationName)}}