// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assertExists}from"../../core/utils/assert.js";export function parseResponse(res){return res.replaceAll("▁"," ").replaceAll(/\n+/g,"\n").trim()}export function isCannedResponse(response){const commonLeadingCannedPhrases=["Sorry, I’m a","Sorry, I am a"];return commonLeadingCannedPhrases.some((phrase=>response.trimStart().startsWith(phrase)))}export function isInvalidFormatResponse(response,expectedBulletPointCount){const bulletPoints=response.split("\n");if(bulletPoints.length!==expectedBulletPointCount){return true}return bulletPoints.some((bulletPoint=>!bulletPoint.trimStart().startsWith("- ")))}export function trimRepeatedBulletPoints(response,maxLength,language,lcsScoreThreshold){const bulletPoints=response.split("\n");bulletPoints.sort(((b1,b2)=>b2.length-b1.length));const repeatedIndexSet=getRepeatedBulletPointIndexes(bulletPoints,maxLength,lcsScoreThreshold,language);return bulletPoints.filter(((point,index)=>segmentStringToWords(point,language).length>0&&!repeatedIndexSet.has(index)))}function getRepeatedBulletPointIndexes(bulletPoints,maxLength,lcsScoreThreshold,language){const repeatedIndexSet=new Set;for(const[i,bulletPoint]of bulletPoints.entries()){if(repeatedIndexSet.has(i)){continue}if(bulletPoint.length>maxLength){repeatedIndexSet.add(i);continue}for(let j=i-1;j>=0;j--){if(repeatedIndexSet.has(j)){continue}const otherBulletPoint=assertExists(bulletPoints[j]);if(getLcsScore(bulletPoint,otherBulletPoint,language)>lcsScoreThreshold){repeatedIndexSet.add(i);break}}}return repeatedIndexSet}function getLcsScore(str1,str2,language){const words1=segmentStringToWords(str1,language);const words2=segmentStringToWords(str2,language);const len1=words1.length;const len2=words2.length;if(len1===0||len2===0){return 0}const dp=Array.from({length:len1+1},(()=>Array.from({length:len2+1},(()=>0))));for(let i=1;i<=len1;i++){for(let j=1;j<=len2;j++){if(words1[i-1]===words2[j-1]){dp[i][j]=dp[i-1][j-1]+1}else{dp[i][j]=Math.max(dp[i-1][j],dp[i][j-1])}}}return dp[len1][len2]/Math.min(len1,len2)}function segmentStringToWords(str,language){const segmenter=new Intl.Segmenter(language,{granularity:"word"});const segments=segmenter.segment(str);const words=[];for(const segment of segments){if(segment.isWordLike===true){words.push(segment.segment)}}return words}