// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{ObserverList}from"../../core/utils/observer_list.js";import{clamp}from"../../core/utils/utils.js";import{WaitableEvent}from"../../core/utils/waitable_event.js";export class MojoSodaSession{constructor(recognizer){this.recognizer=recognizer;this.observers=new ObserverList;this.startEvent=new WaitableEvent;this.stopEvent=new WaitableEvent}async start(){this.recognizer.start();await this.startEvent.wait()}addAudio(samples){const scaledSamples=new Int16Array(samples.map((v=>clamp(Math.floor(v*32768),-32768,32767))));const toSend=Array.from(new Uint8Array(scaledSamples.buffer));this.recognizer.addAudio(toSend)}async stop(){this.recognizer.markDone();await this.stopEvent.wait()}subscribeEvent(observer){return this.observers.subscribe(observer)}onStart(){this.startEvent.signal()}onStop(){this.stopEvent.signal()}onSpeechRecognizerEvent(event){if(event.partialResult!==undefined){this.observers.notify({partialResult:event.partialResult})}else if(event.finalResult!==undefined){this.observers.notify({finalResult:event.finalResult})}else if(event.labelCorrectionEvent!==undefined){this.observers.notify({labelCorrectionEvent:event.labelCorrectionEvent})}}}