// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Creates `TranscriptionModelDownloadPerf` for given language.
 */
export function createTranscriptionModelDownloadPerf(transcriptionLocale) {
    return {
        kind: `transcriptionModelDownload-${transcriptionLocale}`,
        transcriptionLocale,
    };
}
/**
 * Checks if a `PerfEvent` is a `TranscriptionModelDownloadPerf`.
 */
export function isTranscriptionModelDownloadPerf(perfEvent) {
    return perfEvent.kind.startsWith('transcriptionModelDownload-');
}
export class EventsSender {
}
