// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { signal } from '../reactive/signal.js';
import { assert, assertExists } from '../utils/assert.js';
const context = signal(null);
/**
 * Initializes the context with a value.
 *
 * This should only be called once in initialization.
 */
export function initContext(c) {
    assert(context.value === null, 'Context should only be initialized once');
    context.value = c;
}
/**
 * Returns the current MicrophoneManager in context.
 */
export function useMicrophoneManager() {
    return assertExists(context.value).microphoneManager;
}
/**
 * Returns the current RecordingDataManager in context.
 */
export function useRecordingDataManager() {
    return assertExists(context.value).recordingDataManager;
}
/**
 * Returns the current PlatformHandler in context.
 */
export function usePlatformHandler() {
    return assertExists(context.value).platformHandler;
}
