// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { ComputedImpl, Effect, SignalImpl, } from './signal/impl.js';
/**
 * Creates a new signal with an initial value.
 */
export function signal(value) {
    return new SignalImpl(value);
}
/**
 * Creates a new computed signal with the given option.
 */
export function computed(getOrOptions) {
    if (typeof getOrOptions === 'function') {
        return new ComputedImpl(getOrOptions);
    }
    else {
        return new ComputedImpl(getOrOptions.get, getOrOptions.set);
    }
}
/**
 * Creates a new effect that would be run when dependent signals are changed.
 *
 * TODO(pihsun): Check if there's any case we need to expose the effect
 * instance.
 * TODO(pihsun): Pass callback to register cleanup functions on effect
 * re-trigger to the callback.
 */
export function effect(callback) {
    const effect = new Effect(callback);
    return () => {
        effect.dispose();
    };
}
/**
 * Batches all effects inside the callback to be run after this function
 * returns.
 */
export function batch(callback) {
    Effect.batchDepth += 1;
    try {
        callback();
    }
    finally {
        Effect.batchDepth -= 1;
        Effect.processBatchedEffect();
    }
}
