// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { z } from '../utils/schema.js';
// The type is manually constructed from the .mojo at
// chromeos/services/machine_learning/public/mojom/soda.mojom
export const timeDeltaSchema = z.object({
    microseconds: z.bigint(),
});
export const hypothesisPartSchema = z.object({
    text: z.array(z.string()),
    alignment: z.nullable(timeDeltaSchema),
    leadingSpace: z.nullable(z.boolean()),
    speakerLabel: z.nullable(z.string()),
});
export const timingInfoSchema = z.object({
    audioStartTime: timeDeltaSchema,
    eventEndTime: timeDeltaSchema,
});
export const finalResultSchema = z.object({
    finalHypotheses: z.array(z.string()),
    hypothesisPart: z.nullable(z.array(hypothesisPartSchema)),
    timingEvent: z.nullable(timingInfoSchema),
});
export const partialResultSchema = z.object({
    partialText: z.array(z.string()),
    hypothesisPart: z.nullable(z.array(hypothesisPartSchema)),
    timingEvent: z.nullable(timingInfoSchema),
});
export const speakerLabelCorrectionEventSchema = z.object({
    hypothesisParts: z.array(hypothesisPartSchema),
});
export const sodaEventSchema = z.union([
    z.object({
        finalResult: finalResultSchema,
    }),
    z.object({
        partialResult: partialResultSchema,
    }),
    z.object({
        labelCorrectionEvent: speakerLabelCorrectionEventSchema,
    }),
]);
