// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * A simple wrapper for requestAnimationFrame for starting / stopping the
 * requestAnimationFrame loop.
 *
 * Note that user should always ensure that `stop()` is called eventually before
 * the object reference is dropped.
 *
 * TODO(pihsun): Add back ReactiveController version if there's usage for it.
 */
export class AnimationFrameController {
    constructor(callback) {
        this.callback = callback;
        this.animationHandler = null;
    }
    start() {
        if (this.animationHandler === null) {
            this.animationHandler = requestAnimationFrame(() => {
                this.onAnimationFrame();
            });
        }
    }
    stop() {
        if (this.animationHandler !== null) {
            cancelAnimationFrame(this.animationHandler);
            this.animationHandler = null;
        }
    }
    onAnimationFrame() {
        this.callback();
        this.animationHandler = requestAnimationFrame(() => {
            this.onAnimationFrame();
        });
    }
}
