// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Keys for local storage.
 * Do not delete a key even if it's unused anymore to avoid confliction.
 */
export var Key;
(function (Key) {
    Key["SETTINGS"] = "settings";
    Key["SUMMARIZATION"] = "summarization";
    /**
     * Settings that are only used by dev mode.
     *
     * TODO(pihsun): Move this into platforms/dev/.
     */
    Key["DEV_SETTINGS"] = "dev-settings";
})(Key || (Key = {}));
/**
 * Gets a value from local storage.
 */
export function get(key, schema, defaultValue) {
    const item = window.localStorage.getItem(key);
    if (item === null) {
        return defaultValue;
    }
    return schema.parseJson(item);
}
/**
 * Sets a value in local storage.
 */
export function set(key, schema, value) {
    const item = schema.stringifyJson(value);
    window.localStorage.setItem(key, item);
}
/**
 * Removes a value in local storage.
 */
export function remove(key) {
    window.localStorage.removeItem(key);
}
