// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export class ObserverList {
    constructor() {
        this.observers = [];
    }
    subscribe(observer) {
        this.observers.push(observer);
        return () => {
            this.unsubscribe(observer);
        };
    }
    unsubscribe(observer) {
        const idx = this.observers.indexOf(observer);
        if (idx !== -1) {
            this.observers.splice(idx, 1);
        }
    }
    notify(val) {
        // Do a copy of observers in case any observer calls subscribe /
        // unsubscribe during the callback.
        for (const observer of [...this.observers]) {
            try {
                observer(val);
            }
            catch (error) {
                // Subscribers shouldn't fail, here we only log and continue to all
                // other subscribers.
                console.error(error);
            }
        }
    }
}
