// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * A waitable event for synchronization between asynchronous jobs.
 */
export class WaitableEvent {
    constructor() {
        this.isSignaledInternal = false;
        const { promise, resolve } = Promise.withResolvers();
        this.promise = promise;
        this.resolve = resolve;
    }
    isSignaled() {
        return this.isSignaledInternal;
    }
    /**
     * Signals the event.
     */
    signal(value) {
        if (this.isSignaledInternal) {
            return;
        }
        this.isSignaledInternal = true;
        this.resolve(value);
    }
    /**
     * @return Resolved when the event is signaled.
     */
    wait() {
        return this.promise;
    }
}
