// chromeos/services/machine_learning/public/mojom/soda.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { TimeSpec as mojoBase_mojom_TimeSpec, TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
export const OptionalBoolSpec = { $: mojo.internal.Enum() };
export var OptionalBool;
(function (OptionalBool) {
    OptionalBool[OptionalBool["MIN_VALUE"] = 0] = "MIN_VALUE";
    OptionalBool[OptionalBool["MAX_VALUE"] = 2] = "MAX_VALUE";
    OptionalBool[OptionalBool["kUnknown"] = 0] = "kUnknown";
    OptionalBool[OptionalBool["kFalse"] = 1] = "kFalse";
    OptionalBool[OptionalBool["kTrue"] = 2] = "kTrue";
})(OptionalBool || (OptionalBool = {}));
export const SodaRecognitionModeSpec = { $: mojo.internal.Enum() };
export var SodaRecognitionMode;
(function (SodaRecognitionMode) {
    SodaRecognitionMode[SodaRecognitionMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    SodaRecognitionMode[SodaRecognitionMode["MAX_VALUE"] = 1] = "MAX_VALUE";
    SodaRecognitionMode[SodaRecognitionMode["kCaption"] = 0] = "kCaption";
    SodaRecognitionMode[SodaRecognitionMode["kIme"] = 1] = "kIme";
})(SodaRecognitionMode || (SodaRecognitionMode = {}));
export const SpeakerDiarizationModeSpec = { $: mojo.internal.Enum() };
export var SpeakerDiarizationMode;
(function (SpeakerDiarizationMode) {
    SpeakerDiarizationMode[SpeakerDiarizationMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    SpeakerDiarizationMode[SpeakerDiarizationMode["MAX_VALUE"] = 3] = "MAX_VALUE";
    SpeakerDiarizationMode[SpeakerDiarizationMode["kDiarizationUnspecified"] = 0] = "kDiarizationUnspecified";
    SpeakerDiarizationMode[SpeakerDiarizationMode["kSpeakerDiarizationModeOffDefault"] = 1] = "kSpeakerDiarizationModeOffDefault";
    SpeakerDiarizationMode[SpeakerDiarizationMode["kSpeakerChangeDetection"] = 2] = "kSpeakerChangeDetection";
    SpeakerDiarizationMode[SpeakerDiarizationMode["kSpeakerLabelDetection"] = 3] = "kSpeakerLabelDetection";
})(SpeakerDiarizationMode || (SpeakerDiarizationMode = {}));
export const EndpointerTypeSpec = { $: mojo.internal.Enum() };
export var EndpointerType;
(function (EndpointerType) {
    EndpointerType[EndpointerType["MIN_VALUE"] = 0] = "MIN_VALUE";
    EndpointerType[EndpointerType["MAX_VALUE"] = 3] = "MAX_VALUE";
    EndpointerType[EndpointerType["START_OF_SPEECH"] = 0] = "START_OF_SPEECH";
    EndpointerType[EndpointerType["END_OF_SPEECH"] = 1] = "END_OF_SPEECH";
    EndpointerType[EndpointerType["END_OF_AUDIO"] = 2] = "END_OF_AUDIO";
    EndpointerType[EndpointerType["END_OF_UTTERANCE"] = 3] = "END_OF_UTTERANCE";
})(EndpointerType || (EndpointerType = {}));
export const EndpointReasonSpec = { $: mojo.internal.Enum() };
export var EndpointReason;
(function (EndpointReason) {
    EndpointReason[EndpointReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    EndpointReason[EndpointReason["MAX_VALUE"] = 3] = "MAX_VALUE";
    EndpointReason[EndpointReason["ENDPOINT_UNKNOWN"] = 0] = "ENDPOINT_UNKNOWN";
    EndpointReason[EndpointReason["ENDPOINT_END_OF_SPEECH"] = 1] = "ENDPOINT_END_OF_SPEECH";
    EndpointReason[EndpointReason["ENDPOINT_END_OF_UTTERANCE"] = 2] = "ENDPOINT_END_OF_UTTERANCE";
    EndpointReason[EndpointReason["ENDPOINT_END_OF_AUDIO"] = 3] = "ENDPOINT_END_OF_AUDIO";
})(EndpointReason || (EndpointReason = {}));
export const AsrSwitchResultSpec = { $: mojo.internal.Enum() };
export var AsrSwitchResult;
(function (AsrSwitchResult) {
    AsrSwitchResult[AsrSwitchResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    AsrSwitchResult[AsrSwitchResult["MAX_VALUE"] = 3] = "MAX_VALUE";
    AsrSwitchResult[AsrSwitchResult["DEFAULT_NO_SWITCH"] = 0] = "DEFAULT_NO_SWITCH";
    AsrSwitchResult[AsrSwitchResult["SWITCH_SUCCEEDED"] = 1] = "SWITCH_SUCCEEDED";
    AsrSwitchResult[AsrSwitchResult["SWITCH_FAILED"] = 2] = "SWITCH_FAILED";
    AsrSwitchResult[AsrSwitchResult["SWITCH_SKIPPED_NO_LP"] = 3] = "SWITCH_SKIPPED_NO_LP";
})(AsrSwitchResult || (AsrSwitchResult = {}));
export class SodaClientPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'chromeos.machine_learning.mojom.SodaClient', scope);
    }
}
export class SodaClientRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SodaClientPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onStart() {
        this.proxy.sendMessage(0, SodaClient_OnStart_ParamsSpec.$, null, [], false);
    }
    onStop() {
        this.proxy.sendMessage(1, SodaClient_OnStop_ParamsSpec.$, null, [], false);
    }
    onSpeechRecognizerEvent(event) {
        this.proxy.sendMessage(2, SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$, null, [
            event
        ], false);
    }
}
;
/**
 * An object which receives request messages for the SodaClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SodaClientReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SodaClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SodaClient_OnStart_ParamsSpec.$, null, impl.onStart.bind(impl), false);
        this.helper_internal_.registerHandler(1, SodaClient_OnStop_ParamsSpec.$, null, impl.onStop.bind(impl), false);
        this.helper_internal_.registerHandler(2, SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$, null, impl.onSpeechRecognizerEvent.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SodaClient {
    static get $interfaceName() {
        return "chromeos.machine_learning.mojom.SodaClient";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SodaClientRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SodaClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SodaClientCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SodaClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onStart =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SodaClient_OnStart_ParamsSpec.$, null, this.onStart.createReceiverHandler(false /* expectsResponse */), false);
        this.onStop =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, SodaClient_OnStop_ParamsSpec.$, null, this.onStop.createReceiverHandler(false /* expectsResponse */), false);
        this.onSpeechRecognizerEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$, null, this.onSpeechRecognizerEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class SodaRecognizerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'chromeos.machine_learning.mojom.SodaRecognizer', scope);
    }
}
export class SodaRecognizerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SodaRecognizerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addAudio(audio) {
        this.proxy.sendMessage(0, SodaRecognizer_AddAudio_ParamsSpec.$, null, [
            audio
        ], false);
    }
    stop() {
        this.proxy.sendMessage(1, SodaRecognizer_Stop_ParamsSpec.$, null, [], false);
    }
    start() {
        this.proxy.sendMessage(2, SodaRecognizer_Start_ParamsSpec.$, null, [], false);
    }
    markDone() {
        this.proxy.sendMessage(3, SodaRecognizer_MarkDone_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the SodaRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SodaRecognizerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SodaRecognizerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SodaRecognizer_AddAudio_ParamsSpec.$, null, impl.addAudio.bind(impl), false);
        this.helper_internal_.registerHandler(1, SodaRecognizer_Stop_ParamsSpec.$, null, impl.stop.bind(impl), false);
        this.helper_internal_.registerHandler(2, SodaRecognizer_Start_ParamsSpec.$, null, impl.start.bind(impl), false);
        this.helper_internal_.registerHandler(3, SodaRecognizer_MarkDone_ParamsSpec.$, null, impl.markDone.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SodaRecognizer {
    static get $interfaceName() {
        return "chromeos.machine_learning.mojom.SodaRecognizer";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SodaRecognizerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SodaRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SodaRecognizerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SodaRecognizerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addAudio =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SodaRecognizer_AddAudio_ParamsSpec.$, null, this.addAudio.createReceiverHandler(false /* expectsResponse */), false);
        this.stop =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, SodaRecognizer_Stop_ParamsSpec.$, null, this.stop.createReceiverHandler(false /* expectsResponse */), false);
        this.start =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, SodaRecognizer_Start_ParamsSpec.$, null, this.start.createReceiverHandler(false /* expectsResponse */), false);
        this.markDone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, SodaRecognizer_MarkDone_ParamsSpec.$, null, this.markDone.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const SodaMultilangConfigSpec = { $: {} };
export const SodaConfigSpec = { $: {} };
export const TimingInfoSpec = { $: {} };
export const EndpointerEventSpec = { $: {} };
export const HypothesisPartInResultSpec = { $: {} };
export const PartialResultSpec = { $: {} };
export const FinalResultSpec = { $: {} };
export const AudioLevelEventSpec = { $: {} };
export const LangIdEventSpec = { $: {} };
export const LabelCorrectionEventSpec = { $: {} };
export const SodaClient_OnStart_ParamsSpec = { $: {} };
export const SodaClient_OnStop_ParamsSpec = { $: {} };
export const SodaClient_OnSpeechRecognizerEvent_ParamsSpec = { $: {} };
export const SodaRecognizer_AddAudio_ParamsSpec = { $: {} };
export const SodaRecognizer_Stop_ParamsSpec = { $: {} };
export const SodaRecognizer_Start_ParamsSpec = { $: {} };
export const SodaRecognizer_MarkDone_ParamsSpec = { $: {} };
export const SpeechRecognizerEventSpec = { $: {} };
mojo.internal.Struct(SodaMultilangConfigSpec.$, 'SodaMultilangConfig', [
    mojo.internal.StructField('rewindWhenSwitchingLanguage', 0, 0, mojo.internal.Bool, true, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('localeToLanguagePackMap', 8, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SodaConfigSpec.$, 'SodaConfig', [
    mojo.internal.StructField('channelCount', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sampleRate', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('apiKey', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('libraryDlcPath', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('languageDlcPath', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableFormatting', 32, 0, OptionalBoolSpec.$, OptionalBool.kTrue, false /* nullable */, 2, undefined, undefined),
    mojo.internal.StructField('recognitionMode', 36, 0, SodaRecognitionModeSpec.$, SodaRecognitionMode.kCaption, false /* nullable */, 3, undefined, undefined),
    mojo.internal.StructField('maskOffensiveWords', 40, 0, mojo.internal.Bool, false, false /* nullable */, 4, undefined, undefined),
    mojo.internal.StructField('speakerChangeDetection', 40, 1, mojo.internal.Bool, false, false /* nullable */, 5, undefined, undefined),
    mojo.internal.StructField('includeLoggingOutput', 40, 2, mojo.internal.Bool, false, false /* nullable */, 6, undefined, undefined),
    mojo.internal.StructField('multiLangConfig', 48, 0, SodaMultilangConfigSpec.$, null, true /* nullable */, 7, undefined, undefined),
    mojo.internal.StructField('speakerDiarizationMode', 44, 0, SpeakerDiarizationModeSpec.$, SpeakerDiarizationMode.kSpeakerDiarizationModeOffDefault, false /* nullable */, 9, undefined, undefined),
    mojo.internal.StructField('maxSpeakerCount', 56, 0, mojo.internal.Uint32, 2, false /* nullable */, 9, undefined, undefined),
], [[0, 40], [2, 48], [3, 48], [4, 56], [5, 56], [6, 56], [7, 64], [9, 72],]);
mojo.internal.Struct(TimingInfoSpec.$, 'TimingInfo', [
    mojo.internal.StructField('audioStartEpoch', 0, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('audioStartTime', 8, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('elapsedWallTime', 16, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('eventEndTime', 24, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('latency', 32, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('normalizedLatency', 40, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('wordAlignments', 48, 0, mojo.internal.Array(mojoBase_mojom_TimeDeltaSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(EndpointerEventSpec.$, 'EndpointerEvent', [
    mojo.internal.StructField('endpointerType', 0, 0, EndpointerTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timingEvent', 8, 0, TimingInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(HypothesisPartInResultSpec.$, 'HypothesisPartInResult', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('alignment', 8, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('leading_space_$flag', 16, 0, mojo.internal.Bool, false, false /* nullable */, 8, {
        isPrimary: true,
        linkedValueFieldName: "leading_space_$value",
        originalFieldName: "leadingSpace",
    }, undefined),
    mojo.internal.StructField('leading_space_$value', 16, 1, mojo.internal.Bool, false, false /* nullable */, 8, {
        isPrimary: false,
        originalFieldName: "leadingSpace",
    }, undefined),
    mojo.internal.StructField('speakerChange', 16, 2, mojo.internal.Bool, false, false /* nullable */, 9, undefined, undefined),
    mojo.internal.StructField('speakerLabel', 24, 0, mojo.internal.String, null, true /* nullable */, 9, undefined, undefined),
], [[0, 24], [8, 32], [9, 40],]);
mojo.internal.Struct(PartialResultSpec.$, 'PartialResult', [
    mojo.internal.StructField('partialText', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timingEvent', 8, 0, TimingInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hypothesisPart', 16, 0, mojo.internal.Array(HypothesisPartInResultSpec.$, false), null, true /* nullable */, 9, undefined, undefined),
], [[0, 24], [9, 32],]);
mojo.internal.Struct(FinalResultSpec.$, 'FinalResult', [
    mojo.internal.StructField('finalHypotheses', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('endpointReason', 8, 0, EndpointReasonSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timingEvent', 16, 0, TimingInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hypothesisPart', 24, 0, mojo.internal.Array(HypothesisPartInResultSpec.$, false), null, true /* nullable */, 1, undefined, undefined),
], [[0, 32], [1, 40],]);
mojo.internal.Struct(AudioLevelEventSpec.$, 'AudioLevelEvent', [
    mojo.internal.StructField('rms', 0, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('audioLevel', 4, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(LangIdEventSpec.$, 'LangIdEvent', [
    mojo.internal.StructField('language', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('confidenceLevel', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('asrSwitchResult', 12, 0, AsrSwitchResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(LabelCorrectionEventSpec.$, 'LabelCorrectionEvent', [
    mojo.internal.StructField('hypothesisParts', 0, 0, mojo.internal.Array(HypothesisPartInResultSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SodaClient_OnStart_ParamsSpec.$, 'SodaClient_OnStart_Params', [], [[0, 8],]);
mojo.internal.Struct(SodaClient_OnStop_ParamsSpec.$, 'SodaClient_OnStop_Params', [], [[0, 8],]);
mojo.internal.Struct(SodaClient_OnSpeechRecognizerEvent_ParamsSpec.$, 'SodaClient_OnSpeechRecognizerEvent_Params', [
    mojo.internal.StructField('event', 0, 0, SpeechRecognizerEventSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SodaRecognizer_AddAudio_ParamsSpec.$, 'SodaRecognizer_AddAudio_Params', [
    mojo.internal.StructField('audio', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SodaRecognizer_Stop_ParamsSpec.$, 'SodaRecognizer_Stop_Params', [], [[0, 8],]);
mojo.internal.Struct(SodaRecognizer_Start_ParamsSpec.$, 'SodaRecognizer_Start_Params', [], [[0, 8],]);
mojo.internal.Struct(SodaRecognizer_MarkDone_ParamsSpec.$, 'SodaRecognizer_MarkDone_Params', [], [[0, 8],]);
mojo.internal.Union(SpeechRecognizerEventSpec.$, 'SpeechRecognizerEvent', {
    'audioEvent': {
        'ordinal': 0,
        'type': AudioLevelEventSpec.$,
    },
    'partialResult': {
        'ordinal': 1,
        'type': PartialResultSpec.$,
    },
    'endpointerEvent': {
        'ordinal': 2,
        'type': EndpointerEventSpec.$,
    },
    'finalResult': {
        'ordinal': 3,
        'type': FinalResultSpec.$,
    },
    'langidEvent': {
        'ordinal': 4,
        'type': LangIdEventSpec.$,
    },
    'labelCorrectionEvent': {
        'ordinal': 5,
        'type': LabelCorrectionEventSpec.$,
    },
});
export var SpeechRecognizerEventFieldTags;
(function (SpeechRecognizerEventFieldTags) {
    SpeechRecognizerEventFieldTags[SpeechRecognizerEventFieldTags["AUDIO_EVENT"] = 0] = "AUDIO_EVENT";
    SpeechRecognizerEventFieldTags[SpeechRecognizerEventFieldTags["PARTIAL_RESULT"] = 1] = "PARTIAL_RESULT";
    SpeechRecognizerEventFieldTags[SpeechRecognizerEventFieldTags["ENDPOINTER_EVENT"] = 2] = "ENDPOINTER_EVENT";
    SpeechRecognizerEventFieldTags[SpeechRecognizerEventFieldTags["FINAL_RESULT"] = 3] = "FINAL_RESULT";
    SpeechRecognizerEventFieldTags[SpeechRecognizerEventFieldTags["LANGID_EVENT"] = 4] = "LANGID_EVENT";
    SpeechRecognizerEventFieldTags[SpeechRecognizerEventFieldTags["LABEL_CORRECTION_EVENT"] = 5] = "LABEL_CORRECTION_EVENT";
})(SpeechRecognizerEventFieldTags || (SpeechRecognizerEventFieldTags = {}));
export function whichSpeechRecognizerEvent(u) {
    if (u.audioEvent !== null && u.audioEvent !== undefined) {
        return SpeechRecognizerEventFieldTags.AUDIO_EVENT;
    }
    if (u.partialResult !== null && u.partialResult !== undefined) {
        return SpeechRecognizerEventFieldTags.PARTIAL_RESULT;
    }
    if (u.endpointerEvent !== null && u.endpointerEvent !== undefined) {
        return SpeechRecognizerEventFieldTags.ENDPOINTER_EVENT;
    }
    if (u.finalResult !== null && u.finalResult !== undefined) {
        return SpeechRecognizerEventFieldTags.FINAL_RESULT;
    }
    if (u.langidEvent !== null && u.langidEvent !== undefined) {
        return SpeechRecognizerEventFieldTags.LANGID_EVENT;
    }
    if (u.labelCorrectionEvent !== null && u.labelCorrectionEvent !== undefined) {
        return SpeechRecognizerEventFieldTags.LABEL_CORRECTION_EVENT;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
