// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// This file demonstrates how a chrome:// page can communicate with its
// embedded chrome-untrusted:// child page.
import { callbackRouter } from './page_handler.js';
import { ParentTrustedPageReceiver } from './sample_system_web_app_shared_ui.mojom-webui.js';
/**
 * Implements ParentTrustedPage interface to handle requests from the child
 * page.
 *
 * Note: If you expect to have multiple listeners for your interface, consider
 * using a CallbackRouter instead. CallbackRouter provides a more event-like
 * API that makes it easier to have multiple listeners.
 */
class ParentTrustedPageImpl {
    receiver_ = new ParentTrustedPageReceiver(this);
    constructor(pendingReceiver) {
        this.receiver_.$.bindHandle(pendingReceiver.handle);
    }
    doSomethingForChild(task) {
        document.querySelector('#child-task').innerText = task;
        // Mojo interface's JS implementation should return an Object, even if the
        // method only has one return value.
        //
        // Each field should match their return value name defined in .mojom file.
        return Promise.resolve({ resp: 'Task done' });
    }
}
export const childPageReady = new Promise(resolve => {
    callbackRouter.createParentPage.addListener((childPageRemote, parentPagePendingReceiver) => {
        resolve({
            childPage: childPageRemote,
            parentPageReceiver: new ParentTrustedPageImpl(parentPagePendingReceiver),
        });
    });
});
window.childPageReady = childPageReady;
childPageReady.then((result) => {
    result.childPage.doSomethingForParent('Hello from chrome://');
});
