// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let doubler = 2;
const connectedPagePorts = new Set();
self.onconnect = (event) => {
    const port = event.ports[0];
    port.onmessage = function (e) {
        if (e.data[0] == 'doubler') {
            doubler = e.data[1];
            port.postMessage(e.data[1]);
            connectedPagePorts.forEach(foregroundPort => {
                foregroundPort.postMessage(['New additional value: ' + doubler, doubler]);
            });
        }
        else {
            connectedPagePorts.add(port);
            const myWorkerResult = ['Result: ' + (e.data[0] * e.data[1] * doubler), doubler];
            port.postMessage(myWorkerResult);
        }
    };
};
export {};
