// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cros_components/orca_feedback/orca-feedback.js";import"/strings.m.js";import{I18nMixin}from"//resources/ash/common/cr_elements/i18n_mixin.js";import{ColorChangeUpdater}from"//resources/cr_components/color_change_listener/colors_css_updater.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./app.html.js";import{PageHandler}from"./scanner_feedback_ui.mojom-webui.js";const PAGE_HANDLER_REMOTE=PageHandler.getRemote();const FEEDBACK_INFO_PROMISE=PAGE_HANDLER_REMOTE.getFeedbackInfo().then((({feedbackInfo:feedbackInfo})=>feedbackInfo));export class ScannerFeedbackAppElement extends(I18nMixin(PolymerElement)){static get is(){return"scanner-feedback-app"}static get template(){return getTemplate()}static get properties(){return{stringSource:Object,openUrl:Object,extraInfoCallback:Object,screenshotUrl:String,revertToPreviousScreen:Object,submitFeedback:Object}}constructor(){super();this.stringSource={getAriaLabelForLink:linkText=>this.i18n("linkAriaLabel",linkText),MSG_FEEDBACK_TITLE:this.i18n("title"),MSG_FEEDBACK_SUBTITLE:this.i18n("subtitle"),MSG_FEEDBACK_QUESTION:this.i18n("question"),MSG_FEEDBACK_QUESTION_PLACEHOLDER:this.i18n("questionPlaceholder"),MSG_OFFENSIVE_OR_UNSAFE:this.i18n("offensiveOrUnsafe"),MSG_FACTUALLY_INCORRECT:this.i18n("factuallyIncorrect"),MSG_LEGAL_ISSUE:this.i18n("legalIssue"),getFeedbackDisclaimer:(linkPolicyBegin,linkPolicyEnd,linkTermsOfServiceBegin,linkTermsOfServiceEnd)=>this.i18nAdvanced("feedbackDisclaimer",{substitutions:[linkPolicyBegin,linkPolicyEnd,linkTermsOfServiceBegin,linkTermsOfServiceEnd],attrs:["id","class","role","aria-label"]}).toString(),MSG_PRIVACY_POLICY:this.i18n("privacyPolicy"),MSG_TERMS_OF_SERVICE:this.i18n("termsOfService"),MSG_CANCEL:this.i18n("cancel"),MSG_SEND:this.i18n("send")};this.openUrl=url=>{window.open(url,"_blank");this.revertToPreviousScreen()};this.extraInfoCallback=()=>FEEDBACK_INFO_PROMISE.then((feedbackInfo=>feedbackInfo.actionDetails));this.revertToPreviousScreen=()=>PAGE_HANDLER_REMOTE.closeDialog();this.submitFeedback=userDescription=>PAGE_HANDLER_REMOTE.sendFeedback(userDescription);FEEDBACK_INFO_PROMISE.then((feedbackInfo=>{this.screenshotUrl=feedbackInfo.screenshotUrl?.url??""}))}isUndefined(value){return value===undefined}}customElements.define(ScannerFeedbackAppElement.is,ScannerFeedbackAppElement);document.addEventListener("DOMContentLoaded",(()=>{ColorChangeUpdater.forDocument().start()}));