// ash/webui/scanner_feedback_ui/mojom/scanner_feedback_ui.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.mojom.scanner_feedback_ui.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getFeedbackInfo() {
        return this.proxy.sendMessage(0, PageHandler_GetFeedbackInfo_ParamsSpec.$, PageHandler_GetFeedbackInfo_ResponseParamsSpec.$, [], false);
    }
    closeDialog() {
        this.proxy.sendMessage(1, PageHandler_CloseDialog_ParamsSpec.$, null, [], false);
    }
    sendFeedback(userDescription) {
        this.proxy.sendMessage(2, PageHandler_SendFeedback_ParamsSpec.$, null, [
            userDescription
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetFeedbackInfo_ParamsSpec.$, PageHandler_GetFeedbackInfo_ResponseParamsSpec.$, impl.getFeedbackInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_CloseDialog_ParamsSpec.$, null, impl.closeDialog.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_SendFeedback_ParamsSpec.$, null, impl.sendFeedback.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.mojom.scanner_feedback_ui.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getFeedbackInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetFeedbackInfo_ParamsSpec.$, PageHandler_GetFeedbackInfo_ResponseParamsSpec.$, this.getFeedbackInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.closeDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_CloseDialog_ParamsSpec.$, null, this.closeDialog.createReceiverHandler(false /* expectsResponse */), false);
        this.sendFeedback =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_SendFeedback_ParamsSpec.$, null, this.sendFeedback.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const FeedbackInfoSpec = { $: {} };
export const PageHandler_GetFeedbackInfo_ParamsSpec = { $: {} };
export const PageHandler_GetFeedbackInfo_ResponseParamsSpec = { $: {} };
export const PageHandler_CloseDialog_ParamsSpec = { $: {} };
export const PageHandler_SendFeedback_ParamsSpec = { $: {} };
mojo.internal.Struct(FeedbackInfoSpec.$, 'FeedbackInfo', [
    mojo.internal.StructField('actionDetails', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('screenshotUrl', 8, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetFeedbackInfo_ParamsSpec.$, 'PageHandler_GetFeedbackInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetFeedbackInfo_ResponseParamsSpec.$, 'PageHandler_GetFeedbackInfo_ResponseParams', [
    mojo.internal.StructField('feedbackInfo', 0, 0, FeedbackInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_CloseDialog_ParamsSpec.$, 'PageHandler_CloseDialog_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_SendFeedback_ParamsSpec.$, 'PageHandler_SendFeedback_Params', [
    mojo.internal.StructField('userDescription', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
