// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"/strings.m.js";import{assert}from"chrome://resources/ash/common/assert.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{strictQuery}from"chrome://resources/ash/common/typescript_utils/strict_query.js";import{sanitizeInnerHtml}from"chrome://resources/js/parse_html_subset.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./scan_done_section.html.js";import{ScanCompleteAction}from"./scanning_app_types.js";import{ScanningBrowserProxyImpl}from"./scanning_browser_proxy.js";const ScanDoneSectionElementBase=I18nMixin(PolymerElement);export class ScanDoneSectionElement extends ScanDoneSectionElementBase{constructor(){super(...arguments);this.browserProxy=ScanningBrowserProxyImpl.getInstance()}static get is(){return"scan-done-section"}static get template(){return getTemplate()}static get properties(){return{numFilesSaved:{type:Number,observer:ScanDoneSectionElement.prototype.numFilesSavedChanged},scannedFilePaths:Array,selectedFileType:String,selectedFolder:String,fileSavedTextContent:String,editButtonLabel:String}}static get observers(){return["setFileSavedTextContent(numFilesSaved, selectedFolder)"]}onDoneClick(){this.browserProxy.recordScanCompleteAction(ScanCompleteAction.DONE_BUTTON_CLICKED);this.dispatchEvent(new CustomEvent("done-click",{bubbles:true,composed:true}))}onShowFileInLocationClick(){assert(this.scannedFilePaths.length!==0);this.browserProxy.recordScanCompleteAction(ScanCompleteAction.FILES_APP_OPENED);this.browserProxy.showFileInLocation(this.scannedFilePaths.slice(-1)[0].path).then((successful=>{if(!successful){this.dispatchEvent(new CustomEvent("file-not-found",{bubbles:true,composed:true}))}}))}setFileSavedTextContent(){this.browserProxy.getPluralString("fileSavedText",this.numFilesSaved).then((pluralString=>{const fileSavedTextContent=this.getAriaLabelledContent(loadTimeData.substituteString(pluralString.toString(),this.selectedFolder));this.fileSavedTextContent=sanitizeInnerHtml(fileSavedTextContent,{attrs:["id","aria-hidden","aria-labelledby"]});const linkElement=strictQuery("#folderLink",this.shadowRoot,HTMLAnchorElement);linkElement.setAttribute("href","#");linkElement.addEventListener("click",(()=>this.onShowFileInLocationClick()))}))}getAriaLabelledContent(localizedString){const tempEl=document.createElement("div");tempEl.innerHTML=sanitizeInnerHtml(localizedString,{attrs:["id"]});const ariaLabelledByIds=[];tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType==Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`id${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(node.nodeType==Node.ELEMENT_NODE&&node.nodeName=="A"){ariaLabelledByIds.push(node.id);return}}));const anchorTags=tempEl.getElementsByTagName("a");anchorTags[0].setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));return tempEl.innerHTML}onOpenMediaAppClick(){assert(this.scannedFilePaths.length!==0);this.browserProxy.recordScanCompleteAction(ScanCompleteAction.MEDIA_APP_OPENED);this.browserProxy.openFilesInMediaApp(this.scannedFilePaths.map((filePath=>filePath.path)))}numFilesSavedChanged(){this.browserProxy.getPluralString("editButtonLabel",this.numFilesSaved).then((pluralString=>{this.editButtonLabel=pluralString}))}}customElements.define(ScanDoneSectionElement.is,ScanDoneSectionElement);