// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./action_toolbar.js";import"./scanning_fonts.css.js";import"./scanning_shared.css.js";import"/strings.m.js";import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/polymer/v3_0/paper-progress/paper-progress.js";import{assert}from"chrome://resources/ash/common/assert.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ForceHiddenElementsVisibleObserverReceiver}from"./accessibility_features.mojom-webui.js";import{getAccessibilityFeaturesInterface}from"./mojo_interface_provider.js";import{getTemplate}from"./scan_preview.html.js";import{AppState}from"./scanning_app_types.js";import{ScanningBrowserProxyImpl}from"./scanning_browser_proxy.js";const PROGRESS_TIMER_MS=3e3;const SCANNED_IMG_MARGIN_BOTTOM_PX=12;const ACTION_TOOLBAR_BOTTOM_MARGIN_PX=40;const ScanPreviewElementBase=I18nMixin(PolymerElement);export class ScanPreviewElement extends ScanPreviewElementBase{static get is(){return"scan-preview"}static get template(){return getTemplate()}static get properties(){return{appState:{type:Number,observer:ScanPreviewElement.prototype.appStateChanged},objectUrls:{type:Array,observer:ScanPreviewElement.prototype.objectUrlsChanged},pageNumber:{type:Number,observer:ScanPreviewElement.prototype.pageNumberChanged},progressPercent:Number,showHelpOrProgress:{type:Boolean,value:true},showScannedImages:{type:Boolean,value:false},showHelperText:{type:Boolean,value:true},showScanProgress:{type:Boolean,value:false},showCancelingProgress:{type:Boolean,value:false},progressTextString:String,previewAriaLabel:String,progressTimer:{type:Number,value:null},isMultiPageScan:{type:Boolean,observer:ScanPreviewElement.prototype.isMultiPageScanChanged},currentPageIndexInView:{type:Number,value:0},scannedImagesLoaded:{type:Boolean,value:false},showActionToolbar:Boolean,dialogTitleText:String,dialogConfirmationText:String,dialogButtonText:String,multiPageScanning:{type:Boolean,value:false,reflectToAttribute:true},showSingleImageFocus:{type:Boolean,reflectToAttribute:true},forceActionToolbarVisible:{type:Boolean,value:false,reflectToAttribute:true}}}static get observers(){return["setPreviewAriaLabel(showScannedImages, showCancelingProgress,"+" showHelperText, objectUrls.length)","setScanProgressTimer(showScanProgress, progressPercent)"]}constructor(){super();this.browserProxy=ScanningBrowserProxyImpl.getInstance();this.onWindowResized=()=>this.setActionToolbarPosition();this.previewAreaResizeObserver=new ResizeObserver((()=>this.updatePreviewElements()))}ready(){super.ready();this.style.setProperty("--scanned-image-margin-bottom",SCANNED_IMG_MARGIN_BOTTOM_PX+"px");const styleMap=this.computedStyleMap();this.actionToolbarHeight=parseFloat(styleMap.get("--action-toolbar-height").toString());this.actionToolbarWidth=parseFloat(styleMap.get("--action-toolbar-width").toString());this.forceHiddenElementsVisibleObserverReceiver=new ForceHiddenElementsVisibleObserverReceiver(this);getAccessibilityFeaturesInterface().observeForceHiddenElementsVisible(this.forceHiddenElementsVisibleObserverReceiver.$.bindNewPipeAndPassRemote()).then((response=>this.forceActionToolbarVisible=response.forceVisible))}disconnectedCallback(){super.disconnectedCallback();if(this.isMultiPageScan){window.removeEventListener("resize",this.onWindowResized);this.previewAreaResizeObserver.disconnect()}if(this.forceHiddenElementsVisibleObserverReceiver){this.forceHiddenElementsVisibleObserverReceiver.$.close()}}onForceHiddenElementsVisibleChange(forceVisible){this.forceActionToolbarVisible=forceVisible}appStateChanged(){this.showScannedImages=this.appState===AppState.DONE||this.appState===AppState.MULTI_PAGE_NEXT_ACTION||this.appState===AppState.MULTI_PAGE_SCANNING;this.showScanProgress=this.appState===AppState.SCANNING||this.appState===AppState.MULTI_PAGE_SCANNING;this.showCancelingProgress=this.appState===AppState.CANCELING||this.appState===AppState.MULTI_PAGE_CANCELING;this.showHelperText=!this.showScanProgress&&!this.showCancelingProgress&&!this.showScannedImages;this.showHelpOrProgress=!this.showScannedImages||this.appState===AppState.MULTI_PAGE_SCANNING;this.multiPageScanning=this.appState===AppState.MULTI_PAGE_SCANNING;this.showSingleImageFocus=this.appState===AppState.MULTI_PAGE_NEXT_ACTION;this.showActionToolbar=this.appState===AppState.MULTI_PAGE_NEXT_ACTION;if(this.showHelpOrProgress){this.scannedImagesLoaded=false}}pageNumberChanged(){this.progressTextString=this.i18n("scanPreviewProgressText",this.pageNumber)}setPreviewAriaLabel(){if(this.showScannedImages){this.browserProxy.getPluralString("scannedImagesAriaLabel",this.objectUrls.length).then((pluralString=>this.previewAriaLabel=pluralString));return}if(this.showCancelingProgress){this.previewAriaLabel=this.i18n("cancelingScanningText");return}if(this.showHelperText){this.previewAriaLabel=this.i18n("scanPreviewHelperText");return}}setScanProgressTimer(){if(!this.showScanProgress){return}if(this.progressPercent===100){if(this.progressTimer){clearTimeout(this.progressTimer)}this.onScanProgressTimerComplete();return}if(this.progressTimer){return}this.progressTimer=setTimeout((()=>this.onScanProgressTimerComplete()),PROGRESS_TIMER_MS)}onScanProgressTimerComplete(){if(!this.showScanProgress){return}this.previewAriaLabel=this.i18n("scanningImagesAriaLabel",this.pageNumber,this.progressPercent);this.progressTimer=null}onScannedImagesScroll(){if(!this.isMultiPageScan||this.appState!=AppState.MULTI_PAGE_NEXT_ACTION){return}const scannedImagesDiv=this.shadowRoot.querySelector("#scannedImages");const scannedImages=scannedImagesDiv.getElementsByClassName("scanned-image");if(scannedImages.length===0){return}const pageIndexInView=this.getCurrentPageInView(scannedImages);if(pageIndexInView===this.currentPageIndexInView){return}this.setFocusedScannedImage(scannedImages,pageIndexInView)}getCurrentPageInView(scannedImages){assert(this.isMultiPageScan);if(scannedImages.length===1){return 0}const imageHeight=scannedImages[0].getBoundingClientRect().height+SCANNED_IMG_MARGIN_BOTTOM_PX;const numImagesVisibleAtEnd=Math.ceil(this.shadowRoot.querySelector("#previewDiv").offsetHeight/imageHeight);const numImagesBeforeCrossover=scannedImages.length-numImagesVisibleAtEnd;const crossoverBreakpoint=numImagesBeforeCrossover==0?Number.MIN_VALUE:scannedImages[numImagesBeforeCrossover].offsetTop-imageHeight/2;if(this.shadowRoot.querySelector("#previewDiv").scrollTop<crossoverBreakpoint){const scrollTop=this.shadowRoot.querySelector("#previewDiv").scrollTop-imageHeight/2-2;if(scrollTop<0){return 0}return 1+Math.floor(scrollTop/imageHeight)}const maxScrollTop=this.shadowRoot.querySelector("#previewDiv").scrollHeight-this.shadowRoot.querySelector("#previewDiv").offsetHeight;const scrollRemainingAfterCrossover=Math.max(maxScrollTop-crossoverBreakpoint,0);const imageScrollProportion=scrollRemainingAfterCrossover/numImagesVisibleAtEnd;const scrollTop=this.shadowRoot.querySelector("#previewDiv").scrollTop-crossoverBreakpoint;const index=Math.floor(scrollTop/imageScrollProportion);return Math.min(numImagesBeforeCrossover+index,scannedImages.length-1)}setFocusedScannedImage(scannedImages,pageIndexInView){assert(this.isMultiPageScan);this.removeFocusFromScannedImage(scannedImages);assert(pageIndexInView>=0&&pageIndexInView<scannedImages.length);scannedImages[pageIndexInView].classList.add("focused-scanned-image");this.currentPageIndexInView=pageIndexInView}removeFocusFromScannedImage(scannedImages){if(this.currentPageIndexInView<0){return}assert(this.currentPageIndexInView>=0&&this.currentPageIndexInView<scannedImages.length);scannedImages[this.currentPageIndexInView].classList.remove("focused-scanned-image");this.currentPageIndexInView=-1}onScannedImageLoaded(e){if(!this.isMultiPageScan){return}const scannedImages=this.shadowRoot.querySelector("#scannedImages").getElementsByClassName("scanned-image");this.setFocusedScannedImage(scannedImages,this.getCurrentPageInView(scannedImages));this.updatePreviewElements();if(this.scannedImagesLoaded){return}this.scannedImagesLoaded=true;this.scrollToPage(e.model.index)}onScannedImageClick(e){if(!this.isMultiPageScan){return}const scannedImages=this.shadowRoot.querySelector("#scannedImages").getElementsByClassName("scanned-image");this.setFocusedScannedImage(scannedImages,e.model.index)}setActionToolbarPosition(){assert(this.isMultiPageScan);const scannedImage=this.shadowRoot.querySelector(".scanned-image");if(!scannedImage){return}const scannedImageRect=scannedImage.getBoundingClientRect();const topPosition=this.shadowRoot.querySelector("#previewDiv").offsetHeight-ACTION_TOOLBAR_BOTTOM_MARGIN_PX-this.actionToolbarHeight/2;this.style.setProperty("--action-toolbar-top",topPosition+"px");const leftPosition=scannedImageRect.x+scannedImageRect.width/2-this.actionToolbarWidth/2;this.style.setProperty("--action-toolbar-left",leftPosition+"px")}onShowRemovePageDialog(e){this.showRemoveOrRescanDialog(true,e.detail)}onShowRescanPageDialog(e){this.showRemoveOrRescanDialog(false,e.detail)}showRemoveOrRescanDialog(isRemovePageDialog,pageIndex){this.onDialogActionClick=()=>{this.fireDialogAction(isRemovePageDialog?"remove-page":"rescan-page",pageIndex)};this.shadowRoot.querySelector("#actionButton").addEventListener("click",this.onDialogActionClick,{once:true});this.dialogButtonText=this.i18n(isRemovePageDialog?"removePageButtonLabel":"rescanPageButtonLabel");this.dialogConfirmationText=this.i18n(isRemovePageDialog?"removePageConfirmationText":"rescanPageConfirmationText");this.browserProxy.getPluralString(isRemovePageDialog?"removePageDialogTitle":"rescanPageDialogTitle",this.objectUrls.length===1?0:pageIndex+1).then((pluralString=>{const isRemoveFromMultiplePages=isRemovePageDialog&&this.objectUrls.length>1;this.dialogTitleText=isRemoveFromMultiplePages?"":pluralString;if(isRemoveFromMultiplePages){this.dialogConfirmationText=pluralString}this.shadowRoot.querySelector("#scanPreviewDialog").showModal()}))}fireDialogAction(event,pageIndex){const scannedImages=this.shadowRoot.querySelector("#scannedImages").getElementsByClassName("scanned-image");this.removeFocusFromScannedImage(scannedImages);assert(pageIndex>=0);this.dispatchEvent(new CustomEvent(event,{bubbles:true,composed:true,detail:pageIndex}));this.closeDialog()}closeDialog(){this.shadowRoot.querySelector("#scanPreviewDialog").close();this.shadowRoot.querySelector("#actionButton").removeEventListener("click",this.onDialogActionClick)}scrollToPage(pageIndex){assert(this.isMultiPageScan);const scannedImages=this.shadowRoot.querySelector("#scannedImages").getElementsByClassName("scanned-image");if(scannedImages.length===0){return}assert(pageIndex>=0&&pageIndex<scannedImages.length);this.shadowRoot.querySelector("#previewDiv").scrollTop=scannedImages[pageIndex].offsetTop-2}isMultiPageScanChanged(){if(this.isMultiPageScan){window.addEventListener("resize",this.onWindowResized);this.previewAreaResizeObserver.observe(this.shadowRoot.querySelector("#previewDiv"))}else{window.removeEventListener("resize",this.onWindowResized);this.previewAreaResizeObserver.disconnect()}}setMultiPageScanProgressHeight(){this.style.setProperty("--multi-page-scan-progress-height",this.shadowRoot.querySelector("#previewDiv").offsetHeight+"px")}objectUrlsChanged(){if(!this.isMultiPageScan){return}if(this.objectUrls.length===0){this.currentPageIndexInView=-1}}updatePreviewElements(){this.setMultiPageScanProgressHeight();this.setActionToolbarPosition()}showActionToolbarByIndex(index){return index===this.currentPageIndexInView&&this.showActionToolbar}onScannedImageInFocus(e){if(!this.isMultiPageScan){return}const scannedImages=this.shadowRoot.querySelector("#scannedImages").getElementsByClassName("scanned-image");this.setFocusedScannedImage(scannedImages,e.model.index)}getScannedImageAriaLabel(index){return this.i18n("multiPageImageAriaLabel",index+1,this.objectUrls.length)}setIsMultiPageScanForTesting(isMultiPageScan){this.isMultiPageScan=isMultiPageScan}setPageNumberForTesting(pageNumber){this.pageNumber=pageNumber}}customElements.define(ScanPreviewElement.is,ScanPreviewElement);