// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js";import"./scan_settings_section.js";import"/strings.m.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{strictQuery}from"chrome://resources/ash/common/typescript_utils/strict_query.js";import{afterNextRender,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./scanner_select.html.js";import{alphabeticalCompare,getScannerDisplayName}from"./scanning_app_util.js";const ScannerSelectElementBase=I18nMixin(PolymerElement);export class ScannerSelectElement extends ScannerSelectElementBase{static get is(){return"scanner-select"}static get template(){return getTemplate()}static get properties(){return{disabled:Boolean,scanners:{type:Array,value:()=>[]},selectedScannerId:{type:String,notify:true},scannerInfoMap:Object,lastUsedScannerId:String}}static get observers(){return["scannersChanged(scanners.*)"]}getScannerDisplayName(scanner){return getScannerDisplayName(scanner)}scannersChanged(){if(this.scanners.length>1){this.scanners.sort(((a,b)=>alphabeticalCompare(getScannerDisplayName(a),getScannerDisplayName(b))))}if(this.scanners.length>0){if(!this.lastUsedScannerId){this.selectedScannerId=this.scanners[0].id;return}this.selectedScannerId=this.lastUsedScannerId;afterNextRender(this,(()=>{strictQuery("#scannerSelect",this.shadowRoot,HTMLSelectElement).selectedIndex=this.getSelectedScannerIndex()}))}}getSelectedScannerIndex(){const selectedScannerToken=this.scannerInfoMap.get(this.selectedScannerId).token;return this.scanners.findIndex((scanner=>scanner.id===selectedScannerToken))}}customElements.define(ScannerSelectElement.is,ScannerSelectElement);