// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/ash/common/cr_elements/cr_toast/cr_toast.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js";import"chrome://resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js";import"chrome://resources/polymer/v3_0/iron-collapse/iron-collapse.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"./color_mode_select.js";import"./file_type_select.js";import"./loading_page.js";import"./multi_page_checkbox.js";import"./multi_page_scan.js";import"./page_size_select.js";import"./resolution_select.js";import"./scan_done_section.js";import"./scan_preview.js";import"./scan_to_select.js";import"./scanner_select.js";import"./scanning_fonts.css.js";import"./scanning_shared.css.js";import"./source_select.js";import{assert}from"chrome://resources/ash/common/assert.js";import{CrButtonElement}from"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import{CrContainerShadowMixin}from"chrome://resources/ash/common/cr_elements/cr_container_shadow_mixin.js";import{CrDialogElement}from"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import{CrToastElement}from"chrome://resources/ash/common/cr_elements/cr_toast/cr_toast.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{strictQuery}from"chrome://resources/ash/common/typescript_utils/strict_query.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{afterNextRender,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getScanService}from"./mojo_interface_provider.js";import{FileType,ScanJobObserverReceiver,ScanResult,SourceType}from"./scanning.mojom-webui.js";import{getTemplate}from"./scanning_app.html.js";import{AppState,MAX_NUM_SAVED_SCANNERS}from"./scanning_app_types.js";import{colorModeFromString,fileTypeFromString,getScannerDisplayName,pageSizeFromString}from"./scanning_app_util.js";import{ScanningBrowserProxyImpl}from"./scanning_browser_proxy.js";const HELP_PAGE_LINK="http://support.google.com/chromebook?p=chrome_scanning";const INITIAL_PAGE_NUMBER=1;const INITIAL_PROGRESS_PERCENT=0;const ScanningAppElementBase=CrContainerShadowMixin(I18nMixin(PolymerElement));export class ScanningAppElement extends ScanningAppElementBase{static get is(){return"scanning-app"}static get template(){return getTemplate()}static get properties(){return{scanners:{type:Array,value:()=>[]},selectedScannerId:{type:String,observer:ScanningAppElement.prototype.selectedScannerIdChanged},capabilities:Object,selectedSource:String,selectedFileType:String,selectedFilePath:String,selectedColorMode:String,selectedPageSize:String,selectedResolution:String,selectedFolder:String,sourceTypeMap:{type:Object,value(){return new Map}},appState:{type:Number,value:AppState.GETTING_SCANNERS,observer:ScanningAppElement.prototype.appStateChanged},objectUrls:{type:Array,value:()=>[]},pageNumber:{type:Number,value:INITIAL_PAGE_NUMBER},progressPercent:{type:Number,value:INITIAL_PROGRESS_PERCENT},selectedSourceColorModes:{type:Array,value:()=>[],computed:"computeSelectedSourceColorModes("+"selectedSource, capabilities.sources)"},selectedSourcePageSizes:{type:Array,value:()=>[],computed:"computeSelectedSourcePageSizes("+"selectedSource, capabilities.sources)"},selectedSourceResolutions:{type:Array,value:()=>[],computed:"computeSelectedSourceResolutions("+"selectedSource, capabilities.sources)"},settingsDisabled:{type:Boolean,value:true},scannersLoaded:{type:Boolean,value:false},showDoneSection:{type:Boolean,value:false},showCancelButton:{type:Boolean,value:false},cancelButtonDisabled:{type:Boolean,value:false},scannedFilePaths:{type:Array,value:()=>[]},toastMessageKey:{type:String,observer:ScanningAppElement.prototype.toastMessageKeyChanged},showToastInfoIcon:{type:Boolean,value:false},showToastHelpLink:{type:Boolean,value:false},opened:{type:Boolean,value:false,reflectToAttribute:true},arrowIconDirection:{type:String,computed:"computeArrowIconDirection(opened)"},numScanSettingChanges:{type:Number,value:0},scanFailedDialogTextKey:String,savedScanSettings:{type:Object,value(){return{lastUsedScannerName:"",scanToPath:"",scanners:[]}}},lastUsedScannerId:String,numCompletedScansInSession:{type:Number,value:0},multiPageScanChecked:Boolean,isMultiPageScan:{type:Boolean,computed:"computeIsMultiPageScan(multiPageScanChecked, "+"selectedFileType, selectedSource)",observer:"onIsMultiPageScanChange"},showMultiPageCheckbox:{type:Boolean,computed:"computeShowMultiPageCheckbox(showScanSettings, "+"selectedSource, selectedFileType)",reflectToAttribute:true},scanButtonText:String,showScanSettings:{type:Boolean,value:true},showMultiPageScan:{type:Boolean,value:false}}}static get observers(){return["scanSettingsChange(selectedSource, selectedFileType, "+"selectedFilePath, selectedColorMode, selectedPageSize, "+"selectedResolution)"]}constructor(){super();this.scanService=getScanService();this.browserProxy=ScanningBrowserProxyImpl.getInstance();this.sourceTypeMap=new Map;this.scannerInfoMap=new Map;this.browserProxy.initialize();this.browserProxy.getMyFilesPath().then((myFilesPath=>{this.selectedFilePath=myFilesPath}));this.browserProxy.getScanSettings().then((scanSettings=>{if(!scanSettings){return}this.savedScanSettings=JSON.parse(scanSettings)}))}ready(){super.ready();window.addEventListener("beforeunload",(event=>{this.browserProxy.recordNumCompletedScans(this.numCompletedScansInSession);if(this.appState===AppState.SCANNING){event.preventDefault();event.returnValue=""}}));this.scanService.getScanners().then((response=>{this.onScannersReceived(response)}))}connectedCallback(){super.connectedCallback();(function(){ColorChangeUpdater.forDocument().start()})()}disconnectedCallback(){super.disconnectedCallback();if(this.scanJobObserverReceiver){this.scanJobObserverReceiver.$.close()}}onPageProgress(pageNumber,progressPercent){assert(this.appState===AppState.SCANNING||this.appState===AppState.MULTI_PAGE_SCANNING||this.appState===AppState.CANCELING||this.appState===AppState.MULTI_PAGE_CANCELING);if(!this.isMultiPageScan){this.pageNumber=pageNumber}this.progressPercent=progressPercent}onPageComplete(pageData,newPageIndex){assert(this.appState===AppState.SCANNING||this.appState===AppState.MULTI_PAGE_SCANNING||this.appState===AppState.CANCELING||this.appState===AppState.MULTI_PAGE_CANCELING);const blob=new Blob([Uint8Array.from(pageData)],{type:"image/png"});const objectUrl=URL.createObjectURL(blob);if(newPageIndex===this.objectUrls.length){this.push("objectUrls",objectUrl)}else{this.splice("objectUrls",newPageIndex,1,objectUrl)}this.pageNumber=this.objectUrls.length;if(this.isMultiPageScan){this.setAppState(AppState.MULTI_PAGE_NEXT_ACTION)}}onScanComplete(result,scannedFilePaths){if(result!==ScanResult.kSuccess||this.objectUrls.length==0){this.setScanFailedDialogTextKey(result);strictQuery("#scanFailedDialog",this.shadowRoot,CrDialogElement).showModal();return}++this.numCompletedScansInSession;this.scannedFilePaths=scannedFilePaths;this.setAppState(AppState.DONE)}onCancelComplete(success){if(!success){this.showToast("cancelFailedToastText");this.setAppState(this.appState===AppState.MULTI_PAGE_CANCELING?AppState.MULTI_PAGE_SCANNING:AppState.SCANNING);return}if(this.appState===AppState.MULTI_PAGE_CANCELING){this.pageNumber=this.objectUrls.length;this.setAppState(AppState.MULTI_PAGE_NEXT_ACTION)}else{this.setAppState(AppState.READY)}this.showToast("scanCanceledToastText")}onMultiPageScanFail(result){assert(result!==ScanResult.kSuccess);this.setScanFailedDialogTextKey(result);strictQuery("#scanFailedDialog",this.shadowRoot,CrDialogElement).showModal()}computeSelectedSourceColorModes(){assert(this.capabilities);for(const source of this.capabilities.sources){if(source.name===this.selectedSource){return source.colorModes}}return[]}computeSelectedSourcePageSizes(){assert(this.capabilities);for(const source of this.capabilities.sources){if(source.name===this.selectedSource){return source.pageSizes}}return[]}computeSelectedSourceResolutions(){assert(this.capabilities);for(const source of this.capabilities.sources){if(source.name===this.selectedSource){return source.resolutions}}return[]}onCapabilitiesReceived(capabilities){this.capabilities=capabilities;this.capabilities.sources.forEach((source=>this.sourceTypeMap.set(source.name,source.type)));this.selectedFileType=FileType.kPdf.toString();this.setAppState(this.areSavedScanSettingsAvailable()?AppState.SETTING_SAVED_SETTINGS:AppState.READY)}onScannersReceived(response){if(response.scanners.length===0){this.setAppState(AppState.NO_SCANNERS);return}for(const scanner of response.scanners){this.setScannerInfo(scanner);if(this.isLastUsedScanner(scanner)){this.lastUsedScannerId=scanner.id}}this.setAppState(AppState.GOT_SCANNERS);this.scanners=response.scanners}selectedScannerIdChanged(){assert(this.isSelectedScannerKnown());this.numScanSettingChanges=this.appState===AppState.READY?1:0;this.setAppState(AppState.GETTING_CAPS);this.getSelectedScannerCapabilities().then((response=>{this.onCapabilitiesReceived(response.capabilities)}))}onScanClick(){strictQuery("#toast",this.shadowRoot,CrToastElement).hide();if(!this.selectedScannerId||!this.selectedSource||!this.selectedFileType||!this.selectedColorMode||!this.selectedPageSize||!this.selectedResolution){this.showToast("startScanFailedToast");return}if(!this.scanJobObserverReceiver){this.scanJobObserverReceiver=new ScanJobObserverReceiver(this)}const settings=this.getScanSettings();if(this.isMultiPageScan){this.scanService.startMultiPageScan(this.getSelectedScannerToken(),settings,this.scanJobObserverReceiver.$.bindNewPipeAndPassRemote()).then((response=>{this.onStartMultiPageScanResponse(response)}))}else{this.scanService.startScan(this.getSelectedScannerToken(),settings,this.scanJobObserverReceiver.$.bindNewPipeAndPassRemote()).then((response=>{this.onStartScanResponse(response)}))}this.saveScanSettings();const scanJobSettingsForMetrics={sourceType:this.sourceTypeMap.get(this.selectedSource),fileType:settings.fileType,colorMode:settings.colorMode,pageSize:settings.pageSize,resolution:settings.resolutionDpi};this.browserProxy.recordScanJobSettings(scanJobSettingsForMetrics);this.browserProxy.recordNumScanSettingChanges(this.numScanSettingChanges);this.numScanSettingChanges=0}onDoneClick(){this.setAppState(AppState.READY)}onStartScanResponse(response){if(!response.success){this.showToast("startScanFailedToast");return}this.setAppState(AppState.SCANNING);this.pageNumber=INITIAL_PAGE_NUMBER;this.progressPercent=INITIAL_PROGRESS_PERCENT}onStartMultiPageScanResponse(response){if(!response.controller){this.showToast("startScanFailedToast");return}this.setAppState(AppState.SCANNING);assert(!this.multiPageScanController);this.multiPageScanController=response.controller;this.pageNumber=INITIAL_PAGE_NUMBER;this.progressPercent=INITIAL_PROGRESS_PERCENT}onScanNextPage(){this.multiPageScanController.scanNextPage(this.getSelectedScannerToken(),this.getScanSettings()).then((response=>{this.onScanNextPageResponse(response)}))}onRemovePage(e){const pageIndex=e.detail;assert(pageIndex>=0&&pageIndex<this.objectUrls.length);this.splice("objectUrls",pageIndex,1);this.pageNumber=this.objectUrls.length;this.multiPageScanController.removePage(pageIndex);if(this.objectUrls.length===0){this.resetMultiPageScanController();this.setAppState(AppState.READY)}}onRescanPage(e){const pageIndex=e.detail;assert(pageIndex>=0&&pageIndex<this.objectUrls.length);this.multiPageScanController.rescanPage(this.getSelectedScannerToken(),this.getScanSettings(),pageIndex).then((response=>{this.onRescanPageResponse(response,pageIndex)}))}onCompleteMultiPageScan(){assert(this.multiPageScanController);this.multiPageScanController.completeMultiPageScan();this.resetMultiPageScanController()}resetMultiPageScanController(){this.multiPageScanController.$.close();this.multiPageScanController=null}onScanNextPageResponse(response){if(!response.success){this.showToast("startScanFailedToast");return}this.setAppState(AppState.MULTI_PAGE_SCANNING);++this.pageNumber;this.progressPercent=INITIAL_PROGRESS_PERCENT}onRescanPageResponse(response,pageIndex){if(!response.success){this.showToast("startScanFailedToast");return}this.progressPercent=INITIAL_PROGRESS_PERCENT;this.pageNumber=++pageIndex;this.setAppState(AppState.MULTI_PAGE_SCANNING)}toggleClicked(){strictQuery("#collapse",this.shadowRoot,HTMLElement).toggle()}computeArrowIconDirection(){return this.opened?"cr:expand-less":"cr:expand-more"}getFileSavedText(){const fileSavedText=this.pageNumber>1?"fileSavedTextPlural":"fileSavedText";return this.i18n(fileSavedText)}onCancelClick(){assert(this.appState===AppState.SCANNING||this.appState===AppState.MULTI_PAGE_SCANNING);this.setAppState(this.appState===AppState.MULTI_PAGE_SCANNING?AppState.MULTI_PAGE_CANCELING:AppState.CANCELING);this.scanService.cancelScan()}clearObjectUrls(){for(const url of this.objectUrls){URL.revokeObjectURL(url)}this.objectUrls=[]}setAppState(newState){switch(newState){case AppState.GETTING_SCANNERS:assert(this.appState===AppState.GETTING_SCANNERS||this.appState===AppState.NO_SCANNERS);break;case AppState.GOT_SCANNERS:assert(this.appState===AppState.GETTING_SCANNERS);break;case AppState.GETTING_CAPS:assert(this.appState===AppState.GOT_SCANNERS||this.appState===AppState.READY);break;case AppState.SETTING_SAVED_SETTINGS:assert(this.appState===AppState.GETTING_CAPS);break;case AppState.READY:assert(this.appState===AppState.GETTING_CAPS||this.appState===AppState.SETTING_SAVED_SETTINGS||this.appState===AppState.SCANNING||this.appState===AppState.DONE||this.appState===AppState.CANCELING||this.appState===AppState.MULTI_PAGE_NEXT_ACTION);this.clearObjectUrls();break;case AppState.SCANNING:assert(this.appState===AppState.READY||this.appState===AppState.CANCELING);break;case AppState.DONE:assert(this.appState===AppState.SCANNING||this.appState===AppState.CANCELING||this.appState===AppState.MULTI_PAGE_NEXT_ACTION);break;case AppState.CANCELING:assert(this.appState===AppState.SCANNING);break;case AppState.NO_SCANNERS:assert(this.appState===AppState.GETTING_SCANNERS);break;case AppState.MULTI_PAGE_SCANNING:assert(this.appState===AppState.MULTI_PAGE_NEXT_ACTION||this.appState===AppState.MULTI_PAGE_CANCELING);break;case AppState.MULTI_PAGE_NEXT_ACTION:assert(this.appState===AppState.SCANNING||this.appState===AppState.CANCELING||this.appState===AppState.MULTI_PAGE_SCANNING||this.appState===AppState.MULTI_PAGE_CANCELING);break;case AppState.MULTI_PAGE_CANCELING:assert(this.appState===AppState.MULTI_PAGE_SCANNING);break}this.appState=newState}appStateChanged(){this.scannersLoaded=this.appState!==AppState.GETTING_SCANNERS&&this.appState!==AppState.NO_SCANNERS;this.settingsDisabled=this.appState!==AppState.READY;this.showCancelButton=this.appState===AppState.SCANNING||this.appState===AppState.CANCELING;this.cancelButtonDisabled=this.appState===AppState.CANCELING;this.showDoneSection=this.appState===AppState.DONE;this.showMultiPageScan=this.appState===AppState.MULTI_PAGE_NEXT_ACTION||this.appState===AppState.MULTI_PAGE_SCANNING||this.appState===AppState.MULTI_PAGE_CANCELING;this.showScanSettings=!this.showDoneSection&&!this.showMultiPageScan;afterNextRender(this,(()=>{if(this.appState===AppState.SETTING_SAVED_SETTINGS){this.setScanSettingsFromSavedSettings();this.setAppState(AppState.READY)}else if(this.appState===AppState.READY){this.shadowRoot.querySelector("#scannerSelect").shadowRoot.querySelector("#scannerSelect").focus()}else if(this.appState===AppState.SCANNING){strictQuery("#cancelButton",this.shadowRoot,CrButtonElement).focus()}else if(this.appState===AppState.DONE){this.shadowRoot.querySelector("#scanPreview").shadowRoot.querySelector("#previewDiv").focus()}}))}showToast(toastMessageKey){this.toastMessageKey=toastMessageKey;strictQuery("#toast",this.shadowRoot,CrToastElement).show()}toastMessageKeyChanged(){this.showToastInfoIcon=this.toastMessageKey!=="scanCanceledToastText";this.showToastHelpLink=this.toastMessageKey!=="scanCanceledToastText"&&this.toastMessageKey!=="fileNotFoundToastText"}onFileNotFound(){this.showToast("fileNotFoundToastText")}onScanFailedDialogOkClick(){strictQuery("#scanFailedDialog",this.shadowRoot,CrDialogElement).close();if(this.appState===AppState.MULTI_PAGE_SCANNING){this.pageNumber=this.objectUrls.length;this.setAppState(AppState.MULTI_PAGE_NEXT_ACTION);return}this.setAppState(AppState.READY)}onScanFailedDialogGetHelpClick(){strictQuery("#scanFailedDialog",this.shadowRoot,CrDialogElement).close();this.setAppState(AppState.READY);window.open(HELP_PAGE_LINK)}getNumFilesSaved(){return this.selectedFileType===FileType.kPdf.toString()?1:this.pageNumber}onRetryClick(){this.setAppState(AppState.GETTING_SCANNERS);this.scanService.getScanners().then((response=>{this.onScannersReceived(response)}))}onLearnMoreClick(){window.open(HELP_PAGE_LINK)}scanSettingsChange(){if(this.appState!==AppState.READY){return}++this.numScanSettingChanges}setScanFailedDialogTextKey(scanResult){switch(scanResult){case ScanResult.kDeviceBusy:this.scanFailedDialogTextKey="scanFailedDialogDeviceBusyText";break;case ScanResult.kAdfJammed:this.scanFailedDialogTextKey="scanFailedDialogAdfJammedText";break;case ScanResult.kAdfEmpty:this.scanFailedDialogTextKey="scanFailedDialogAdfEmptyText";break;case ScanResult.kFlatbedOpen:this.scanFailedDialogTextKey="scanFailedDialogFlatbedOpenText";break;case ScanResult.kIoError:this.scanFailedDialogTextKey="scanFailedDialogIoErrorText";break;default:this.scanFailedDialogTextKey="scanFailedDialogUnknownErrorText"}}setScanSettingsFromSavedSettings(){if(!this.areSavedScanSettingsAvailable()){return}this.setScanToPathFromSavedSettings();const scannerSettings=this.getSelectedScannerSavedSettings();if(!scannerSettings){return}this.setSelectedSourceTypeIfAvailable(scannerSettings.sourceName);afterNextRender(this,(()=>{this.setSelectedFileTypeIfAvailable(scannerSettings.fileType);this.setSelectedColorModeIfAvailable(scannerSettings.colorMode);this.setSelectedPageSizeIfAvailable(scannerSettings.pageSize);this.setSelectedResolutionIfAvailable(scannerSettings.resolutionDpi)}));this.setMultiPageScanIfAvailable(scannerSettings.multiPageScanChecked)}createScannerInfo(scanner){return{token:scanner.id,displayName:getScannerDisplayName(scanner)}}setScannerInfo(scanner){this.scannerInfoMap.set(scanner.id,this.createScannerInfo(scanner))}isLastUsedScanner(scanner){return this.savedScanSettings.lastUsedScannerName===getScannerDisplayName(scanner)}isSelectedScannerKnown(){return this.scannerInfoMap.has(this.selectedScannerId)}getSelectedScannerToken(){return this.scannerInfoMap.get(this.selectedScannerId).token}getSelectedScannerDisplayName(){return this.scannerInfoMap.get(this.selectedScannerId).displayName}getSelectedScannerCapabilities(){return this.scanService.getScannerCapabilities(this.getSelectedScannerToken())}getSelectedScannerSavedSettings(){const selectedScannerDisplayName=this.getSelectedScannerDisplayName();return this.savedScanSettings.scanners.find((scanner=>scanner.name===selectedScannerDisplayName))}setScanToPathFromSavedSettings(){this.browserProxy.ensureValidFilePath(this.savedScanSettings.scanToPath).then((selectedPath=>{const baseName=selectedPath.baseName;const filePath=selectedPath.filePath;if(!baseName||!filePath){return}this.selectedFolder=baseName;this.selectedFilePath=filePath}))}saveScanSettings(){const scannerName=this.getSelectedScannerDisplayName();this.savedScanSettings.lastUsedScannerName=scannerName;this.savedScanSettings.scanToPath=this.selectedFilePath;const newScannerSetting=this.createScannerSettingForSelectedScanner();const scannerIndex=this.savedScanSettings.scanners.findIndex((scanner=>scanner.name===scannerName));if(scannerIndex===-1){this.savedScanSettings.scanners.push(newScannerSetting)}else{this.savedScanSettings.scanners[scannerIndex]=newScannerSetting}if(this.savedScanSettings.scanners.length>MAX_NUM_SAVED_SCANNERS){this.evictScannersFromScanSettings()}this.browserProxy.saveScanSettings(JSON.stringify(this.savedScanSettings))}evictScannersFromScanSettings(){this.savedScanSettings.scanners.sort(((firstScanner,secondScanner)=>{const secondScannerDate=new Date(secondScanner.lastScanDate);const firstScannerDate=new Date(firstScanner.lastScanDate);return secondScannerDate.valueOf()-firstScannerDate.valueOf()}));this.savedScanSettings.scanners.splice(MAX_NUM_SAVED_SCANNERS)}createScannerSettingForSelectedScanner(){return{name:this.getSelectedScannerDisplayName(),lastScanDate:new Date,sourceName:this.selectedSource,fileType:fileTypeFromString(this.selectedFileType),colorMode:colorModeFromString(this.selectedColorMode),pageSize:pageSizeFromString(this.selectedPageSize),resolutionDpi:Number(this.selectedResolution),multiPageScanChecked:this.multiPageScanChecked}}areSavedScanSettingsAvailable(){return this.savedScanSettings.scanners.length!==0}computeShowMultiPageCheckbox(){return this.showScanSettings&&this.isPdfSelected()&&this.isFlatbedSelected()}isPdfSelected(){return!!this.selectedFileType&&fileTypeFromString(this.selectedFileType)===FileType.kPdf}isFlatbedSelected(){return!!this.selectedSource&&this.sourceTypeMap.get(this.selectedSource)===SourceType.kFlatbed}computeIsMultiPageScan(){return this.multiPageScanChecked&&this.isPdfSelected()&&this.isFlatbedSelected()}onIsMultiPageScanChange(){const nextPageNum=this.isMultiPageScan?1:0;this.browserProxy.getPluralString("scanButtonText",nextPageNum).then((pluralString=>{this.scanButtonText=pluralString}))}getScanSettings(){const fileType=fileTypeFromString(this.selectedFileType);const colorMode=colorModeFromString(this.selectedColorMode);const pageSize=pageSizeFromString(this.selectedPageSize);const resolution=Number(this.selectedResolution);return{sourceName:this.selectedSource,scanToPath:{path:this.selectedFilePath},fileType:fileType,colorMode:colorMode,pageSize:pageSize,resolutionDpi:resolution}}setSelectedSourceTypeIfAvailable(sourceName){assert(this.capabilities);if(this.capabilities.sources.find((source=>source.name===sourceName))){this.selectedSource=sourceName}}setSelectedFileTypeIfAvailable(fileType){if(Object.values(FileType).includes(fileType)){this.selectedFileType=fileType.toString()}}setSelectedColorModeIfAvailable(colorMode){if(this.selectedSourceColorModes.includes(colorMode)){this.selectedColorMode=colorMode.toString()}}setSelectedPageSizeIfAvailable(pageSize){if(this.selectedSourcePageSizes.includes(pageSize)){this.selectedPageSize=pageSize.toString()}}setSelectedResolutionIfAvailable(resolution){if(this.selectedSourceResolutions.includes(resolution)){this.selectedResolution=resolution.toString()}}setMultiPageScanIfAvailable(multiPageScanChecked){if(this.showMultiPageCheckbox){this.multiPageScanChecked=multiPageScanChecked}}}customElements.define(ScanningAppElement.is,ScanningAppElement);