// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assertNotReached}from"chrome://resources/ash/common/assert.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{ColorMode,FileType,PageSize,SourceType}from"./scanning.mojom-webui.js";export function colorModeFromString(colorModeString){switch(colorModeString){case ColorMode.kBlackAndWhite.toString():return ColorMode.kBlackAndWhite;case ColorMode.kGrayscale.toString():return ColorMode.kGrayscale;case ColorMode.kColor.toString():return ColorMode.kColor;default:assertNotReached();return ColorMode.kColor}}export function fileTypeFromString(fileTypeString){switch(fileTypeString){case FileType.kJpg.toString():return FileType.kJpg;case FileType.kPdf.toString():return FileType.kPdf;case FileType.kPng.toString():return FileType.kPng;default:assertNotReached();return FileType.kPdf}}export function getColorModeString(mojoColorMode){switch(mojoColorMode){case ColorMode.kBlackAndWhite:return loadTimeData.getString("blackAndWhiteOptionText");case ColorMode.kGrayscale:return loadTimeData.getString("grayscaleOptionText");case ColorMode.kColor:return loadTimeData.getString("colorOptionText");default:assertNotReached();return loadTimeData.getString("blackAndWhiteOptionText")}}export function getPageSizeString(pageSize){switch(pageSize){case PageSize.kIsoA3:return loadTimeData.getString("a3OptionText");case PageSize.kIsoA4:return loadTimeData.getString("a4OptionText");case PageSize.kIsoB4:return loadTimeData.getString("b4OptionText");case PageSize.kLegal:return loadTimeData.getString("legalOptionText");case PageSize.kNaLetter:return loadTimeData.getString("letterOptionText");case PageSize.kTabloid:return loadTimeData.getString("tabloidOptionText");case PageSize.kMax:return loadTimeData.getString("fitToScanAreaOptionText");default:assertNotReached();return loadTimeData.getString("letterOptionText")}}export function getSourceTypeString(mojoSourceType){switch(mojoSourceType){case SourceType.kFlatbed:return loadTimeData.getString("flatbedOptionText");case SourceType.kAdfSimplex:return loadTimeData.getString("oneSidedDocFeederOptionText");case SourceType.kAdfDuplex:return loadTimeData.getString("twoSidedDocFeederOptionText");case SourceType.kDefault:return loadTimeData.getString("defaultSourceOptionText");case SourceType.kUnknown:default:assertNotReached();return loadTimeData.getString("defaultSourceOptionText")}}export function pageSizeFromString(pageSizeString){switch(pageSizeString){case PageSize.kIsoA3.toString():return PageSize.kIsoA3;case PageSize.kIsoA4.toString():return PageSize.kIsoA4;case PageSize.kIsoB4.toString():return PageSize.kIsoB4;case PageSize.kLegal.toString():return PageSize.kLegal;case PageSize.kNaLetter.toString():return PageSize.kNaLetter;case PageSize.kTabloid.toString():return PageSize.kTabloid;case PageSize.kMax.toString():return PageSize.kMax;default:assertNotReached();return PageSize.kNaLetter}}export function getScannerDisplayName(scanner){return scanner.displayName}export function alphabeticalCompare(first,second){return first.toLocaleLowerCase().localeCompare(second.toLocaleLowerCase())}