// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './scanning_shared.css.js';
import '/strings.m.js';
import 'chrome://resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js';
import { assert } from 'chrome://resources/ash/common/assert.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './action_toolbar.html.js';
/**
 * @fileoverview
 * 'action-toolbar' is a floating toolbar that contains post-scan page options.
 */
const ActionToolbarElementBase = I18nMixin(PolymerElement);
export class ActionToolbarElement extends ActionToolbarElementBase {
    constructor() {
        super(...arguments);
        this.pageIndex = 0;
        this.numTotalPages = 0;
        this.pageNumberText = '';
    }
    static get is() {
        return 'action-toolbar';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            pageIndex: Number,
            numTotalPages: Number,
            pageNumberText: {
                type: String,
                computed: 'computePageNumberText(pageIndex, numTotalPages)',
            },
        };
    }
    computePageNumberText() {
        if (!this.numTotalPages || this.pageIndex >= this.numTotalPages) {
            return '';
        }
        assert(this.numTotalPages > 0);
        // Add 1 to |pageIndex| to get the corresponding page number.
        return this.i18n('actionToolbarPageCountText', this.pageIndex + 1, this.numTotalPages);
    }
    onRemovePageIconClick() {
        this.dispatchEvent(new CustomEvent('show-remove-page-dialog', { detail: this.pageIndex }));
    }
    onRescanPageIconClick() {
        this.dispatchEvent(new CustomEvent('show-rescan-page-dialog', { detail: this.pageIndex }));
    }
}
customElements.define(ActionToolbarElement.is, ActionToolbarElement);
