// ash/webui/scanning/mojom/scanning.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { FilePathSpec as mojoBase_mojom_FilePathSpec } from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
export const ColorModeSpec = { $: mojo.internal.Enum() };
export var ColorMode;
(function (ColorMode) {
    ColorMode[ColorMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    ColorMode[ColorMode["MAX_VALUE"] = 2] = "MAX_VALUE";
    ColorMode[ColorMode["kBlackAndWhite"] = 0] = "kBlackAndWhite";
    ColorMode[ColorMode["kGrayscale"] = 1] = "kGrayscale";
    ColorMode[ColorMode["kColor"] = 2] = "kColor";
})(ColorMode || (ColorMode = {}));
export const FileTypeSpec = { $: mojo.internal.Enum() };
export var FileType;
(function (FileType) {
    FileType[FileType["MIN_VALUE"] = 0] = "MIN_VALUE";
    FileType[FileType["MAX_VALUE"] = 2] = "MAX_VALUE";
    FileType[FileType["kJpg"] = 0] = "kJpg";
    FileType[FileType["kPdf"] = 1] = "kPdf";
    FileType[FileType["kPng"] = 2] = "kPng";
})(FileType || (FileType = {}));
export const SourceTypeSpec = { $: mojo.internal.Enum() };
export var SourceType;
(function (SourceType) {
    SourceType[SourceType["MIN_VALUE"] = 0] = "MIN_VALUE";
    SourceType[SourceType["MAX_VALUE"] = 4] = "MAX_VALUE";
    SourceType[SourceType["kUnknown"] = 0] = "kUnknown";
    SourceType[SourceType["kFlatbed"] = 1] = "kFlatbed";
    SourceType[SourceType["kAdfSimplex"] = 2] = "kAdfSimplex";
    SourceType[SourceType["kAdfDuplex"] = 3] = "kAdfDuplex";
    SourceType[SourceType["kDefault"] = 4] = "kDefault";
})(SourceType || (SourceType = {}));
export const PageSizeSpec = { $: mojo.internal.Enum() };
export var PageSize;
(function (PageSize) {
    PageSize[PageSize["MIN_VALUE"] = 0] = "MIN_VALUE";
    PageSize[PageSize["MAX_VALUE"] = 6] = "MAX_VALUE";
    PageSize[PageSize["kIsoA3"] = 0] = "kIsoA3";
    PageSize[PageSize["kIsoA4"] = 1] = "kIsoA4";
    PageSize[PageSize["kIsoB4"] = 2] = "kIsoB4";
    PageSize[PageSize["kLegal"] = 3] = "kLegal";
    PageSize[PageSize["kNaLetter"] = 4] = "kNaLetter";
    PageSize[PageSize["kTabloid"] = 5] = "kTabloid";
    PageSize[PageSize["kMax"] = 6] = "kMax";
})(PageSize || (PageSize = {}));
export const ScanResultSpec = { $: mojo.internal.Enum() };
export var ScanResult;
(function (ScanResult) {
    ScanResult[ScanResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    ScanResult[ScanResult["MAX_VALUE"] = 6] = "MAX_VALUE";
    ScanResult[ScanResult["kSuccess"] = 0] = "kSuccess";
    ScanResult[ScanResult["kUnknownError"] = 1] = "kUnknownError";
    ScanResult[ScanResult["kDeviceBusy"] = 2] = "kDeviceBusy";
    ScanResult[ScanResult["kAdfJammed"] = 3] = "kAdfJammed";
    ScanResult[ScanResult["kAdfEmpty"] = 4] = "kAdfEmpty";
    ScanResult[ScanResult["kFlatbedOpen"] = 5] = "kFlatbedOpen";
    ScanResult[ScanResult["kIoError"] = 6] = "kIoError";
})(ScanResult || (ScanResult = {}));
export class ScanJobObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.scanning.mojom.ScanJobObserver', scope);
    }
}
export class ScanJobObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ScanJobObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPageProgress(pageNumber, progressPercent) {
        this.proxy.sendMessage(0, ScanJobObserver_OnPageProgress_ParamsSpec.$, null, [
            pageNumber,
            progressPercent
        ], false);
    }
    onPageComplete(pageData, newPageIndex) {
        this.proxy.sendMessage(1, ScanJobObserver_OnPageComplete_ParamsSpec.$, null, [
            pageData,
            newPageIndex
        ], false);
    }
    onScanComplete(result, scannedFilePaths) {
        this.proxy.sendMessage(2, ScanJobObserver_OnScanComplete_ParamsSpec.$, null, [
            result,
            scannedFilePaths
        ], false);
    }
    onCancelComplete(success) {
        this.proxy.sendMessage(3, ScanJobObserver_OnCancelComplete_ParamsSpec.$, null, [
            success
        ], false);
    }
    onMultiPageScanFail(result) {
        this.proxy.sendMessage(4, ScanJobObserver_OnMultiPageScanFail_ParamsSpec.$, null, [
            result
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ScanJobObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ScanJobObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScanJobObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ScanJobObserver_OnPageProgress_ParamsSpec.$, null, impl.onPageProgress.bind(impl), false);
        this.helper_internal_.registerHandler(1, ScanJobObserver_OnPageComplete_ParamsSpec.$, null, impl.onPageComplete.bind(impl), false);
        this.helper_internal_.registerHandler(2, ScanJobObserver_OnScanComplete_ParamsSpec.$, null, impl.onScanComplete.bind(impl), false);
        this.helper_internal_.registerHandler(3, ScanJobObserver_OnCancelComplete_ParamsSpec.$, null, impl.onCancelComplete.bind(impl), false);
        this.helper_internal_.registerHandler(4, ScanJobObserver_OnMultiPageScanFail_ParamsSpec.$, null, impl.onMultiPageScanFail.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ScanJobObserver {
    static get $interfaceName() {
        return "ash.scanning.mojom.ScanJobObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ScanJobObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ScanJobObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ScanJobObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScanJobObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPageProgress =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ScanJobObserver_OnPageProgress_ParamsSpec.$, null, this.onPageProgress.createReceiverHandler(false /* expectsResponse */), false);
        this.onPageComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ScanJobObserver_OnPageComplete_ParamsSpec.$, null, this.onPageComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onScanComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ScanJobObserver_OnScanComplete_ParamsSpec.$, null, this.onScanComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onCancelComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ScanJobObserver_OnCancelComplete_ParamsSpec.$, null, this.onCancelComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onMultiPageScanFail =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ScanJobObserver_OnMultiPageScanFail_ParamsSpec.$, null, this.onMultiPageScanFail.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ScanServicePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.scanning.mojom.ScanService', scope);
    }
}
export class ScanServiceRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ScanServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getScanners() {
        return this.proxy.sendMessage(0, ScanService_GetScanners_ParamsSpec.$, ScanService_GetScanners_ResponseParamsSpec.$, [], false);
    }
    getScannerCapabilities(scannerId) {
        return this.proxy.sendMessage(1, ScanService_GetScannerCapabilities_ParamsSpec.$, ScanService_GetScannerCapabilities_ResponseParamsSpec.$, [
            scannerId
        ], false);
    }
    startScan(scannerId, settings, observer) {
        return this.proxy.sendMessage(2, ScanService_StartScan_ParamsSpec.$, ScanService_StartScan_ResponseParamsSpec.$, [
            scannerId,
            settings,
            observer
        ], false);
    }
    startMultiPageScan(scannerId, settings, observer) {
        return this.proxy.sendMessage(3, ScanService_StartMultiPageScan_ParamsSpec.$, ScanService_StartMultiPageScan_ResponseParamsSpec.$, [
            scannerId,
            settings,
            observer
        ], false);
    }
    cancelScan() {
        this.proxy.sendMessage(4, ScanService_CancelScan_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the ScanService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ScanServiceReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScanServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ScanService_GetScanners_ParamsSpec.$, ScanService_GetScanners_ResponseParamsSpec.$, impl.getScanners.bind(impl), false);
        this.helper_internal_.registerHandler(1, ScanService_GetScannerCapabilities_ParamsSpec.$, ScanService_GetScannerCapabilities_ResponseParamsSpec.$, impl.getScannerCapabilities.bind(impl), false);
        this.helper_internal_.registerHandler(2, ScanService_StartScan_ParamsSpec.$, ScanService_StartScan_ResponseParamsSpec.$, impl.startScan.bind(impl), false);
        this.helper_internal_.registerHandler(3, ScanService_StartMultiPageScan_ParamsSpec.$, ScanService_StartMultiPageScan_ResponseParamsSpec.$, impl.startMultiPageScan.bind(impl), false);
        this.helper_internal_.registerHandler(4, ScanService_CancelScan_ParamsSpec.$, null, impl.cancelScan.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ScanService {
    static get $interfaceName() {
        return "ash.scanning.mojom.ScanService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ScanServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ScanService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ScanServiceCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ScanServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getScanners =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ScanService_GetScanners_ParamsSpec.$, ScanService_GetScanners_ResponseParamsSpec.$, this.getScanners.createReceiverHandler(true /* expectsResponse */), false);
        this.getScannerCapabilities =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ScanService_GetScannerCapabilities_ParamsSpec.$, ScanService_GetScannerCapabilities_ResponseParamsSpec.$, this.getScannerCapabilities.createReceiverHandler(true /* expectsResponse */), false);
        this.startScan =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ScanService_StartScan_ParamsSpec.$, ScanService_StartScan_ResponseParamsSpec.$, this.startScan.createReceiverHandler(true /* expectsResponse */), false);
        this.startMultiPageScan =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ScanService_StartMultiPageScan_ParamsSpec.$, ScanService_StartMultiPageScan_ResponseParamsSpec.$, this.startMultiPageScan.createReceiverHandler(true /* expectsResponse */), false);
        this.cancelScan =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ScanService_CancelScan_ParamsSpec.$, null, this.cancelScan.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MultiPageScanControllerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.scanning.mojom.MultiPageScanController', scope);
    }
}
export class MultiPageScanControllerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MultiPageScanControllerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    scanNextPage(scannerId, settings) {
        return this.proxy.sendMessage(0, MultiPageScanController_ScanNextPage_ParamsSpec.$, MultiPageScanController_ScanNextPage_ResponseParamsSpec.$, [
            scannerId,
            settings
        ], false);
    }
    removePage(pageIndex) {
        this.proxy.sendMessage(1, MultiPageScanController_RemovePage_ParamsSpec.$, null, [
            pageIndex
        ], false);
    }
    rescanPage(scannerId, settings, pageIndex) {
        return this.proxy.sendMessage(2, MultiPageScanController_RescanPage_ParamsSpec.$, MultiPageScanController_RescanPage_ResponseParamsSpec.$, [
            scannerId,
            settings,
            pageIndex
        ], false);
    }
    completeMultiPageScan() {
        this.proxy.sendMessage(3, MultiPageScanController_CompleteMultiPageScan_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the MultiPageScanController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MultiPageScanControllerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MultiPageScanControllerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MultiPageScanController_ScanNextPage_ParamsSpec.$, MultiPageScanController_ScanNextPage_ResponseParamsSpec.$, impl.scanNextPage.bind(impl), false);
        this.helper_internal_.registerHandler(1, MultiPageScanController_RemovePage_ParamsSpec.$, null, impl.removePage.bind(impl), false);
        this.helper_internal_.registerHandler(2, MultiPageScanController_RescanPage_ParamsSpec.$, MultiPageScanController_RescanPage_ResponseParamsSpec.$, impl.rescanPage.bind(impl), false);
        this.helper_internal_.registerHandler(3, MultiPageScanController_CompleteMultiPageScan_ParamsSpec.$, null, impl.completeMultiPageScan.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MultiPageScanController {
    static get $interfaceName() {
        return "ash.scanning.mojom.MultiPageScanController";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MultiPageScanControllerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MultiPageScanController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MultiPageScanControllerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MultiPageScanControllerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.scanNextPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MultiPageScanController_ScanNextPage_ParamsSpec.$, MultiPageScanController_ScanNextPage_ResponseParamsSpec.$, this.scanNextPage.createReceiverHandler(true /* expectsResponse */), false);
        this.removePage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MultiPageScanController_RemovePage_ParamsSpec.$, null, this.removePage.createReceiverHandler(false /* expectsResponse */), false);
        this.rescanPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, MultiPageScanController_RescanPage_ParamsSpec.$, MultiPageScanController_RescanPage_ResponseParamsSpec.$, this.rescanPage.createReceiverHandler(true /* expectsResponse */), false);
        this.completeMultiPageScan =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, MultiPageScanController_CompleteMultiPageScan_ParamsSpec.$, null, this.completeMultiPageScan.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ScanSourceSpec = { $: {} };
export const ScannerCapabilitiesSpec = { $: {} };
export const ScanSettingsSpec = { $: {} };
export const ScannerSpec = { $: {} };
export const ScanJobObserver_OnPageProgress_ParamsSpec = { $: {} };
export const ScanJobObserver_OnPageComplete_ParamsSpec = { $: {} };
export const ScanJobObserver_OnScanComplete_ParamsSpec = { $: {} };
export const ScanJobObserver_OnCancelComplete_ParamsSpec = { $: {} };
export const ScanJobObserver_OnMultiPageScanFail_ParamsSpec = { $: {} };
export const ScanService_GetScanners_ParamsSpec = { $: {} };
export const ScanService_GetScanners_ResponseParamsSpec = { $: {} };
export const ScanService_GetScannerCapabilities_ParamsSpec = { $: {} };
export const ScanService_GetScannerCapabilities_ResponseParamsSpec = { $: {} };
export const ScanService_StartScan_ParamsSpec = { $: {} };
export const ScanService_StartScan_ResponseParamsSpec = { $: {} };
export const ScanService_StartMultiPageScan_ParamsSpec = { $: {} };
export const ScanService_StartMultiPageScan_ResponseParamsSpec = { $: {} };
export const ScanService_CancelScan_ParamsSpec = { $: {} };
export const MultiPageScanController_ScanNextPage_ParamsSpec = { $: {} };
export const MultiPageScanController_ScanNextPage_ResponseParamsSpec = { $: {} };
export const MultiPageScanController_RemovePage_ParamsSpec = { $: {} };
export const MultiPageScanController_RescanPage_ParamsSpec = { $: {} };
export const MultiPageScanController_RescanPage_ResponseParamsSpec = { $: {} };
export const MultiPageScanController_CompleteMultiPageScan_ParamsSpec = { $: {} };
mojo.internal.Struct(ScanSourceSpec.$, 'ScanSource', [
    mojo.internal.StructField('type', 0, 0, SourceTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageSizes', 16, 0, mojo.internal.Array(PageSizeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('colorModes', 24, 0, mojo.internal.Array(ColorModeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resolutions', 32, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(ScannerCapabilitiesSpec.$, 'ScannerCapabilities', [
    mojo.internal.StructField('sources', 0, 0, mojo.internal.Array(ScanSourceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanSettingsSpec.$, 'ScanSettings', [
    mojo.internal.StructField('sourceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scanToPath', 8, 0, mojoBase_mojom_FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fileType', 16, 0, FileTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('colorMode', 20, 0, ColorModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageSize', 24, 0, PageSizeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resolutionDpi', 28, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(ScannerSpec.$, 'Scanner', [
    mojo.internal.StructField('id', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ScanJobObserver_OnPageProgress_ParamsSpec.$, 'ScanJobObserver_OnPageProgress_Params', [
    mojo.internal.StructField('pageNumber', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('progressPercent', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanJobObserver_OnPageComplete_ParamsSpec.$, 'ScanJobObserver_OnPageComplete_Params', [
    mojo.internal.StructField('pageData', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('newPageIndex', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ScanJobObserver_OnScanComplete_ParamsSpec.$, 'ScanJobObserver_OnScanComplete_Params', [
    mojo.internal.StructField('result', 0, 0, ScanResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scannedFilePaths', 8, 0, mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ScanJobObserver_OnCancelComplete_ParamsSpec.$, 'ScanJobObserver_OnCancelComplete_Params', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanJobObserver_OnMultiPageScanFail_ParamsSpec.$, 'ScanJobObserver_OnMultiPageScanFail_Params', [
    mojo.internal.StructField('result', 0, 0, ScanResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanService_GetScanners_ParamsSpec.$, 'ScanService_GetScanners_Params', [], [[0, 8],]);
mojo.internal.Struct(ScanService_GetScanners_ResponseParamsSpec.$, 'ScanService_GetScanners_ResponseParams', [
    mojo.internal.StructField('scanners', 0, 0, mojo.internal.Array(ScannerSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanService_GetScannerCapabilities_ParamsSpec.$, 'ScanService_GetScannerCapabilities_Params', [
    mojo.internal.StructField('scannerId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanService_GetScannerCapabilities_ResponseParamsSpec.$, 'ScanService_GetScannerCapabilities_ResponseParams', [
    mojo.internal.StructField('capabilities', 0, 0, ScannerCapabilitiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanService_StartScan_ParamsSpec.$, 'ScanService_StartScan_Params', [
    mojo.internal.StructField('scannerId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ScanSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('observer', 16, 0, mojo.internal.InterfaceProxy(ScanJobObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ScanService_StartScan_ResponseParamsSpec.$, 'ScanService_StartScan_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanService_StartMultiPageScan_ParamsSpec.$, 'ScanService_StartMultiPageScan_Params', [
    mojo.internal.StructField('scannerId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ScanSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('observer', 16, 0, mojo.internal.InterfaceProxy(ScanJobObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ScanService_StartMultiPageScan_ResponseParamsSpec.$, 'ScanService_StartMultiPageScan_ResponseParams', [
    mojo.internal.StructField('controller', 0, 0, mojo.internal.InterfaceProxy(MultiPageScanControllerRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScanService_CancelScan_ParamsSpec.$, 'ScanService_CancelScan_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiPageScanController_ScanNextPage_ParamsSpec.$, 'MultiPageScanController_ScanNextPage_Params', [
    mojo.internal.StructField('scannerId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ScanSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MultiPageScanController_ScanNextPage_ResponseParamsSpec.$, 'MultiPageScanController_ScanNextPage_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiPageScanController_RemovePage_ParamsSpec.$, 'MultiPageScanController_RemovePage_Params', [
    mojo.internal.StructField('pageIndex', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiPageScanController_RescanPage_ParamsSpec.$, 'MultiPageScanController_RescanPage_Params', [
    mojo.internal.StructField('scannerId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ScanSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageIndex', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(MultiPageScanController_RescanPage_ResponseParamsSpec.$, 'MultiPageScanController_RescanPage_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiPageScanController_CompleteMultiPageScan_ParamsSpec.$, 'MultiPageScanController_CompleteMultiPageScan_Params', [], [[0, 8],]);
