import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style scanning-shared scanning-fonts">:host-context(body.jelly-enabled) #appTitle{font:var(--cros-display-6-font)}:host-context(body.jelly-enabled) #moreSettingsButton{font:var(--cros-annotation-1-font)}#appTitle{color:var(--scanning-app-title-text-color);font-family:var(--scanning-app-title-font-family);font-size:var(--scanning-app-title-font-size);font-weight:var(--scanning-medium-font-weight);line-height:var(--scanning-app-title-line-height);margin-bottom:16px;margin-inline-end:0;margin-inline-start:32px;margin-top:0}#moreSettingsButton{--ink-color:var(--menu-text-color);--paper-ripple-opacity:0;align-items:center;background:none;border:none;border-radius:initial;color:var(--scanning-more-settings-text-color);display:flex;font-family:var(--scanning-more-settings-font-family);font-size:var(--scanning-more-settings-font-size);font-weight:var(--scanning-regular-font-weight);height:unset;line-height:var(--scanning-more-settings-line-height);margin-bottom:8px;margin-inline-end:40px;margin-inline-start:32px;margin-top:0;padding-inline:0;text-transform:none;width:280px}#moreSettingsButton:active{box-shadow:none}#moreSettingsButton:focus{outline:none}#moreSettingsButton>iron-icon{height:20px;width:20px}#moreSettingsButton>span{flex:1}#more-settings-line-separator{border-bottom:var(--cr-separator-line);margin-bottom:8px;margin-inline-end:40px;margin-inline-start:32px;margin-top:8px;width:280px}#scanningContainer{box-sizing:border-box;display:block;margin:0 auto;position:relative;width:var(--container-width)}#leftPanel{margin-inline-end:var(--left-panel-margin-inline-end);margin-inline-start:var(--left-panel-margin-inline-start);width:var(--left-panel-width)}#panelContainer{display:flex;height:calc(100vh - var(--panel-container-margin-top));margin-top:var(--panel-container-margin-top)}#rightPanel{display:flex;flex-direction:column;margin-inline-end:var(--right-panel-margin-inline-end);margin-inline-start:var(--right-panel-margin-inline-start);padding-inline-end:var(--right-panel-padding-inline-end);padding-inline-start:var(--right-panel-padding-inline-start);width:352px}#cr-container-shadow-top,#cr-container-shadow-bottom{box-shadow:inset 0 5px 3px -3px rgba(0,0,0,.2);margin-inline-end:40px;margin-inline-start:32px}#settingsSection{display:flex;flex:1;flex-direction:column;min-height:0}#container{overflow:overlay}.scan-button-container{display:flex;justify-content:flex-end;margin-bottom:32px;margin-inline-end:40px;margin-inline-start:32px;margin-top:32px;width:280px}#toast{--cr-toast-background:var(--cros-toast-background-color);--cr-toast-text-color:var(--cros-toast-text-color);bottom:0;left:0}#toastDiv{align-items:center;display:flex;min-width:280px}#toastInfoIcon{fill:var(--cros-toast-icon-color-error);margin-inline-end:10px;margin-inline-start:-8px}#toastText{color:var(--cros-toast-text-color)}#getHelpDiv{flex:1;margin-inline-start:10px;text-align:right}#getHelpLink{color:var(--cros-link-color);text-decoration:none}#dialogInfoIcon{display:block;fill:var(--cros-icon-color-alert);margin-bottom:14px}#scanFailedDialog [slot=body]{color:var(--cros-text-color-secondary)}#scanFailedDialog [slot=title]{color:var(--cros-text-color-primary)}cr-dialog#scanFailedDialog::part(dialog){background-color:var(--cros-bg-color-elevation-3)}</style>
<div id="scanningContainer">
  <loading-page hidden="[[scannersLoaded]]" app-state="[[appState]]"
      on-retry-click="onRetryClick" on-learn-more-click="onLearnMoreClick">
  </loading-page>
  <div id="panelContainer" hidden="[[!scannersLoaded]]">
    <div id="leftPanel">
      <scan-preview id="scanPreview" app-state="[[appState]]"
          object-urls="[[objectUrls]]" page-number="[[pageNumber]]"
          progress-percent="[[progressPercent]]"
          is-multi-page-scan="[[isMultiPageScan]]"
          on-remove-page="onRemovePage"
          on-rescan-page="onRescanPage"></scan-preview>
    </div>
    <div id="rightPanel">
      <h1 id="appTitle">[[i18n('appTitle')]]</h1>
      <div id="settingsSection" hidden="[[!showScanSettings]]">
        <div id="container" show-bottom-shadow>
          <scanner-select id="scannerSelect" scanners="[[scanners]]"
              disabled="[[settingsDisabled]]"
              selected-scanner-id="{{selectedScannerId}}"
              last-used-scanner-id="[[lastUsedScannerId]]"
              scanner-info-map="[[scannerInfoMap]]"></scanner-select>
          <source-select id="sourceSelect" options="[[capabilities.sources]]"
              disabled="[[settingsDisabled]]"
              selected-option="{{selectedSource}}"></source-select>
          <scan-to-select id="scanToSelect"
              disabled="[[settingsDisabled]]"
              selected-file-path="{{selectedFilePath}}"
              selected-folder="{{selectedFolder}}">
          </scan-to-select>
          <file-type-select id="fileTypeSelect"
              disabled="[[settingsDisabled]]"
              selected-file-type="{{selectedFileType}}"></file-type-select>
          <multi-page-checkbox id="multiPageCheckbox"
              hidden="[[!showMultiPageCheckbox]]"
              multi-page-scan-checked="{{multiPageScanChecked}}"
              disabled="[[settingsDisabled]]">
          </multi-page-checkbox>
          <div id="more-settings-line-separator"></div>
          <cr-button id="moreSettingsButton" on-click="toggleClicked"
              aria-expanded="[[opened]]">
            <span>[[i18n('moreSettings')]]</span>
            <iron-icon icon="[[arrowIconDirection]]"></iron-icon>
          </cr-button>
          <iron-collapse id="collapse" opened="{{opened}}">
            <color-mode-select id="colorModeSelect"
                options="[[selectedSourceColorModes]]"
                disabled="[[settingsDisabled]]"
                selected-option="{{selectedColorMode}}">
            </color-mode-select>
            <page-size-select id="pageSizeSelect"
                options="[[selectedSourcePageSizes]]"
                disabled="[[settingsDisabled]]"
                selected-option="{{selectedPageSize}}">
            </page-size-select>
            <resolution-select id="resolutionSelect"
                options="[[selectedSourceResolutions]]"
                disabled="[[settingsDisabled]]"
                selected-option="{{selectedResolution}}">
            </resolution-select>
          </iron-collapse>
        </div>
        <div class="scan-button-container">
          <cr-button id="scanButton" class="action-button" on-click="onScanClick"
              disabled$="[[settingsDisabled]]"
              hidden$="[[showCancelButton]]">
            [[scanButtonText]]
          </cr-button>
          <cr-button id="cancelButton" on-click="onCancelClick"
              hidden$="[[!showCancelButton]]"
              disabled$="[[cancelButtonDisabled]]">
            [[i18n('cancelButtonText')]]
          </cr-button>
        </div>
      </div>
      <template is="dom-if" if="[[showDoneSection]]">
        <scan-done-section num-files-saved="[[getNumFilesSaved(pageNumber)]]"
            on-done-click="onDoneClick" on-file-not-found="onFileNotFound"
            scanned-file-paths="[[scannedFilePaths]]"
            selected-folder="[[selectedFolder]]"
            selected-file-type="[[selectedFileType]]">
        </scan-done-section>
      </template>
      <template is="dom-if" if="[[showMultiPageScan]]">
        <multi-page-scan page-number="[[pageNumber]]" app-state="[[appState]]"
            on-scan-next-page="onScanNextPage"
            on-complete-multi-page-scan="onCompleteMultiPageScan"
            on-cancel-click="onCancelClick">
        </multi-page-scan>
      </template>
    </div>
  </div>
  <cr-toast id="toast" duration="5000">
    <div id="toastDiv">
      <iron-icon id="toastInfoIcon" icon="cr:info-outline"
          hidden="[[!showToastInfoIcon]]"></iron-icon>
      <span id="toastText">[[i18n(toastMessageKey)]]</span>
      <div id="getHelpDiv">
        <a id="getHelpLink" target="_blank"
            href="http://support.google.com/chromebook?p=chrome_scanning"
            hidden="[[!showToastHelpLink]]">
          [[i18n('getHelpLinkText')]]</a>
      </div>
    </div>
  </cr-toast>
  <cr-dialog id="scanFailedDialog" on-cancel="onScanFailedDialogOkClick">
    <div slot="title">
      <iron-icon id="dialogInfoIcon" icon="cr:info-outline" aria-hidden="true">
      </iron-icon>
      [[i18n('scanFailedDialogTitleText')]]
    </div>
    <div id="scanFailedDialogText" slot="body">
      [[i18n(scanFailedDialogTextKey)]]
    </div>
    <div slot="button-container">
      <cr-button class="cancel-button"
          on-click="onScanFailedDialogGetHelpClick">
        [[i18n('getHelpLinkText')]]
      </cr-button>
      <cr-button id="okButton" class="action-button"
          on-click="onScanFailedDialogOkClick">
        [[i18n('okButtonLabel')]]
      </cr-button>
    </div>
  </cr-dialog>
</div>
<!--_html_template_end_-->`;
}
