// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used by the Scanning App UI in ash/ to
 * provide access to the ScanningHandler which invokes functions that only exist
 * in chrome/.
 */
import { sendWithPromise } from 'chrome://resources/ash/common/cr.m.js';
export class ScanningBrowserProxyImpl {
    initialize() {
        chrome.send('initialize');
    }
    requestScanToLocation() {
        return sendWithPromise('requestScanToLocation');
    }
    showFileInLocation(pathToFile) {
        return sendWithPromise('showFileInLocation', pathToFile);
    }
    getPluralString(name, count) {
        return sendWithPromise('getPluralString', name, count);
    }
    recordScanJobSettings(scanJobSettings) {
        chrome.send('recordScanJobSettings', [scanJobSettings]);
    }
    getMyFilesPath() {
        return sendWithPromise('getMyFilesPath');
    }
    openFilesInMediaApp(filePaths) {
        chrome.send('openFilesInMediaApp', [filePaths]);
    }
    recordScanCompleteAction(action) {
        chrome.send('recordScanCompleteAction', [action]);
    }
    recordNumScanSettingChanges(numChanges) {
        chrome.send('recordNumScanSettingChanges', [numChanges]);
    }
    saveScanSettings(scanSettings) {
        chrome.send('saveScanSettings', [scanSettings]);
    }
    getScanSettings() {
        return sendWithPromise('getScanSettings');
    }
    ensureValidFilePath(filePath) {
        return sendWithPromise('ensureValidFilePath', filePath);
    }
    recordNumCompletedScans(numCompletedScans) {
        chrome.send('recordNumCompletedScans', [numCompletedScans]);
    }
    static getInstance() {
        return instance || (instance = new ScanningBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
