// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./base_page.js";import"./shimless_rma_shared.css.js";import"//resources/ash/common/cr_elements/cr_radio_button/cr_radio_button.js";import"//resources/ash/common/cr_elements/cr_radio_group/cr_radio_group.js";import{assert}from"chrome://resources/ash/common/assert.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getShimlessRmaService}from"./mojo_interface_provider.js";import{getTemplate}from"./onboarding_choose_wipe_device_page.html.js";import{enableNextButton,focusPageTitle}from"./shimless_rma_util.js";const OnboardingChooseWipeDevicePageBase=I18nMixin(PolymerElement);var WipeDeviceOption;(function(WipeDeviceOption){WipeDeviceOption["WIPE_DEVICE"]="wipeDevice";WipeDeviceOption["PRESERVE_DATA"]="preserveData"})(WipeDeviceOption||(WipeDeviceOption={}));export class OnboardingChooseWipeDevicePage extends OnboardingChooseWipeDevicePageBase{constructor(){super(...arguments);this.shimlessRmaService=getShimlessRmaService()}static get is(){return"onboarding-choose-wipe-device-page"}static get template(){return getTemplate()}static get properties(){return{allButtonsDisabled:Boolean,wipeDeviceOptionEnum:{type:Object,value:WipeDeviceOption},selectedWipeDeviceOption:{type:String,value:""}}}ready(){super.ready();focusPageTitle(this)}onOptionChanged(event){this.selectedWipeDeviceOption=event.detail.value;enableNextButton(this)}onNextButtonClick(){assert(!!this.selectedWipeDeviceOption);return this.shimlessRmaService.setWipeDevice(this.selectedWipeDeviceOption===WipeDeviceOption.WIPE_DEVICE)}}customElements.define(OnboardingChooseWipeDevicePage.is,OnboardingChooseWipeDevicePage);