import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared">#nextButtonCaret{margin-inline-start:5px}#navigationButtonWrapper{bottom:var(--header-footer-height);position:absolute}#getStartedButton{margin-inline-end:8px}#unqualifiedComponentsLink{color:var(--cros-link-color)}.button-spinner{height:20px;margin-inline-start:5px;width:20px}iron-icon[icon='shimless-icon:warning']{fill:var(--cros-icon-color-warning)}</style>

<base-page>
  <div slot="left-pane">
    <h1 tabindex="-1">[[i18n('welcomeTitleText')]]</h1>
    <div class="instructions">[[i18n('beginRmaWarningText')]]</div>
    <div id="verificationMessage" class="icon-message">
      <paper-spinner-lite id="busyIcon" class="small-spinner"
          hidden$="[[!verificationInProgress]]" active>
      </paper-spinner-lite>
      <iron-icon id="verificationIcon"
        icon$="[[getVerificationIcon(isCompliant)]]"
        hidden$="[[verificationInProgress]]" class="small-icon">
      </iron-icon>
      <div aria-live="polite">
        <span hidden$="[[!verificationInProgress]]" class="instructions">
          [[i18n('validatingComponentsText')]]
        </span>
        <span hidden$="[[verificationInProgress]]" class="instructions">
          <span hidden$="[[!isCompliant]]">
            [[i18n('validatedComponentsSuccessText')]]
          </span>
          <span inner-h-t-m-l="[[verificationFailedMessage]]"
              hidden$="[[isCompliant || isSkipped]]" class="instructions">
          </span>
          <span id="verificationSkipMessage" hidden$="[[!isSkipped]]">
            [[i18n('validatedComponentsSkipText')]]
          </span>
        </span>
      </div>
    </div>
    <div id="navigationButtonWrapper">
      <cr-button id="getStartedButton" class="action-button"
          on-click="onGetStartedButtonClicked"
          disabled="[[isGetStartedButtonDisabled(verificationInProgress,
          allButtonsDisabled)]]">
        [[i18n('getStartedButtonLabel')]]
        <paper-spinner-lite class="button-spinner"
            hidden$="[[!getStartedButtonClicked]]" active>
        </paper-spinner-lite>
      </cr-button>
      <cr-button id="landingExit" class="pill"
          on-click="onLandingExitButtonClicked"
          disabled="[[allButtonsDisabled]]"
          hidden$="[[!canExit]]">
        <span id="exitButtonLabel">
          [[i18n('exitButtonLabel')]]
        </span>
        <paper-spinner-lite class="button-spinner"
            hidden$="[[!confirmExitButtonClicked]]" active>
        </paper-spinner-lite>
      </cr-button>
    </div>
  </div>
  <div slot="right-pane">
    <div class="illustration-wrapper" aria-hidden="true">
      <img class="illustration" src="illustrations/repair_start.svg"
          alt="[[i18n('repairStartAltText')]]">
    </div>
  </div>
</base-page>

<cr-dialog id="unqualifiedComponentsDialog" on-cancel="closeDialog"
    ignore-popstate>
  <div slot="title">[[i18n('unqualifiedComponentsTitle')]]</div>
  <div slot="body" id="dialogBody">[[componentsList]]</div>
  <div class="dialog-footer" slot="button-container">
    <cr-button class="action-button" on-click="closeDialog">
      [[i18n('okButtonLabel')]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}