import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared">:host{display:inline-flex}.error{color:var(--cros-text-color-alert);font-weight:500}#networkList{--cros-icon-color-primary:grey;flex:1}</style>

<base-page>
  <div slot="left-pane">
    <h1 tabindex="-1">[[i18n('connectNetworkTitleText')]]</h1>
    <div class="instructions">[[i18n('connectNetworkDescriptionText')]]</div>
  </div>
  <div id="container" slot="right-pane">
    <div class="scroll-container">
      <network-list id="networkList" show-technology-badge
          networks="[[networks]]" on-selected="onNetworkSelected"
          disabled="[[allButtonsDisabled]]">
      </network-list>
    </div>
    <div class="gradient unequal-panes"></div>
  </div>
</base-page>

<cr-dialog id="dialog" close-text="close">
  <div slot="title">
    [[getDialogTitle(networkName, networkType, networkShowConnect)]]
  </div>
  <div slot="body">
    <network-config id="networkConfig" enable-connect="{{enableConnect}}"
      error="{{error}}" on-close="onConfigClose" name="{{networkName}}"
      on-properties-set="onPropertiesSet" type="{{networkType}}"
      connect-on-enter="[[networkShowConnect]]" guid="[[guid]]">
    </network-config>
  </div>
  <div class="dialog-footer" slot="button-container">
    <template is="dom-if" if="[[error]]" restamp>
      <div class="flex error">[[getError(error)]]</div>
    </template>
    <cr-button id="cancelButton" on-click="closeConfig">
        [[i18n('connectNetworkDialogCancelButtonText')]]
    </cr-button>
    <cr-button id="connectButton" class="action-button"
        on-click="connectNetwork" disabled="[[!enableConnect]]"
        hidden$="[[!networkShowConnect]]">
      [[i18n('connectNetworkDialogConnectButtonText')]]
    </cr-button>
    <cr-button id="disconnectButton" class="action-button"
      on-click="disconnectNetwork"  hidden$="[[networkShowConnect]]">
      [[i18n('connectNetworkDialogDisconnectButtonText')]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}