// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./base_page.js";import"./repair_component_chip.js";import"./shimless_rma_shared.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ComponentTypeToId}from"./data.js";import{CLICK_REPAIR_COMPONENT_BUTTON}from"./events.js";import{getShimlessRmaService}from"./mojo_interface_provider.js";import{getTemplate}from"./onboarding_select_components_page.html.js";import{ComponentRepairStatus}from"./shimless_rma.mojom-webui.js";import{enableNextButton,executeThenTransitionState,focusPageTitle}from"./shimless_rma_util.js";const NUM_COLUMNS=2;const OnboardingSelectComponentsPageElementBase=I18nMixin(PolymerElement);export class OnboardingSelectComponentsPageElement extends OnboardingSelectComponentsPageElementBase{constructor(){super(...arguments);this.shimlessRmaService=getShimlessRmaService();this.onComponentClickedListener=null}static get is(){return"onboarding-select-components-page"}static get template(){return getTemplate()}static get properties(){return{allButtonsDisabled:Boolean,componentCheckboxes:{type:Array,value:()=>[]},reworkFlowLinkText:{type:String,value:""},focusedComponentIndex:{type:Number,value:-1}}}static get observers(){return["updateIsFirstClickableComponent(componentCheckboxes.*)"]}connectedCallback(){super.connectedCallback();this.focusOnCurrentComponent();window.addEventListener("keydown",this.handleKeyDownEvent);this.onComponentClickedListener=e=>this.componentClicked(e);window.addEventListener(CLICK_REPAIR_COMPONENT_BUTTON,this.onComponentClickedListener)}componentClicked(event){const componentIndex=this.componentCheckboxes.findIndex((component=>component.uniqueId===event.detail));if(componentIndex===-1||this.componentCheckboxes[componentIndex].disabled){return}this.focusedComponentIndex=componentIndex;this.focusOnCurrentComponent()}handleKeyDownEvent(event){if(event.key!=="ArrowRight"&&event.key!=="ArrowDown"&&event.key!=="ArrowLeft"&&event.key!=="ArrowUp"){return}if(this.focusedComponentIndex===-1){return}if(!this.shadowRoot.activeElement||this.shadowRoot.activeElement.tagName!=="REPAIR-COMPONENT-CHIP"){return}if(event.key==="ArrowRight"||event.key==="ArrowDown"){let step=1;if(event.key==="ArrowDown"){step=NUM_COLUMNS}let newIndex=this.focusedComponentIndex+step;while(newIndex<this.componentCheckboxes.length&&this.componentCheckboxes[newIndex].disabled){newIndex+=step}if(newIndex<this.componentCheckboxes.length){this.focusedComponentIndex=newIndex}}if(event.key==="ArrowLeft"||event.key==="ArrowUp"){let step=1;if(event.key==="ArrowUp"){step=NUM_COLUMNS}let newIndex=this.focusedComponentIndex-step;while(newIndex>=0&&this.componentCheckboxes[newIndex].disabled){newIndex-=step}if(newIndex>=0){this.focusedComponentIndex=newIndex}}this.focusOnCurrentComponent()}disconnectedCallback(){super.disconnectedCallback();window.removeEventListener("keydown",this.handleKeyDownEvent);if(this.onComponentClickedListener){window.removeEventListener(CLICK_REPAIR_COMPONENT_BUTTON,this.onComponentClickedListener)}}ready(){super.ready();this.setReworkFlowLink();this.getComponents();enableNextButton(this);const scrollContainer=this.shadowRoot.querySelector(".scroll-container");assert(scrollContainer);scrollContainer.addEventListener("scroll",(event=>{assert(event&&event.target);const target=event.target;const gradient=this.shadowRoot.querySelector(".gradient");assert(gradient);if(target.scrollHeight-target.scrollTop===target.clientHeight){gradient.style.setProperty("visibility","hidden")}else{gradient.style.setProperty("visibility","visible")}}));focusPageTitle(this)}async getComponents(){const result=await this.shimlessRmaService.getComponentList();if(!result||!result.hasOwnProperty("components")){console.error("Could not get components!");return}this.componentCheckboxes=result.components.map(((item,index)=>{assert(item.component);return{component:item.component,uniqueId:index,id:ComponentTypeToId[item.component],identifier:item.identifier,name:this.i18n(ComponentTypeToId[item.component]),checked:item.state===ComponentRepairStatus.kReplaced,disabled:item.state===ComponentRepairStatus.kMissing}}));this.focusedComponentIndex=this.componentCheckboxes.findIndex((component=>!component.disabled))}focusOnCurrentComponent(){if(this.focusedComponentIndex!==-1){const componentChip=this.shadowRoot.querySelector(`[unique-id="${this.componentCheckboxes[this.focusedComponentIndex].uniqueId}"]`);assert(componentChip);const componentButton=componentChip.shadowRoot.querySelector("#componentButton");assert(componentButton);componentButton.focus()}}getComponentRepairStateList(){return this.componentCheckboxes.map((item=>{let state=ComponentRepairStatus.kOriginal;if(item.disabled){state=ComponentRepairStatus.kMissing}else if(item.checked){state=ComponentRepairStatus.kReplaced}return{component:item.component,state:state,identifier:item.identifier}}))}onReworkFlowLinkClicked(e){e.preventDefault();executeThenTransitionState(this,(()=>this.shimlessRmaService.reworkMainboard()))}onNextButtonClick(){return this.shimlessRmaService.setComponentList(this.getComponentRepairStateList())}setReworkFlowLink(){this.reworkFlowLinkText=this.i18nAdvanced("reworkFlowLinkText",{attrs:["id"]});const linkElement=this.shadowRoot.querySelector("#reworkFlowLink");assert(linkElement);linkElement.setAttribute("href","#");linkElement.addEventListener("click",(e=>{if(this.allButtonsDisabled){return}this.onReworkFlowLinkClicked(e)}))}isComponentDisabled(componentDisabled){return this.allButtonsDisabled||componentDisabled}updateIsFirstClickableComponent(){const firstClickableComponent=this.componentCheckboxes.find((component=>!component.disabled));this.componentCheckboxes.forEach((component=>{component.isFirstClickableComponent=component===firstClickableComponent}))}getComponentRepairStateListForTesting(){return this.getComponentRepairStateList()}}customElements.define(OnboardingSelectComponentsPageElement.is,OnboardingSelectComponentsPageElement);