// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"./shimless_rma_shared.css.js";import"./base_page.js";import"./icons.html.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getShimlessRmaService}from"./mojo_interface_provider.js";import{getTemplate}from"./onboarding_update_page.html.js";import{HardwareVerificationStatusObserverReceiver,OsUpdateObserverReceiver,OsUpdateOperation,UpdateErrorCode}from"./shimless_rma.mojom-webui.js";import{disableAllButtons,enableAllButtons,enableNextButton,focusPageTitle}from"./shimless_rma_util.js";const OnboardingUpdatePageElementBase=I18nMixin(PolymerElement);export class OnboardingUpdatePageElement extends OnboardingUpdatePageElementBase{static get is(){return"onboarding-update-page"}static get template(){return getTemplate()}static get properties(){return{allButtonsDisabled:Boolean,currentVersionText:{type:String,value:""},updateVersionButtonLabel:{type:String,value:""},updateInProgress:{type:Boolean,value:false,observer:OnboardingUpdatePageElement.prototype.onUpdateInProgressChange},verificationFailedMessage:{type:String,value:""},unqualifiedComponentsText:{type:String,value:""},osUpdateEncounteredError:{type:Boolean,value:false}}}constructor(){super();if(!loadTimeData.getBoolean("osUpdateEnabled")){return}this.shimlessRmaService=getShimlessRmaService();this.currentVersion="";this.osUpdateObserverReceiver=new OsUpdateObserverReceiver(this);this.shimlessRmaService.observeOsUpdateProgress(this.osUpdateObserverReceiver.$.bindNewPipeAndPassRemote());this.isCompliant=true;this.hwVerificationObserverReceiver=new HardwareVerificationStatusObserverReceiver(this);this.shimlessRmaService.observeHardwareVerificationStatus(this.hwVerificationObserverReceiver.$.bindNewPipeAndPassRemote())}ready(){super.ready();if(!loadTimeData.getBoolean("osUpdateEnabled")){return}this.getCurrentVersionText();this.getUpdateVersionNumber();enableNextButton(this);focusPageTitle(this)}getCurrentVersionText(){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}this.shimlessRmaService.getCurrentOsVersion().then((res=>{if(res.version!=null){this.currentVersion=res.version}else{this.currentVersion="0.0.0.0"}this.currentVersionText=this.i18n("currentVersionOutOfDateText",this.currentVersion)}))}getUpdateVersionNumber(){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}this.shimlessRmaService.checkForOsUpdates().then((res=>{assert(res.updateAvailable);this.updateVersionButtonLabel=this.i18n("updateVersionRestartLabel",res?.version||"")}))}updateOs(){this.updateInProgress=true;this.shimlessRmaService.updateOs().then((res=>{if(!res.updateStarted){this.updateInProgress=false}}))}onUpdateButtonClicked(){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}this.updateOs()}onRetryUpdateButtonClicked(){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}assert(this.osUpdateEncounteredError);this.osUpdateEncounteredError=false;this.updateOs()}onNextButtonClick(){return this.shimlessRmaService.updateOsSkipped()}onOsUpdateProgressUpdated(operation,_progress,error){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}if(!this.updateInProgress){return}if(operation===OsUpdateOperation.kIdle||operation===OsUpdateOperation.kReportingErrorEvent||operation===OsUpdateOperation.kNeedPermissionToUpdate||operation===OsUpdateOperation.kDisabled){this.updateInProgress=false;if(error!==UpdateErrorCode.kSuccess){this.osUpdateEncounteredError=true}}}onHardwareVerificationResult(result){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}this.isCompliant=result.passResult!==undefined;if(!this.isCompliant){this.unqualifiedComponentsText=result.failResult.componentInfo;this.setVerificationFailedMessage()}}setVerificationFailedMessage(){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}this.verificationFailedMessage=this.i18nAdvanced("osUpdateUnqualifiedComponentsTopText",{attrs:["id"]});const linkElement=this.shadowRoot.querySelector("#unqualifiedComponentsLink");assert(linkElement);linkElement.setAttribute("href","#");const dialog=this.shadowRoot.querySelector("#unqualifiedComponentsDialog");assert(dialog);linkElement.addEventListener("click",(()=>dialog.showModal()))}closeDialog(){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}const dialog=this.shadowRoot.querySelector("#unqualifiedComponentsDialog");assert(dialog);dialog.close()}onUpdateInProgressChange(){if(!loadTimeData.getBoolean("osUpdateEnabled")){return}if(this.updateInProgress){disableAllButtons(this,false)}else{enableAllButtons(this)}}shouldShowUpdateInstructions(){return!this.updateInProgress&&!this.osUpdateEncounteredError}}customElements.define(OnboardingUpdatePageElement.is,OnboardingUpdatePageElement);