// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"./base_page.js";import"./calibration_component_chip.js";import"./icons.html.js";import"./shimless_rma_shared.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ComponentTypeToId}from"./data.js";import{CLICK_CALIBRATION_COMPONENT_BUTTON}from"./events.js";import{getShimlessRmaService}from"./mojo_interface_provider.js";import{getTemplate}from"./reimaging_calibration_failed_page.html.js";import{CalibrationStatus}from"./shimless_rma.mojom-webui.js";import{disableNextButton,enableNextButton,executeThenTransitionState,focusPageTitle}from"./shimless_rma_util.js";const NUM_COLUMNS=1;const ReimagingCalibrationFailedPageBase=I18nMixin(PolymerElement);export class ReimagingCalibrationFailedPage extends ReimagingCalibrationFailedPageBase{static get is(){return"reimaging-calibration-failed-page"}static get template(){return getTemplate()}static get properties(){return{allButtonsDisabled:Boolean,componentCheckboxes:{type:Array,value:()=>[]},focusedComponentIndex:{type:Number,value:-1}}}static get observers(){return["updateIsFirstClickableComponent(componentCheckboxes.*)","updateNextButtonAvailability(componentCheckboxes.*)"]}constructor(){super();this.shimlessRmaService=getShimlessRmaService();this.componentClicked=event=>{const componentIndex=this.componentCheckboxes.findIndex((component=>component.uniqueId===event.detail));if(componentIndex===-1||this.componentCheckboxes[componentIndex].disabled){return}this.focusedComponentIndex=componentIndex;this.focusOnCurrentComponent()};this.handleKeyDownEvent=event=>{if(event.key!=="ArrowRight"&&event.key!=="ArrowDown"&&event.key!=="ArrowLeft"&&event.key!=="ArrowUp"){return}if(this.focusedComponentIndex===-1){return}if(!this.shadowRoot.activeElement||this.shadowRoot.activeElement.tagName!=="CALIBRATION-COMPONENT-CHIP"){return}if(event.key==="ArrowRight"||event.key==="ArrowDown"){let step=1;if(event.key==="ArrowDown"){step=NUM_COLUMNS}let newIndex=this.focusedComponentIndex+step;while(newIndex<this.componentCheckboxes.length&&this.componentCheckboxes[newIndex].disabled){newIndex+=step}if(newIndex<this.componentCheckboxes.length){this.focusedComponentIndex=newIndex}}if(event.key==="ArrowLeft"||event.key==="ArrowUp"){let step=1;if(event.key==="ArrowUp"){step=NUM_COLUMNS}let newIndex=this.focusedComponentIndex-step;while(newIndex>=0&&this.componentCheckboxes[newIndex].disabled){newIndex-=step}if(newIndex>=0){this.focusedComponentIndex=newIndex}}this.focusOnCurrentComponent()};this.onExitButtonClick=()=>{if(this.tryingToSkipWithFailedComponents()){const dialog=this.shadowRoot.querySelector("#failedComponentsDialog");assert(dialog);dialog.showModal();return Promise.reject(new Error("Attempting to skip with failed components."))}return this.skipCalibration()}}ready(){super.ready();this.getInitialComponentsList();this.shadowRoot.querySelector(".scroll-container").addEventListener("scroll",(event=>{const gradient=this.shadowRoot.querySelector(".gradient");assert(gradient);const dialog=this.shadowRoot.querySelector("#failedComponentsDialog");assert(dialog);dialog.close();const target=event.target;assert(target);if(target.scrollHeight-target.scrollTop===target.clientHeight){gradient.style.setProperty("visibility","hidden")}else{gradient.style.setProperty("visibility","visible")}}));focusPageTitle(this)}getInitialComponentsList(){this.shimlessRmaService.getCalibrationComponentList().then((result=>{if(!result||!result.hasOwnProperty("components")){console.error("Could not get components!");return}this.componentCheckboxes=result.components.map(((item,index)=>({component:item.component,uniqueId:index,id:ComponentTypeToId[item.component],name:this.i18n(ComponentTypeToId[item.component]),checked:false,failed:item.status===CalibrationStatus.kCalibrationFailed,disabled:item.status!==CalibrationStatus.kCalibrationFailed})));this.focusedComponentIndex=this.componentCheckboxes.findIndex((component=>!component.disabled))}))}connectedCallback(){super.connectedCallback();window.addEventListener("keydown",this.handleKeyDownEvent);window.addEventListener(CLICK_CALIBRATION_COMPONENT_BUTTON,this.componentClicked)}disconnectedCallback(){super.disconnectedCallback();window.removeEventListener("keydown",this.handleKeyDownEvent);window.removeEventListener(CLICK_CALIBRATION_COMPONENT_BUTTON,this.componentClicked)}focusOnCurrentComponent(){if(this.focusedComponentIndex!==-1){const componentChip=this.shadowRoot.querySelector(`[unique-id="${this.componentCheckboxes[this.focusedComponentIndex].uniqueId}"]`);assert(componentChip);const button=componentChip.shadowRoot.querySelector("#componentButton");assert(button);button.focus()}}getComponentsList(){return this.componentCheckboxes.map((item=>{let status;if(!item.failed){status=CalibrationStatus.kCalibrationComplete}else if(item.checked){status=CalibrationStatus.kCalibrationWaiting}else{status=CalibrationStatus.kCalibrationSkip}return{component:item.component,status:status,progress:0}}))}skipCalibration(){const skippedComponents=this.componentCheckboxes.map((item=>({component:item.component,status:item.failed?CalibrationStatus.kCalibrationSkip:CalibrationStatus.kCalibrationComplete,progress:0})));return this.shimlessRmaService.startCalibration(skippedComponents)}onNextButtonClick(){return this.shimlessRmaService.startCalibration(this.getComponentsList())}isComponentDisabled(componentDisabled){return componentDisabled||this.allButtonsDisabled}onSkipDialogButtonClicked(){this.closeDialog();executeThenTransitionState(this,(()=>this.skipCalibration()))}closeDialog(){const dialog=this.shadowRoot.querySelector("#failedComponentsDialog");assert(dialog);dialog.close()}tryingToSkipWithFailedComponents(){return this.componentCheckboxes.some((component=>component.failed&&!component.checked))}updateIsFirstClickableComponent(){const firstClickableComponent=this.componentCheckboxes.find((component=>!component.disabled));this.componentCheckboxes.forEach((component=>{component.isFirstClickableComponent=component===firstClickableComponent?true:false}))}updateNextButtonAvailability(){if(this.componentCheckboxes.some((component=>component.checked))){enableNextButton(this)}else{disableNextButton(this)}}getComponentsListForTesting(){return this.getComponentsList()}}customElements.define(ReimagingCalibrationFailedPage.is,ReimagingCalibrationFailedPage);