// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./shimless_rma_shared.css.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getShimlessRmaService}from"./mojo_interface_provider.js";import{getTemplate}from"./shimless_3p_diagnostics.html.js";import{Show3pDiagnosticsAppResult}from"./shimless_rma.mojom-webui.js";import{disableAllButtons,enableAllButtons}from"./shimless_rma_util.js";const Shimless3pDiagnosticsBase=I18nMixin(PolymerElement);export class Shimless3pDiagnostics extends Shimless3pDiagnosticsBase{static get is(){return"shimless-3p-diagnostics"}static get template(){return getTemplate()}static get properties(){return{hasPendingLaunch:{type:Boolean,value:false},providerName:{type:String,value:""},installableAppPath:{type:String,value:""},appInfo:{type:Object,value:null},errorTitle:{type:String,value:""},errorMessage:{type:String,value:""}}}constructor(){super();this.shimlessRmaService=getShimlessRmaService();if(!loadTimeData.getBoolean("3pDiagnosticsEnabled")){return}this.shimlessRmaService.get3pDiagnosticsProvider().then((({provider:provider})=>{this.providerName=provider}))}completeLaunch(){this.hasPendingLaunch=false;enableAllButtons(this)}showError(titleId,messageId){assert(this.providerName);this.errorTitle=this.i18n(titleId,this.providerName);this.errorMessage=this.i18n(messageId);const dialog=this.shadowRoot.querySelector("#shimless3pDiagErrorDialog");assert(dialog);dialog.showModal()}showFindInstallableDialog(appPath){this.installableAppPath=appPath.path;const dialog=this.shadowRoot.querySelector("#shimless3pDiagFindInstallableDialog");assert(dialog);dialog.showModal()}completeLastInstall(isApproved){this.shimlessRmaService.completeLast3pDiagnosticsInstallation(isApproved).then((()=>{isApproved?this.show3pDiagnosticsApp():this.completeLaunch()}))}showPermissionReviewDialogOrCompleteLastInstall(appInfo){if(!appInfo.permissionMessage){this.completeLastInstall(true);return}this.appInfo=appInfo;const dialog=this.shadowRoot.querySelector("#shimless3pDiagReviewPermissionDialog");assert(dialog);dialog.showModal()}show3pDiagnosticsApp(){this.shimlessRmaService.show3pDiagnosticsApp().then((result=>{switch(result.result){case Show3pDiagnosticsAppResult.kOk:this.completeLaunch();return;case Show3pDiagnosticsAppResult.kAppNotInstalled:this.showError("3pNotInstalledDialogTitle","3pCheckWithOemDialogMessage");return;case Show3pDiagnosticsAppResult.kFailedToLoad:this.showError("3pFailedToLoadDialogTitle","3pFailedToLoadDialogMessage");return}}))}onCancelOrSkipInstallButtonClicked(){const dialog=this.shadowRoot.querySelector("#shimless3pDiagFindInstallableDialog");assert(dialog);dialog.close();this.show3pDiagnosticsApp()}onInstallButtonClicked(){const dialog=this.shadowRoot.querySelector("#shimless3pDiagFindInstallableDialog");assert(dialog);dialog.close();this.shimlessRmaService.installLastFound3pDiagnosticsApp().then((result=>{result.appInfo?this.showPermissionReviewDialogOrCompleteLastInstall(result.appInfo):this.showError("3pFailedToInstallDialogTitle","3pCheckWithOemDialogMessage")}))}onCancelOrCancelInstallButtonClicked(){const dialog=this.shadowRoot.querySelector("#shimless3pDiagReviewPermissionDialog");assert(dialog);dialog.close();this.completeLastInstall(false)}onAcceptPermissionButtonClicked(){const dialog=this.shadowRoot.querySelector("#shimless3pDiagReviewPermissionDialog");assert(dialog);dialog.close();this.completeLastInstall(true)}onErrorDialogCancelOrBackButtonClicked(){const dialog=this.shadowRoot.querySelector("#shimless3pDiagErrorDialog");assert(dialog);dialog.close();this.completeLaunch()}launch3pDiagnostics(){if(!loadTimeData.getBoolean("3pDiagnosticsEnabled")||this.hasPendingLaunch){return}if(!this.providerName){return}this.hasPendingLaunch=true;disableAllButtons(this,true);this.shimlessRmaService.getInstallable3pDiagnosticsAppPath().then((result=>{result.appPath?this.showFindInstallableDialog(result.appPath):this.show3pDiagnosticsApp()}))}}customElements.define(Shimless3pDiagnostics.is,Shimless3pDiagnostics);