// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{FilePathSpec as mojoBase_mojom_FilePathSpec}from"//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js";export const StateSpec={$:mojo.internal.Enum()};export var State;(function(State){State[State["MIN_VALUE"]=0]="MIN_VALUE";State[State["MAX_VALUE"]=22]="MAX_VALUE";State[State["kUnknown"]=0]="kUnknown";State[State["kWelcomeScreen"]=1]="kWelcomeScreen";State[State["kConfigureNetwork"]=2]="kConfigureNetwork";State[State["kUpdateOs"]=3]="kUpdateOs";State[State["kSelectComponents"]=4]="kSelectComponents";State[State["kChooseDestination"]=5]="kChooseDestination";State[State["kChooseWipeDevice"]=6]="kChooseWipeDevice";State[State["kChooseWriteProtectDisableMethod"]=7]="kChooseWriteProtectDisableMethod";State[State["kEnterRSUWPDisableCode"]=8]="kEnterRSUWPDisableCode";State[State["kWaitForManualWPDisable"]=9]="kWaitForManualWPDisable";State[State["kWPDisableComplete"]=10]="kWPDisableComplete";State[State["kUpdateRoFirmware"]=11]="kUpdateRoFirmware";State[State["kRestock"]=12]="kRestock";State[State["kUpdateDeviceInformation"]=13]="kUpdateDeviceInformation";State[State["kCheckCalibration"]=14]="kCheckCalibration";State[State["kSetupCalibration"]=15]="kSetupCalibration";State[State["kRunCalibration"]=16]="kRunCalibration";State[State["kProvisionDevice"]=17]="kProvisionDevice";State[State["kWaitForManualWPEnable"]=18]="kWaitForManualWPEnable";State[State["kFinalize"]=19]="kFinalize";State[State["kRepairComplete"]=20]="kRepairComplete";State[State["kHardwareError"]=21]="kHardwareError";State[State["kReboot"]=22]="kReboot"})(State||(State={}));export const RmadErrorCodeSpec={$:mojo.internal.Enum()};export var RmadErrorCode;(function(RmadErrorCode){RmadErrorCode[RmadErrorCode["MIN_VALUE"]=0]="MIN_VALUE";RmadErrorCode[RmadErrorCode["MAX_VALUE"]=45]="MAX_VALUE";RmadErrorCode[RmadErrorCode["kNotSet"]=0]="kNotSet";RmadErrorCode[RmadErrorCode["kOk"]=1]="kOk";RmadErrorCode[RmadErrorCode["kWait"]=2]="kWait";RmadErrorCode[RmadErrorCode["kExpectReboot"]=3]="kExpectReboot";RmadErrorCode[RmadErrorCode["kExpectShutdown"]=4]="kExpectShutdown";RmadErrorCode[RmadErrorCode["kRmaNotRequired"]=5]="kRmaNotRequired";RmadErrorCode[RmadErrorCode["kStateHandlerMissing"]=6]="kStateHandlerMissing";RmadErrorCode[RmadErrorCode["kStateHandlerInitializationFailed"]=7]="kStateHandlerInitializationFailed";RmadErrorCode[RmadErrorCode["kRequestInvalid"]=8]="kRequestInvalid";RmadErrorCode[RmadErrorCode["kRequestArgsMissing"]=9]="kRequestArgsMissing";RmadErrorCode[RmadErrorCode["kRequestArgsViolation"]=10]="kRequestArgsViolation";RmadErrorCode[RmadErrorCode["kTransitionFailed"]=11]="kTransitionFailed";RmadErrorCode[RmadErrorCode["kAbortFailed"]=12]="kAbortFailed";RmadErrorCode[RmadErrorCode["kMissingComponent"]=13]="kMissingComponent";RmadErrorCode[RmadErrorCode["kWriteProtectDisableRsuNoChallenge"]=14]="kWriteProtectDisableRsuNoChallenge";RmadErrorCode[RmadErrorCode["kWriteProtectDisableRsuCodeInvalid"]=15]="kWriteProtectDisableRsuCodeInvalid";RmadErrorCode[RmadErrorCode["kWriteProtectDisableBatteryNotDisconnected"]=16]="kWriteProtectDisableBatteryNotDisconnected";RmadErrorCode[RmadErrorCode["kWriteProtectSignalNotDetected"]=17]="kWriteProtectSignalNotDetected";RmadErrorCode[RmadErrorCode["kReimagingDownloadNoNetwork"]=18]="kReimagingDownloadNoNetwork";RmadErrorCode[RmadErrorCode["kReimagingDownloadNetworkError"]=19]="kReimagingDownloadNetworkError";RmadErrorCode[RmadErrorCode["kReimagingDownloadCancelled"]=20]="kReimagingDownloadCancelled";RmadErrorCode[RmadErrorCode["kReimagingUsbNotFound"]=21]="kReimagingUsbNotFound";RmadErrorCode[RmadErrorCode["kReimagingUsbTooManyFound"]=22]="kReimagingUsbTooManyFound";RmadErrorCode[RmadErrorCode["kReimagingUsbInvalidImage"]=23]="kReimagingUsbInvalidImage";RmadErrorCode[RmadErrorCode["kReimagingImagingFailed"]=24]="kReimagingImagingFailed";RmadErrorCode[RmadErrorCode["kReimagingUnknownFailure"]=25]="kReimagingUnknownFailure";RmadErrorCode[RmadErrorCode["kDeviceInfoInvalid"]=26]="kDeviceInfoInvalid";RmadErrorCode[RmadErrorCode["kCalibrationComponentMissing"]=27]="kCalibrationComponentMissing";RmadErrorCode[RmadErrorCode["kCalibrationStatusMissing"]=28]="kCalibrationStatusMissing";RmadErrorCode[RmadErrorCode["kCalibrationComponentInvalid"]=29]="kCalibrationComponentInvalid";RmadErrorCode[RmadErrorCode["kCalibrationFailed"]=30]="kCalibrationFailed";RmadErrorCode[RmadErrorCode["kProvisioningFailed"]=31]="kProvisioningFailed";RmadErrorCode[RmadErrorCode["kPowerwashFailed"]=32]="kPowerwashFailed";RmadErrorCode[RmadErrorCode["kFinalizationFailed"]=33]="kFinalizationFailed";RmadErrorCode[RmadErrorCode["kLogUploadFtpServerCannotConnect"]=34]="kLogUploadFtpServerCannotConnect";RmadErrorCode[RmadErrorCode["kLogUploadFtpServerConnectionRejected"]=35]="kLogUploadFtpServerConnectionRejected";RmadErrorCode[RmadErrorCode["kLogUploadFtpServerTransferFailed"]=36]="kLogUploadFtpServerTransferFailed";RmadErrorCode[RmadErrorCode["kCannotCancelRma"]=37]="kCannotCancelRma";RmadErrorCode[RmadErrorCode["kCannotGetLog"]=38]="kCannotGetLog";RmadErrorCode[RmadErrorCode["kDaemonInitializationFailed"]=39]="kDaemonInitializationFailed";RmadErrorCode[RmadErrorCode["kUpdateRoFirmwareFailed"]=40]="kUpdateRoFirmwareFailed";RmadErrorCode[RmadErrorCode["kWpEnabled"]=41]="kWpEnabled";RmadErrorCode[RmadErrorCode["kCannotWrite"]=42]="kCannotWrite";RmadErrorCode[RmadErrorCode["kCannotSaveLog"]=43]="kCannotSaveLog";RmadErrorCode[RmadErrorCode["kCannotRecordBrowserAction"]=44]="kCannotRecordBrowserAction";RmadErrorCode[RmadErrorCode["kUsbNotFound"]=45]="kUsbNotFound"})(RmadErrorCode||(RmadErrorCode={}));export const OsUpdateOperationSpec={$:mojo.internal.Enum()};export var OsUpdateOperation;(function(OsUpdateOperation){OsUpdateOperation[OsUpdateOperation["MIN_VALUE"]=0]="MIN_VALUE";OsUpdateOperation[OsUpdateOperation["MAX_VALUE"]=12]="MAX_VALUE";OsUpdateOperation[OsUpdateOperation["kIdle"]=0]="kIdle";OsUpdateOperation[OsUpdateOperation["kCheckingForUpdate"]=1]="kCheckingForUpdate";OsUpdateOperation[OsUpdateOperation["kUpdateAvailable"]=2]="kUpdateAvailable";OsUpdateOperation[OsUpdateOperation["kDownloading"]=3]="kDownloading";OsUpdateOperation[OsUpdateOperation["kVerifying"]=4]="kVerifying";OsUpdateOperation[OsUpdateOperation["kFinalizing"]=5]="kFinalizing";OsUpdateOperation[OsUpdateOperation["kUpdatedNeedReboot"]=6]="kUpdatedNeedReboot";OsUpdateOperation[OsUpdateOperation["kReportingErrorEvent"]=7]="kReportingErrorEvent";OsUpdateOperation[OsUpdateOperation["kAttemptingRollback"]=8]="kAttemptingRollback";OsUpdateOperation[OsUpdateOperation["kDisabled"]=9]="kDisabled";OsUpdateOperation[OsUpdateOperation["kNeedPermissionToUpdate"]=10]="kNeedPermissionToUpdate";OsUpdateOperation[OsUpdateOperation["kCleanupPreviousUpdate"]=11]="kCleanupPreviousUpdate";OsUpdateOperation[OsUpdateOperation["kUpdatedButDeferred"]=12]="kUpdatedButDeferred"})(OsUpdateOperation||(OsUpdateOperation={}));export const UpdateErrorCodeSpec={$:mojo.internal.Enum()};export var UpdateErrorCode;(function(UpdateErrorCode){UpdateErrorCode[UpdateErrorCode["MIN_VALUE"]=0]="MIN_VALUE";UpdateErrorCode[UpdateErrorCode["MAX_VALUE"]=2]="MAX_VALUE";UpdateErrorCode[UpdateErrorCode["kSuccess"]=0]="kSuccess";UpdateErrorCode[UpdateErrorCode["kDownloadError"]=1]="kDownloadError";UpdateErrorCode[UpdateErrorCode["kOtherError"]=2]="kOtherError"})(UpdateErrorCode||(UpdateErrorCode={}));export const ComponentTypeSpec={$:mojo.internal.Enum()};export var ComponentType;(function(ComponentType){ComponentType[ComponentType["MIN_VALUE"]=0]="MIN_VALUE";ComponentType[ComponentType["MAX_VALUE"]=21]="MAX_VALUE";ComponentType[ComponentType["kComponentUnknown"]=0]="kComponentUnknown";ComponentType[ComponentType["kAudioCodec"]=1]="kAudioCodec";ComponentType[ComponentType["kBattery"]=2]="kBattery";ComponentType[ComponentType["kStorage"]=3]="kStorage";ComponentType[ComponentType["kVpdCached"]=4]="kVpdCached";ComponentType[ComponentType["kNetwork"]=5]="kNetwork";ComponentType[ComponentType["kCamera"]=6]="kCamera";ComponentType[ComponentType["kStylus"]=7]="kStylus";ComponentType[ComponentType["kTouchpad"]=8]="kTouchpad";ComponentType[ComponentType["kTouchsreen"]=9]="kTouchsreen";ComponentType[ComponentType["kDram"]=10]="kDram";ComponentType[ComponentType["kDisplayPanel"]=11]="kDisplayPanel";ComponentType[ComponentType["kCellular"]=12]="kCellular";ComponentType[ComponentType["kEthernet"]=13]="kEthernet";ComponentType[ComponentType["kWireless"]=14]="kWireless";ComponentType[ComponentType["kScreen"]=15]="kScreen";ComponentType[ComponentType["kBaseAccelerometer"]=16]="kBaseAccelerometer";ComponentType[ComponentType["kLidAccelerometer"]=17]="kLidAccelerometer";ComponentType[ComponentType["kBaseGyroscope"]=18]="kBaseGyroscope";ComponentType[ComponentType["kLidGyroscope"]=19]="kLidGyroscope";ComponentType[ComponentType["kKeyboard"]=20]="kKeyboard";ComponentType[ComponentType["kPowerButton"]=21]="kPowerButton"})(ComponentType||(ComponentType={}));export const ComponentRepairStatusSpec={$:mojo.internal.Enum()};export var ComponentRepairStatus;(function(ComponentRepairStatus){ComponentRepairStatus[ComponentRepairStatus["MIN_VALUE"]=0]="MIN_VALUE";ComponentRepairStatus[ComponentRepairStatus["MAX_VALUE"]=3]="MAX_VALUE";ComponentRepairStatus[ComponentRepairStatus["kRepairUnknown"]=0]="kRepairUnknown";ComponentRepairStatus[ComponentRepairStatus["kOriginal"]=1]="kOriginal";ComponentRepairStatus[ComponentRepairStatus["kReplaced"]=2]="kReplaced";ComponentRepairStatus[ComponentRepairStatus["kMissing"]=3]="kMissing"})(ComponentRepairStatus||(ComponentRepairStatus={}));export const WriteProtectDisableCompleteActionSpec={$:mojo.internal.Enum()};export var WriteProtectDisableCompleteAction;(function(WriteProtectDisableCompleteAction){WriteProtectDisableCompleteAction[WriteProtectDisableCompleteAction["MIN_VALUE"]=0]="MIN_VALUE";WriteProtectDisableCompleteAction[WriteProtectDisableCompleteAction["MAX_VALUE"]=4]="MAX_VALUE";WriteProtectDisableCompleteAction[WriteProtectDisableCompleteAction["kUnknown"]=0]="kUnknown";WriteProtectDisableCompleteAction[WriteProtectDisableCompleteAction["kSkippedAssembleDevice"]=1]="kSkippedAssembleDevice";WriteProtectDisableCompleteAction[WriteProtectDisableCompleteAction["kCompleteAssembleDevice"]=2]="kCompleteAssembleDevice";WriteProtectDisableCompleteAction[WriteProtectDisableCompleteAction["kCompleteKeepDeviceOpen"]=3]="kCompleteKeepDeviceOpen";WriteProtectDisableCompleteAction[WriteProtectDisableCompleteAction["kCompleteNoOp"]=4]="kCompleteNoOp"})(WriteProtectDisableCompleteAction||(WriteProtectDisableCompleteAction={}));export const UpdateRoFirmwareStatusSpec={$:mojo.internal.Enum()};export var UpdateRoFirmwareStatus;(function(UpdateRoFirmwareStatus){UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["MIN_VALUE"]=0]="MIN_VALUE";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["MAX_VALUE"]=6]="MAX_VALUE";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["kUnknown"]=0]="kUnknown";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["kWaitUsb"]=1]="kWaitUsb";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["kFileNotFound"]=2]="kFileNotFound";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["kDownloading"]=3]="kDownloading";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["kUpdating"]=4]="kUpdating";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["kRebooting"]=5]="kRebooting";UpdateRoFirmwareStatus[UpdateRoFirmwareStatus["kComplete"]=6]="kComplete"})(UpdateRoFirmwareStatus||(UpdateRoFirmwareStatus={}));export const CalibrationSetupInstructionSpec={$:mojo.internal.Enum()};export var CalibrationSetupInstruction;(function(CalibrationSetupInstruction){CalibrationSetupInstruction[CalibrationSetupInstruction["MIN_VALUE"]=0]="MIN_VALUE";CalibrationSetupInstruction[CalibrationSetupInstruction["MAX_VALUE"]=2]="MAX_VALUE";CalibrationSetupInstruction[CalibrationSetupInstruction["kCalibrationInstructionUnknown"]=0]="kCalibrationInstructionUnknown";CalibrationSetupInstruction[CalibrationSetupInstruction["kCalibrationInstructionPlaceBaseOnFlatSurface"]=1]="kCalibrationInstructionPlaceBaseOnFlatSurface";CalibrationSetupInstruction[CalibrationSetupInstruction["kCalibrationInstructionPlaceLidOnFlatSurface"]=2]="kCalibrationInstructionPlaceLidOnFlatSurface"})(CalibrationSetupInstruction||(CalibrationSetupInstruction={}));export const CalibrationOverallStatusSpec={$:mojo.internal.Enum()};export var CalibrationOverallStatus;(function(CalibrationOverallStatus){CalibrationOverallStatus[CalibrationOverallStatus["MIN_VALUE"]=1]="MIN_VALUE";CalibrationOverallStatus[CalibrationOverallStatus["MAX_VALUE"]=4]="MAX_VALUE";CalibrationOverallStatus[CalibrationOverallStatus["kCalibrationOverallComplete"]=1]="kCalibrationOverallComplete";CalibrationOverallStatus[CalibrationOverallStatus["kCalibrationOverallCurrentRoundComplete"]=2]="kCalibrationOverallCurrentRoundComplete";CalibrationOverallStatus[CalibrationOverallStatus["kCalibrationOverallCurrentRoundFailed"]=3]="kCalibrationOverallCurrentRoundFailed";CalibrationOverallStatus[CalibrationOverallStatus["kCalibrationOverallInitializationFailed"]=4]="kCalibrationOverallInitializationFailed"})(CalibrationOverallStatus||(CalibrationOverallStatus={}));export const CalibrationStatusSpec={$:mojo.internal.Enum()};export var CalibrationStatus;(function(CalibrationStatus){CalibrationStatus[CalibrationStatus["MIN_VALUE"]=1]="MIN_VALUE";CalibrationStatus[CalibrationStatus["MAX_VALUE"]=5]="MAX_VALUE";CalibrationStatus[CalibrationStatus["kCalibrationWaiting"]=1]="kCalibrationWaiting";CalibrationStatus[CalibrationStatus["kCalibrationInProgress"]=2]="kCalibrationInProgress";CalibrationStatus[CalibrationStatus["kCalibrationComplete"]=3]="kCalibrationComplete";CalibrationStatus[CalibrationStatus["kCalibrationFailed"]=4]="kCalibrationFailed";CalibrationStatus[CalibrationStatus["kCalibrationSkip"]=5]="kCalibrationSkip"})(CalibrationStatus||(CalibrationStatus={}));export const ProvisioningStatusSpec={$:mojo.internal.Enum()};export var ProvisioningStatus;(function(ProvisioningStatus){ProvisioningStatus[ProvisioningStatus["MIN_VALUE"]=1]="MIN_VALUE";ProvisioningStatus[ProvisioningStatus["MAX_VALUE"]=4]="MAX_VALUE";ProvisioningStatus[ProvisioningStatus["kInProgress"]=1]="kInProgress";ProvisioningStatus[ProvisioningStatus["kComplete"]=2]="kComplete";ProvisioningStatus[ProvisioningStatus["kFailedBlocking"]=3]="kFailedBlocking";ProvisioningStatus[ProvisioningStatus["kFailedNonBlocking"]=4]="kFailedNonBlocking"})(ProvisioningStatus||(ProvisioningStatus={}));export const ProvisioningErrorSpec={$:mojo.internal.Enum()};export var ProvisioningError;(function(ProvisioningError){ProvisioningError[ProvisioningError["MIN_VALUE"]=0]="MIN_VALUE";ProvisioningError[ProvisioningError["MAX_VALUE"]=11]="MAX_VALUE";ProvisioningError[ProvisioningError["kUnknown"]=0]="kUnknown";ProvisioningError[ProvisioningError["kInternal"]=1]="kInternal";ProvisioningError[ProvisioningError["kWpEnabled"]=2]="kWpEnabled";ProvisioningError[ProvisioningError["kCannotRead"]=3]="kCannotRead";ProvisioningError[ProvisioningError["kCannotWrite"]=4]="kCannotWrite";ProvisioningError[ProvisioningError["kGenerateSecret"]=5]="kGenerateSecret";ProvisioningError[ProvisioningError["kMissingBaseAccelerometer"]=6]="kMissingBaseAccelerometer";ProvisioningError[ProvisioningError["kMissingLidAccelerometer"]=7]="kMissingLidAccelerometer";ProvisioningError[ProvisioningError["kMissingBaseGyroscope"]=8]="kMissingBaseGyroscope";ProvisioningError[ProvisioningError["kMissingLidGyroscope"]=9]="kMissingLidGyroscope";ProvisioningError[ProvisioningError["kCr50"]=10]="kCr50";ProvisioningError[ProvisioningError["kGbb"]=11]="kGbb"})(ProvisioningError||(ProvisioningError={}));export const FinalizationStatusSpec={$:mojo.internal.Enum()};export var FinalizationStatus;(function(FinalizationStatus){FinalizationStatus[FinalizationStatus["MIN_VALUE"]=1]="MIN_VALUE";FinalizationStatus[FinalizationStatus["MAX_VALUE"]=4]="MAX_VALUE";FinalizationStatus[FinalizationStatus["kInProgress"]=1]="kInProgress";FinalizationStatus[FinalizationStatus["kComplete"]=2]="kComplete";FinalizationStatus[FinalizationStatus["kFailedBlocking"]=3]="kFailedBlocking";FinalizationStatus[FinalizationStatus["kFailedNonBlocking"]=4]="kFailedNonBlocking"})(FinalizationStatus||(FinalizationStatus={}));export const FinalizationErrorSpec={$:mojo.internal.Enum()};export var FinalizationError;(function(FinalizationError){FinalizationError[FinalizationError["MIN_VALUE"]=0]="MIN_VALUE";FinalizationError[FinalizationError["MAX_VALUE"]=5]="MAX_VALUE";FinalizationError[FinalizationError["kUnknown"]=0]="kUnknown";FinalizationError[FinalizationError["kInternal"]=1]="kInternal";FinalizationError[FinalizationError["kCannotEnableHardwareWp"]=2]="kCannotEnableHardwareWp";FinalizationError[FinalizationError["kCannotEnableSoftwareWp"]=3]="kCannotEnableSoftwareWp";FinalizationError[FinalizationError["kCr50"]=4]="kCr50";FinalizationError[FinalizationError["kGbb"]=5]="kGbb"})(FinalizationError||(FinalizationError={}));export const ShutdownMethodSpec={$:mojo.internal.Enum()};export var ShutdownMethod;(function(ShutdownMethod){ShutdownMethod[ShutdownMethod["MIN_VALUE"]=0]="MIN_VALUE";ShutdownMethod[ShutdownMethod["MAX_VALUE"]=3]="MAX_VALUE";ShutdownMethod[ShutdownMethod["kUnknown"]=0]="kUnknown";ShutdownMethod[ShutdownMethod["kReboot"]=1]="kReboot";ShutdownMethod[ShutdownMethod["kShutdown"]=2]="kShutdown";ShutdownMethod[ShutdownMethod["kBatteryCutoff"]=3]="kBatteryCutoff"})(ShutdownMethod||(ShutdownMethod={}));export const FeatureLevelSpec={$:mojo.internal.Enum()};export var FeatureLevel;(function(FeatureLevel){FeatureLevel[FeatureLevel["MIN_VALUE"]=0]="MIN_VALUE";FeatureLevel[FeatureLevel["MAX_VALUE"]=3]="MAX_VALUE";FeatureLevel[FeatureLevel["kRmadFeatureLevelUnsupported"]=0]="kRmadFeatureLevelUnsupported";FeatureLevel[FeatureLevel["kRmadFeatureLevelUnknown"]=1]="kRmadFeatureLevelUnknown";FeatureLevel[FeatureLevel["kRmadFeatureLevel0"]=2]="kRmadFeatureLevel0";FeatureLevel[FeatureLevel["kRmadFeatureLevel1"]=3]="kRmadFeatureLevel1"})(FeatureLevel||(FeatureLevel={}));export const Show3pDiagnosticsAppResultSpec={$:mojo.internal.Enum()};export var Show3pDiagnosticsAppResult;(function(Show3pDiagnosticsAppResult){Show3pDiagnosticsAppResult[Show3pDiagnosticsAppResult["MIN_VALUE"]=0]="MIN_VALUE";Show3pDiagnosticsAppResult[Show3pDiagnosticsAppResult["MAX_VALUE"]=2]="MAX_VALUE";Show3pDiagnosticsAppResult[Show3pDiagnosticsAppResult["kOk"]=0]="kOk";Show3pDiagnosticsAppResult[Show3pDiagnosticsAppResult["kAppNotInstalled"]=1]="kAppNotInstalled";Show3pDiagnosticsAppResult[Show3pDiagnosticsAppResult["kFailedToLoad"]=2]="kFailedToLoad"})(Show3pDiagnosticsAppResult||(Show3pDiagnosticsAppResult={}));export const StatePropertyErrorSpec={$:mojo.internal.Enum()};export var StatePropertyError;(function(StatePropertyError){StatePropertyError[StatePropertyError["MIN_VALUE"]=0]="MIN_VALUE";StatePropertyError[StatePropertyError["MAX_VALUE"]=0]="MAX_VALUE";StatePropertyError[StatePropertyError["kUnsupported"]=0]="kUnsupported"})(StatePropertyError||(StatePropertyError={}));export class ErrorObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.ErrorObserver",scope)}}export class ErrorObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ErrorObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onError(error){this.proxy.sendMessage(0,ErrorObserver_OnError_ParamsSpec.$,null,[error],false)}}export class ErrorObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ErrorObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,ErrorObserver_OnError_ParamsSpec.$,null,impl.onError.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class ErrorObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.ErrorObserver"}static getRemote(){let remote=new ErrorObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class ErrorObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ErrorObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onError=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,ErrorObserver_OnError_ParamsSpec.$,null,this.onError.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class OsUpdateObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.OsUpdateObserver",scope)}}export class OsUpdateObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(OsUpdateObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onOsUpdateProgressUpdated(operation,progress,updateErrorCode){this.proxy.sendMessage(0,OsUpdateObserver_OnOsUpdateProgressUpdated_ParamsSpec.$,null,[operation,progress,updateErrorCode],false)}}export class OsUpdateObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OsUpdateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,OsUpdateObserver_OnOsUpdateProgressUpdated_ParamsSpec.$,null,impl.onOsUpdateProgressUpdated.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class OsUpdateObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.OsUpdateObserver"}static getRemote(){let remote=new OsUpdateObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class OsUpdateObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OsUpdateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onOsUpdateProgressUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,OsUpdateObserver_OnOsUpdateProgressUpdated_ParamsSpec.$,null,this.onOsUpdateProgressUpdated.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class CalibrationObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.CalibrationObserver",scope)}}export class CalibrationObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CalibrationObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onCalibrationUpdated(componentStatus){this.proxy.sendMessage(0,CalibrationObserver_OnCalibrationUpdated_ParamsSpec.$,null,[componentStatus],false)}onCalibrationStepComplete(status){this.proxy.sendMessage(1,CalibrationObserver_OnCalibrationStepComplete_ParamsSpec.$,null,[status],false)}}export class CalibrationObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CalibrationObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,CalibrationObserver_OnCalibrationUpdated_ParamsSpec.$,null,impl.onCalibrationUpdated.bind(impl),false);this.helper_internal_.registerHandler(1,CalibrationObserver_OnCalibrationStepComplete_ParamsSpec.$,null,impl.onCalibrationStepComplete.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class CalibrationObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.CalibrationObserver"}static getRemote(){let remote=new CalibrationObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class CalibrationObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CalibrationObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onCalibrationUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,CalibrationObserver_OnCalibrationUpdated_ParamsSpec.$,null,this.onCalibrationUpdated.createReceiverHandler(false),false);this.onCalibrationStepComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,CalibrationObserver_OnCalibrationStepComplete_ParamsSpec.$,null,this.onCalibrationStepComplete.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class ProvisioningObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.ProvisioningObserver",scope)}}export class ProvisioningObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ProvisioningObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onProvisioningUpdated(status,progress,error){this.proxy.sendMessage(0,ProvisioningObserver_OnProvisioningUpdated_ParamsSpec.$,null,[status,progress,error],false)}}export class ProvisioningObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ProvisioningObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,ProvisioningObserver_OnProvisioningUpdated_ParamsSpec.$,null,impl.onProvisioningUpdated.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class ProvisioningObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.ProvisioningObserver"}static getRemote(){let remote=new ProvisioningObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class ProvisioningObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ProvisioningObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onProvisioningUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,ProvisioningObserver_OnProvisioningUpdated_ParamsSpec.$,null,this.onProvisioningUpdated.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class HardwareWriteProtectionStateObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.HardwareWriteProtectionStateObserver",scope)}}export class HardwareWriteProtectionStateObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HardwareWriteProtectionStateObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onHardwareWriteProtectionStateChanged(enabled){this.proxy.sendMessage(0,HardwareWriteProtectionStateObserver_OnHardwareWriteProtectionStateChanged_ParamsSpec.$,null,[enabled],false)}}export class HardwareWriteProtectionStateObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HardwareWriteProtectionStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,HardwareWriteProtectionStateObserver_OnHardwareWriteProtectionStateChanged_ParamsSpec.$,null,impl.onHardwareWriteProtectionStateChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class HardwareWriteProtectionStateObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.HardwareWriteProtectionStateObserver"}static getRemote(){let remote=new HardwareWriteProtectionStateObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class HardwareWriteProtectionStateObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HardwareWriteProtectionStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onHardwareWriteProtectionStateChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,HardwareWriteProtectionStateObserver_OnHardwareWriteProtectionStateChanged_ParamsSpec.$,null,this.onHardwareWriteProtectionStateChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PowerCableStateObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.PowerCableStateObserver",scope)}}export class PowerCableStateObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PowerCableStateObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onPowerCableStateChanged(pluggedIn){this.proxy.sendMessage(0,PowerCableStateObserver_OnPowerCableStateChanged_ParamsSpec.$,null,[pluggedIn],false)}}export class PowerCableStateObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PowerCableStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PowerCableStateObserver_OnPowerCableStateChanged_ParamsSpec.$,null,impl.onPowerCableStateChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PowerCableStateObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.PowerCableStateObserver"}static getRemote(){let remote=new PowerCableStateObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PowerCableStateObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PowerCableStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onPowerCableStateChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PowerCableStateObserver_OnPowerCableStateChanged_ParamsSpec.$,null,this.onPowerCableStateChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class ExternalDiskStateObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.ExternalDiskStateObserver",scope)}}export class ExternalDiskStateObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ExternalDiskStateObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onExternalDiskStateChanged(detected){this.proxy.sendMessage(0,ExternalDiskStateObserver_OnExternalDiskStateChanged_ParamsSpec.$,null,[detected],false)}}export class ExternalDiskStateObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ExternalDiskStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,ExternalDiskStateObserver_OnExternalDiskStateChanged_ParamsSpec.$,null,impl.onExternalDiskStateChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class ExternalDiskStateObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.ExternalDiskStateObserver"}static getRemote(){let remote=new ExternalDiskStateObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class ExternalDiskStateObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ExternalDiskStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onExternalDiskStateChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,ExternalDiskStateObserver_OnExternalDiskStateChanged_ParamsSpec.$,null,this.onExternalDiskStateChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class HardwareVerificationStatusObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.HardwareVerificationStatusObserver",scope)}}export class HardwareVerificationStatusObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HardwareVerificationStatusObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onHardwareVerificationResult(result){this.proxy.sendMessage(0,HardwareVerificationStatusObserver_OnHardwareVerificationResult_ParamsSpec.$,null,[result],false)}}export class HardwareVerificationStatusObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HardwareVerificationStatusObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,HardwareVerificationStatusObserver_OnHardwareVerificationResult_ParamsSpec.$,null,impl.onHardwareVerificationResult.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class HardwareVerificationStatusObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.HardwareVerificationStatusObserver"}static getRemote(){let remote=new HardwareVerificationStatusObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class HardwareVerificationStatusObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HardwareVerificationStatusObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onHardwareVerificationResult=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,HardwareVerificationStatusObserver_OnHardwareVerificationResult_ParamsSpec.$,null,this.onHardwareVerificationResult.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class FinalizationObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.FinalizationObserver",scope)}}export class FinalizationObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(FinalizationObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onFinalizationUpdated(status,progress,error){this.proxy.sendMessage(0,FinalizationObserver_OnFinalizationUpdated_ParamsSpec.$,null,[status,progress,error],false)}}export class FinalizationObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FinalizationObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,FinalizationObserver_OnFinalizationUpdated_ParamsSpec.$,null,impl.onFinalizationUpdated.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class FinalizationObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.FinalizationObserver"}static getRemote(){let remote=new FinalizationObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class FinalizationObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FinalizationObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onFinalizationUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,FinalizationObserver_OnFinalizationUpdated_ParamsSpec.$,null,this.onFinalizationUpdated.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class UpdateRoFirmwareObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.UpdateRoFirmwareObserver",scope)}}export class UpdateRoFirmwareObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(UpdateRoFirmwareObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onUpdateRoFirmwareStatusChanged(status){this.proxy.sendMessage(0,UpdateRoFirmwareObserver_OnUpdateRoFirmwareStatusChanged_ParamsSpec.$,null,[status],false)}}export class UpdateRoFirmwareObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateRoFirmwareObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,UpdateRoFirmwareObserver_OnUpdateRoFirmwareStatusChanged_ParamsSpec.$,null,impl.onUpdateRoFirmwareStatusChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class UpdateRoFirmwareObserver{static get $interfaceName(){return"ash.shimless_rma.mojom.UpdateRoFirmwareObserver"}static getRemote(){let remote=new UpdateRoFirmwareObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class UpdateRoFirmwareObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateRoFirmwareObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onUpdateRoFirmwareStatusChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,UpdateRoFirmwareObserver_OnUpdateRoFirmwareStatusChanged_ParamsSpec.$,null,this.onUpdateRoFirmwareStatusChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class ShimlessRmaServicePendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shimless_rma.mojom.ShimlessRmaService",scope)}}export class ShimlessRmaServiceRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ShimlessRmaServicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getCurrentState(){return this.proxy.sendMessage(0,ShimlessRmaService_GetCurrentState_ParamsSpec.$,ShimlessRmaService_GetCurrentState_ResponseParamsSpec.$,[],false)}getStateProperties(){return this.proxy.sendMessage(1,ShimlessRmaService_GetStateProperties_ParamsSpec.$,ShimlessRmaService_GetStateProperties_ResponseParamsSpec.$,[],false)}transitionPreviousState(){return this.proxy.sendMessage(2,ShimlessRmaService_TransitionPreviousState_ParamsSpec.$,ShimlessRmaService_TransitionPreviousState_ResponseParamsSpec.$,[],false)}abortRma(){return this.proxy.sendMessage(3,ShimlessRmaService_AbortRma_ParamsSpec.$,ShimlessRmaService_AbortRma_ResponseParamsSpec.$,[],false)}beginFinalization(){return this.proxy.sendMessage(4,ShimlessRmaService_BeginFinalization_ParamsSpec.$,ShimlessRmaService_BeginFinalization_ResponseParamsSpec.$,[],false)}trackConfiguredNetworks(){this.proxy.sendMessage(5,ShimlessRmaService_TrackConfiguredNetworks_ParamsSpec.$,null,[],false)}networkSelectionComplete(){return this.proxy.sendMessage(6,ShimlessRmaService_NetworkSelectionComplete_ParamsSpec.$,ShimlessRmaService_NetworkSelectionComplete_ResponseParamsSpec.$,[],false)}getCurrentOsVersion(){return this.proxy.sendMessage(7,ShimlessRmaService_GetCurrentOsVersion_ParamsSpec.$,ShimlessRmaService_GetCurrentOsVersion_ResponseParamsSpec.$,[],false)}checkForOsUpdates(){return this.proxy.sendMessage(8,ShimlessRmaService_CheckForOsUpdates_ParamsSpec.$,ShimlessRmaService_CheckForOsUpdates_ResponseParamsSpec.$,[],false)}updateOs(){return this.proxy.sendMessage(9,ShimlessRmaService_UpdateOs_ParamsSpec.$,ShimlessRmaService_UpdateOs_ResponseParamsSpec.$,[],false)}updateOsSkipped(){return this.proxy.sendMessage(10,ShimlessRmaService_UpdateOsSkipped_ParamsSpec.$,ShimlessRmaService_UpdateOsSkipped_ResponseParamsSpec.$,[],false)}setSameOwner(){return this.proxy.sendMessage(11,ShimlessRmaService_SetSameOwner_ParamsSpec.$,ShimlessRmaService_SetSameOwner_ResponseParamsSpec.$,[],false)}setDifferentOwner(){return this.proxy.sendMessage(12,ShimlessRmaService_SetDifferentOwner_ParamsSpec.$,ShimlessRmaService_SetDifferentOwner_ResponseParamsSpec.$,[],false)}setWipeDevice(shouldWipeDevice){return this.proxy.sendMessage(13,ShimlessRmaService_SetWipeDevice_ParamsSpec.$,ShimlessRmaService_SetWipeDevice_ResponseParamsSpec.$,[shouldWipeDevice],false)}setManuallyDisableWriteProtect(){return this.proxy.sendMessage(14,ShimlessRmaService_SetManuallyDisableWriteProtect_ParamsSpec.$,ShimlessRmaService_SetManuallyDisableWriteProtect_ResponseParamsSpec.$,[],false)}setRsuDisableWriteProtect(){return this.proxy.sendMessage(15,ShimlessRmaService_SetRsuDisableWriteProtect_ParamsSpec.$,ShimlessRmaService_SetRsuDisableWriteProtect_ResponseParamsSpec.$,[],false)}getRsuDisableWriteProtectChallenge(){return this.proxy.sendMessage(16,ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ResponseParamsSpec.$,[],false)}getRsuDisableWriteProtectHwid(){return this.proxy.sendMessage(17,ShimlessRmaService_GetRsuDisableWriteProtectHwid_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectHwid_ResponseParamsSpec.$,[],false)}getRsuDisableWriteProtectChallengeQrCode(){return this.proxy.sendMessage(18,ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ResponseParamsSpec.$,[],false)}setRsuDisableWriteProtectCode(code){return this.proxy.sendMessage(19,ShimlessRmaService_SetRsuDisableWriteProtectCode_ParamsSpec.$,ShimlessRmaService_SetRsuDisableWriteProtectCode_ResponseParamsSpec.$,[code],false)}writeProtectManuallyDisabled(){return this.proxy.sendMessage(20,ShimlessRmaService_WriteProtectManuallyDisabled_ParamsSpec.$,ShimlessRmaService_WriteProtectManuallyDisabled_ResponseParamsSpec.$,[],false)}getWriteProtectDisableCompleteAction(){return this.proxy.sendMessage(21,ShimlessRmaService_GetWriteProtectDisableCompleteAction_ParamsSpec.$,ShimlessRmaService_GetWriteProtectDisableCompleteAction_ResponseParamsSpec.$,[],false)}confirmManualWpDisableComplete(){return this.proxy.sendMessage(22,ShimlessRmaService_ConfirmManualWpDisableComplete_ParamsSpec.$,ShimlessRmaService_ConfirmManualWpDisableComplete_ResponseParamsSpec.$,[],false)}getComponentList(){return this.proxy.sendMessage(23,ShimlessRmaService_GetComponentList_ParamsSpec.$,ShimlessRmaService_GetComponentList_ResponseParamsSpec.$,[],false)}setComponentList(components){return this.proxy.sendMessage(24,ShimlessRmaService_SetComponentList_ParamsSpec.$,ShimlessRmaService_SetComponentList_ResponseParamsSpec.$,[components],false)}reworkMainboard(){return this.proxy.sendMessage(25,ShimlessRmaService_ReworkMainboard_ParamsSpec.$,ShimlessRmaService_ReworkMainboard_ResponseParamsSpec.$,[],false)}roFirmwareUpdateComplete(){return this.proxy.sendMessage(26,ShimlessRmaService_RoFirmwareUpdateComplete_ParamsSpec.$,ShimlessRmaService_RoFirmwareUpdateComplete_ResponseParamsSpec.$,[],false)}shutdownForRestock(){return this.proxy.sendMessage(27,ShimlessRmaService_ShutdownForRestock_ParamsSpec.$,ShimlessRmaService_ShutdownForRestock_ResponseParamsSpec.$,[],false)}continueFinalizationAfterRestock(){return this.proxy.sendMessage(28,ShimlessRmaService_ContinueFinalizationAfterRestock_ParamsSpec.$,ShimlessRmaService_ContinueFinalizationAfterRestock_ResponseParamsSpec.$,[],false)}getRegionList(){return this.proxy.sendMessage(29,ShimlessRmaService_GetRegionList_ParamsSpec.$,ShimlessRmaService_GetRegionList_ResponseParamsSpec.$,[],false)}getSkuList(){return this.proxy.sendMessage(30,ShimlessRmaService_GetSkuList_ParamsSpec.$,ShimlessRmaService_GetSkuList_ResponseParamsSpec.$,[],false)}getCustomLabelList(){return this.proxy.sendMessage(31,ShimlessRmaService_GetCustomLabelList_ParamsSpec.$,ShimlessRmaService_GetCustomLabelList_ResponseParamsSpec.$,[],false)}getSkuDescriptionList(){return this.proxy.sendMessage(32,ShimlessRmaService_GetSkuDescriptionList_ParamsSpec.$,ShimlessRmaService_GetSkuDescriptionList_ResponseParamsSpec.$,[],false)}getOriginalSerialNumber(){return this.proxy.sendMessage(33,ShimlessRmaService_GetOriginalSerialNumber_ParamsSpec.$,ShimlessRmaService_GetOriginalSerialNumber_ResponseParamsSpec.$,[],false)}getOriginalRegion(){return this.proxy.sendMessage(34,ShimlessRmaService_GetOriginalRegion_ParamsSpec.$,ShimlessRmaService_GetOriginalRegion_ResponseParamsSpec.$,[],false)}getOriginalSku(){return this.proxy.sendMessage(35,ShimlessRmaService_GetOriginalSku_ParamsSpec.$,ShimlessRmaService_GetOriginalSku_ResponseParamsSpec.$,[],false)}getOriginalCustomLabel(){return this.proxy.sendMessage(36,ShimlessRmaService_GetOriginalCustomLabel_ParamsSpec.$,ShimlessRmaService_GetOriginalCustomLabel_ResponseParamsSpec.$,[],false)}getOriginalDramPartNumber(){return this.proxy.sendMessage(37,ShimlessRmaService_GetOriginalDramPartNumber_ParamsSpec.$,ShimlessRmaService_GetOriginalDramPartNumber_ResponseParamsSpec.$,[],false)}getOriginalFeatureLevel(){return this.proxy.sendMessage(38,ShimlessRmaService_GetOriginalFeatureLevel_ParamsSpec.$,ShimlessRmaService_GetOriginalFeatureLevel_ResponseParamsSpec.$,[],false)}setDeviceInformation(serialNumber,regionIndex,skuIndex,customLabelIndex,dramPartNumber,isChassisBranded,hwComplianceVersion){return this.proxy.sendMessage(39,ShimlessRmaService_SetDeviceInformation_ParamsSpec.$,ShimlessRmaService_SetDeviceInformation_ResponseParamsSpec.$,[serialNumber,regionIndex,skuIndex,customLabelIndex,dramPartNumber,isChassisBranded,hwComplianceVersion],false)}getCalibrationComponentList(){return this.proxy.sendMessage(40,ShimlessRmaService_GetCalibrationComponentList_ParamsSpec.$,ShimlessRmaService_GetCalibrationComponentList_ResponseParamsSpec.$,[],false)}getCalibrationSetupInstructions(){return this.proxy.sendMessage(41,ShimlessRmaService_GetCalibrationSetupInstructions_ParamsSpec.$,ShimlessRmaService_GetCalibrationSetupInstructions_ResponseParamsSpec.$,[],false)}startCalibration(components){return this.proxy.sendMessage(42,ShimlessRmaService_StartCalibration_ParamsSpec.$,ShimlessRmaService_StartCalibration_ResponseParamsSpec.$,[components],false)}runCalibrationStep(){return this.proxy.sendMessage(43,ShimlessRmaService_RunCalibrationStep_ParamsSpec.$,ShimlessRmaService_RunCalibrationStep_ResponseParamsSpec.$,[],false)}continueCalibration(){return this.proxy.sendMessage(44,ShimlessRmaService_ContinueCalibration_ParamsSpec.$,ShimlessRmaService_ContinueCalibration_ResponseParamsSpec.$,[],false)}calibrationComplete(){return this.proxy.sendMessage(45,ShimlessRmaService_CalibrationComplete_ParamsSpec.$,ShimlessRmaService_CalibrationComplete_ResponseParamsSpec.$,[],false)}retryProvisioning(){return this.proxy.sendMessage(46,ShimlessRmaService_RetryProvisioning_ParamsSpec.$,ShimlessRmaService_RetryProvisioning_ResponseParamsSpec.$,[],false)}provisioningComplete(){return this.proxy.sendMessage(47,ShimlessRmaService_ProvisioningComplete_ParamsSpec.$,ShimlessRmaService_ProvisioningComplete_ResponseParamsSpec.$,[],false)}retryFinalization(){return this.proxy.sendMessage(48,ShimlessRmaService_RetryFinalization_ParamsSpec.$,ShimlessRmaService_RetryFinalization_ResponseParamsSpec.$,[],false)}finalizationComplete(){return this.proxy.sendMessage(49,ShimlessRmaService_FinalizationComplete_ParamsSpec.$,ShimlessRmaService_FinalizationComplete_ResponseParamsSpec.$,[],false)}writeProtectManuallyEnabled(){return this.proxy.sendMessage(50,ShimlessRmaService_WriteProtectManuallyEnabled_ParamsSpec.$,ShimlessRmaService_WriteProtectManuallyEnabled_ResponseParamsSpec.$,[],false)}getLog(){return this.proxy.sendMessage(51,ShimlessRmaService_GetLog_ParamsSpec.$,ShimlessRmaService_GetLog_ResponseParamsSpec.$,[],false)}saveLog(){return this.proxy.sendMessage(52,ShimlessRmaService_SaveLog_ParamsSpec.$,ShimlessRmaService_SaveLog_ResponseParamsSpec.$,[],false)}getPowerwashRequired(){return this.proxy.sendMessage(53,ShimlessRmaService_GetPowerwashRequired_ParamsSpec.$,ShimlessRmaService_GetPowerwashRequired_ResponseParamsSpec.$,[],false)}launchDiagnostics(){this.proxy.sendMessage(54,ShimlessRmaService_LaunchDiagnostics_ParamsSpec.$,null,[],false)}endRma(shutdownMethod){return this.proxy.sendMessage(55,ShimlessRmaService_EndRma_ParamsSpec.$,ShimlessRmaService_EndRma_ResponseParamsSpec.$,[shutdownMethod],false)}shutDownAfterHardwareError(){this.proxy.sendMessage(56,ShimlessRmaService_ShutDownAfterHardwareError_ParamsSpec.$,null,[],false)}criticalErrorExitToLogin(){return this.proxy.sendMessage(57,ShimlessRmaService_CriticalErrorExitToLogin_ParamsSpec.$,ShimlessRmaService_CriticalErrorExitToLogin_ResponseParamsSpec.$,[],false)}criticalErrorReboot(){return this.proxy.sendMessage(58,ShimlessRmaService_CriticalErrorReboot_ParamsSpec.$,ShimlessRmaService_CriticalErrorReboot_ResponseParamsSpec.$,[],false)}get3pDiagnosticsProvider(){return this.proxy.sendMessage(59,ShimlessRmaService_Get3pDiagnosticsProvider_ParamsSpec.$,ShimlessRmaService_Get3pDiagnosticsProvider_ResponseParamsSpec.$,[],false)}getInstallable3pDiagnosticsAppPath(){return this.proxy.sendMessage(60,ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ParamsSpec.$,ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ResponseParamsSpec.$,[],false)}installLastFound3pDiagnosticsApp(){return this.proxy.sendMessage(61,ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ParamsSpec.$,ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ResponseParamsSpec.$,[],false)}completeLast3pDiagnosticsInstallation(isApproved){return this.proxy.sendMessage(62,ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ParamsSpec.$,ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ResponseParamsSpec.$,[isApproved],false)}show3pDiagnosticsApp(){return this.proxy.sendMessage(63,ShimlessRmaService_Show3pDiagnosticsApp_ParamsSpec.$,ShimlessRmaService_Show3pDiagnosticsApp_ResponseParamsSpec.$,[],false)}observeError(observer){this.proxy.sendMessage(64,ShimlessRmaService_ObserveError_ParamsSpec.$,null,[observer],false)}observeOsUpdateProgress(observer){this.proxy.sendMessage(65,ShimlessRmaService_ObserveOsUpdateProgress_ParamsSpec.$,null,[observer],false)}observeCalibrationProgress(observer){this.proxy.sendMessage(66,ShimlessRmaService_ObserveCalibrationProgress_ParamsSpec.$,null,[observer],false)}observeProvisioningProgress(observer){this.proxy.sendMessage(67,ShimlessRmaService_ObserveProvisioningProgress_ParamsSpec.$,null,[observer],false)}observeHardwareWriteProtectionState(observer){this.proxy.sendMessage(68,ShimlessRmaService_ObserveHardwareWriteProtectionState_ParamsSpec.$,null,[observer],false)}observePowerCableState(observer){this.proxy.sendMessage(69,ShimlessRmaService_ObservePowerCableState_ParamsSpec.$,null,[observer],false)}observeExternalDiskState(observer){this.proxy.sendMessage(70,ShimlessRmaService_ObserveExternalDiskState_ParamsSpec.$,null,[observer],false)}observeHardwareVerificationStatus(observer){this.proxy.sendMessage(71,ShimlessRmaService_ObserveHardwareVerificationStatus_ParamsSpec.$,null,[observer],false)}observeFinalizationStatus(observer){this.proxy.sendMessage(72,ShimlessRmaService_ObserveFinalizationStatus_ParamsSpec.$,null,[observer],false)}observeRoFirmwareUpdateProgress(observer){this.proxy.sendMessage(73,ShimlessRmaService_ObserveRoFirmwareUpdateProgress_ParamsSpec.$,null,[observer],false)}}export class ShimlessRmaServiceReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShimlessRmaServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,ShimlessRmaService_GetCurrentState_ParamsSpec.$,ShimlessRmaService_GetCurrentState_ResponseParamsSpec.$,impl.getCurrentState.bind(impl),false);this.helper_internal_.registerHandler(1,ShimlessRmaService_GetStateProperties_ParamsSpec.$,ShimlessRmaService_GetStateProperties_ResponseParamsSpec.$,impl.getStateProperties.bind(impl),false);this.helper_internal_.registerHandler(2,ShimlessRmaService_TransitionPreviousState_ParamsSpec.$,ShimlessRmaService_TransitionPreviousState_ResponseParamsSpec.$,impl.transitionPreviousState.bind(impl),false);this.helper_internal_.registerHandler(3,ShimlessRmaService_AbortRma_ParamsSpec.$,ShimlessRmaService_AbortRma_ResponseParamsSpec.$,impl.abortRma.bind(impl),false);this.helper_internal_.registerHandler(4,ShimlessRmaService_BeginFinalization_ParamsSpec.$,ShimlessRmaService_BeginFinalization_ResponseParamsSpec.$,impl.beginFinalization.bind(impl),false);this.helper_internal_.registerHandler(5,ShimlessRmaService_TrackConfiguredNetworks_ParamsSpec.$,null,impl.trackConfiguredNetworks.bind(impl),false);this.helper_internal_.registerHandler(6,ShimlessRmaService_NetworkSelectionComplete_ParamsSpec.$,ShimlessRmaService_NetworkSelectionComplete_ResponseParamsSpec.$,impl.networkSelectionComplete.bind(impl),false);this.helper_internal_.registerHandler(7,ShimlessRmaService_GetCurrentOsVersion_ParamsSpec.$,ShimlessRmaService_GetCurrentOsVersion_ResponseParamsSpec.$,impl.getCurrentOsVersion.bind(impl),false);this.helper_internal_.registerHandler(8,ShimlessRmaService_CheckForOsUpdates_ParamsSpec.$,ShimlessRmaService_CheckForOsUpdates_ResponseParamsSpec.$,impl.checkForOsUpdates.bind(impl),false);this.helper_internal_.registerHandler(9,ShimlessRmaService_UpdateOs_ParamsSpec.$,ShimlessRmaService_UpdateOs_ResponseParamsSpec.$,impl.updateOs.bind(impl),false);this.helper_internal_.registerHandler(10,ShimlessRmaService_UpdateOsSkipped_ParamsSpec.$,ShimlessRmaService_UpdateOsSkipped_ResponseParamsSpec.$,impl.updateOsSkipped.bind(impl),false);this.helper_internal_.registerHandler(11,ShimlessRmaService_SetSameOwner_ParamsSpec.$,ShimlessRmaService_SetSameOwner_ResponseParamsSpec.$,impl.setSameOwner.bind(impl),false);this.helper_internal_.registerHandler(12,ShimlessRmaService_SetDifferentOwner_ParamsSpec.$,ShimlessRmaService_SetDifferentOwner_ResponseParamsSpec.$,impl.setDifferentOwner.bind(impl),false);this.helper_internal_.registerHandler(13,ShimlessRmaService_SetWipeDevice_ParamsSpec.$,ShimlessRmaService_SetWipeDevice_ResponseParamsSpec.$,impl.setWipeDevice.bind(impl),false);this.helper_internal_.registerHandler(14,ShimlessRmaService_SetManuallyDisableWriteProtect_ParamsSpec.$,ShimlessRmaService_SetManuallyDisableWriteProtect_ResponseParamsSpec.$,impl.setManuallyDisableWriteProtect.bind(impl),false);this.helper_internal_.registerHandler(15,ShimlessRmaService_SetRsuDisableWriteProtect_ParamsSpec.$,ShimlessRmaService_SetRsuDisableWriteProtect_ResponseParamsSpec.$,impl.setRsuDisableWriteProtect.bind(impl),false);this.helper_internal_.registerHandler(16,ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ResponseParamsSpec.$,impl.getRsuDisableWriteProtectChallenge.bind(impl),false);this.helper_internal_.registerHandler(17,ShimlessRmaService_GetRsuDisableWriteProtectHwid_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectHwid_ResponseParamsSpec.$,impl.getRsuDisableWriteProtectHwid.bind(impl),false);this.helper_internal_.registerHandler(18,ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ResponseParamsSpec.$,impl.getRsuDisableWriteProtectChallengeQrCode.bind(impl),false);this.helper_internal_.registerHandler(19,ShimlessRmaService_SetRsuDisableWriteProtectCode_ParamsSpec.$,ShimlessRmaService_SetRsuDisableWriteProtectCode_ResponseParamsSpec.$,impl.setRsuDisableWriteProtectCode.bind(impl),false);this.helper_internal_.registerHandler(20,ShimlessRmaService_WriteProtectManuallyDisabled_ParamsSpec.$,ShimlessRmaService_WriteProtectManuallyDisabled_ResponseParamsSpec.$,impl.writeProtectManuallyDisabled.bind(impl),false);this.helper_internal_.registerHandler(21,ShimlessRmaService_GetWriteProtectDisableCompleteAction_ParamsSpec.$,ShimlessRmaService_GetWriteProtectDisableCompleteAction_ResponseParamsSpec.$,impl.getWriteProtectDisableCompleteAction.bind(impl),false);this.helper_internal_.registerHandler(22,ShimlessRmaService_ConfirmManualWpDisableComplete_ParamsSpec.$,ShimlessRmaService_ConfirmManualWpDisableComplete_ResponseParamsSpec.$,impl.confirmManualWpDisableComplete.bind(impl),false);this.helper_internal_.registerHandler(23,ShimlessRmaService_GetComponentList_ParamsSpec.$,ShimlessRmaService_GetComponentList_ResponseParamsSpec.$,impl.getComponentList.bind(impl),false);this.helper_internal_.registerHandler(24,ShimlessRmaService_SetComponentList_ParamsSpec.$,ShimlessRmaService_SetComponentList_ResponseParamsSpec.$,impl.setComponentList.bind(impl),false);this.helper_internal_.registerHandler(25,ShimlessRmaService_ReworkMainboard_ParamsSpec.$,ShimlessRmaService_ReworkMainboard_ResponseParamsSpec.$,impl.reworkMainboard.bind(impl),false);this.helper_internal_.registerHandler(26,ShimlessRmaService_RoFirmwareUpdateComplete_ParamsSpec.$,ShimlessRmaService_RoFirmwareUpdateComplete_ResponseParamsSpec.$,impl.roFirmwareUpdateComplete.bind(impl),false);this.helper_internal_.registerHandler(27,ShimlessRmaService_ShutdownForRestock_ParamsSpec.$,ShimlessRmaService_ShutdownForRestock_ResponseParamsSpec.$,impl.shutdownForRestock.bind(impl),false);this.helper_internal_.registerHandler(28,ShimlessRmaService_ContinueFinalizationAfterRestock_ParamsSpec.$,ShimlessRmaService_ContinueFinalizationAfterRestock_ResponseParamsSpec.$,impl.continueFinalizationAfterRestock.bind(impl),false);this.helper_internal_.registerHandler(29,ShimlessRmaService_GetRegionList_ParamsSpec.$,ShimlessRmaService_GetRegionList_ResponseParamsSpec.$,impl.getRegionList.bind(impl),false);this.helper_internal_.registerHandler(30,ShimlessRmaService_GetSkuList_ParamsSpec.$,ShimlessRmaService_GetSkuList_ResponseParamsSpec.$,impl.getSkuList.bind(impl),false);this.helper_internal_.registerHandler(31,ShimlessRmaService_GetCustomLabelList_ParamsSpec.$,ShimlessRmaService_GetCustomLabelList_ResponseParamsSpec.$,impl.getCustomLabelList.bind(impl),false);this.helper_internal_.registerHandler(32,ShimlessRmaService_GetSkuDescriptionList_ParamsSpec.$,ShimlessRmaService_GetSkuDescriptionList_ResponseParamsSpec.$,impl.getSkuDescriptionList.bind(impl),false);this.helper_internal_.registerHandler(33,ShimlessRmaService_GetOriginalSerialNumber_ParamsSpec.$,ShimlessRmaService_GetOriginalSerialNumber_ResponseParamsSpec.$,impl.getOriginalSerialNumber.bind(impl),false);this.helper_internal_.registerHandler(34,ShimlessRmaService_GetOriginalRegion_ParamsSpec.$,ShimlessRmaService_GetOriginalRegion_ResponseParamsSpec.$,impl.getOriginalRegion.bind(impl),false);this.helper_internal_.registerHandler(35,ShimlessRmaService_GetOriginalSku_ParamsSpec.$,ShimlessRmaService_GetOriginalSku_ResponseParamsSpec.$,impl.getOriginalSku.bind(impl),false);this.helper_internal_.registerHandler(36,ShimlessRmaService_GetOriginalCustomLabel_ParamsSpec.$,ShimlessRmaService_GetOriginalCustomLabel_ResponseParamsSpec.$,impl.getOriginalCustomLabel.bind(impl),false);this.helper_internal_.registerHandler(37,ShimlessRmaService_GetOriginalDramPartNumber_ParamsSpec.$,ShimlessRmaService_GetOriginalDramPartNumber_ResponseParamsSpec.$,impl.getOriginalDramPartNumber.bind(impl),false);this.helper_internal_.registerHandler(38,ShimlessRmaService_GetOriginalFeatureLevel_ParamsSpec.$,ShimlessRmaService_GetOriginalFeatureLevel_ResponseParamsSpec.$,impl.getOriginalFeatureLevel.bind(impl),false);this.helper_internal_.registerHandler(39,ShimlessRmaService_SetDeviceInformation_ParamsSpec.$,ShimlessRmaService_SetDeviceInformation_ResponseParamsSpec.$,impl.setDeviceInformation.bind(impl),false);this.helper_internal_.registerHandler(40,ShimlessRmaService_GetCalibrationComponentList_ParamsSpec.$,ShimlessRmaService_GetCalibrationComponentList_ResponseParamsSpec.$,impl.getCalibrationComponentList.bind(impl),false);this.helper_internal_.registerHandler(41,ShimlessRmaService_GetCalibrationSetupInstructions_ParamsSpec.$,ShimlessRmaService_GetCalibrationSetupInstructions_ResponseParamsSpec.$,impl.getCalibrationSetupInstructions.bind(impl),false);this.helper_internal_.registerHandler(42,ShimlessRmaService_StartCalibration_ParamsSpec.$,ShimlessRmaService_StartCalibration_ResponseParamsSpec.$,impl.startCalibration.bind(impl),false);this.helper_internal_.registerHandler(43,ShimlessRmaService_RunCalibrationStep_ParamsSpec.$,ShimlessRmaService_RunCalibrationStep_ResponseParamsSpec.$,impl.runCalibrationStep.bind(impl),false);this.helper_internal_.registerHandler(44,ShimlessRmaService_ContinueCalibration_ParamsSpec.$,ShimlessRmaService_ContinueCalibration_ResponseParamsSpec.$,impl.continueCalibration.bind(impl),false);this.helper_internal_.registerHandler(45,ShimlessRmaService_CalibrationComplete_ParamsSpec.$,ShimlessRmaService_CalibrationComplete_ResponseParamsSpec.$,impl.calibrationComplete.bind(impl),false);this.helper_internal_.registerHandler(46,ShimlessRmaService_RetryProvisioning_ParamsSpec.$,ShimlessRmaService_RetryProvisioning_ResponseParamsSpec.$,impl.retryProvisioning.bind(impl),false);this.helper_internal_.registerHandler(47,ShimlessRmaService_ProvisioningComplete_ParamsSpec.$,ShimlessRmaService_ProvisioningComplete_ResponseParamsSpec.$,impl.provisioningComplete.bind(impl),false);this.helper_internal_.registerHandler(48,ShimlessRmaService_RetryFinalization_ParamsSpec.$,ShimlessRmaService_RetryFinalization_ResponseParamsSpec.$,impl.retryFinalization.bind(impl),false);this.helper_internal_.registerHandler(49,ShimlessRmaService_FinalizationComplete_ParamsSpec.$,ShimlessRmaService_FinalizationComplete_ResponseParamsSpec.$,impl.finalizationComplete.bind(impl),false);this.helper_internal_.registerHandler(50,ShimlessRmaService_WriteProtectManuallyEnabled_ParamsSpec.$,ShimlessRmaService_WriteProtectManuallyEnabled_ResponseParamsSpec.$,impl.writeProtectManuallyEnabled.bind(impl),false);this.helper_internal_.registerHandler(51,ShimlessRmaService_GetLog_ParamsSpec.$,ShimlessRmaService_GetLog_ResponseParamsSpec.$,impl.getLog.bind(impl),false);this.helper_internal_.registerHandler(52,ShimlessRmaService_SaveLog_ParamsSpec.$,ShimlessRmaService_SaveLog_ResponseParamsSpec.$,impl.saveLog.bind(impl),false);this.helper_internal_.registerHandler(53,ShimlessRmaService_GetPowerwashRequired_ParamsSpec.$,ShimlessRmaService_GetPowerwashRequired_ResponseParamsSpec.$,impl.getPowerwashRequired.bind(impl),false);this.helper_internal_.registerHandler(54,ShimlessRmaService_LaunchDiagnostics_ParamsSpec.$,null,impl.launchDiagnostics.bind(impl),false);this.helper_internal_.registerHandler(55,ShimlessRmaService_EndRma_ParamsSpec.$,ShimlessRmaService_EndRma_ResponseParamsSpec.$,impl.endRma.bind(impl),false);this.helper_internal_.registerHandler(56,ShimlessRmaService_ShutDownAfterHardwareError_ParamsSpec.$,null,impl.shutDownAfterHardwareError.bind(impl),false);this.helper_internal_.registerHandler(57,ShimlessRmaService_CriticalErrorExitToLogin_ParamsSpec.$,ShimlessRmaService_CriticalErrorExitToLogin_ResponseParamsSpec.$,impl.criticalErrorExitToLogin.bind(impl),false);this.helper_internal_.registerHandler(58,ShimlessRmaService_CriticalErrorReboot_ParamsSpec.$,ShimlessRmaService_CriticalErrorReboot_ResponseParamsSpec.$,impl.criticalErrorReboot.bind(impl),false);this.helper_internal_.registerHandler(59,ShimlessRmaService_Get3pDiagnosticsProvider_ParamsSpec.$,ShimlessRmaService_Get3pDiagnosticsProvider_ResponseParamsSpec.$,impl.get3pDiagnosticsProvider.bind(impl),false);this.helper_internal_.registerHandler(60,ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ParamsSpec.$,ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ResponseParamsSpec.$,impl.getInstallable3pDiagnosticsAppPath.bind(impl),false);this.helper_internal_.registerHandler(61,ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ParamsSpec.$,ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ResponseParamsSpec.$,impl.installLastFound3pDiagnosticsApp.bind(impl),false);this.helper_internal_.registerHandler(62,ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ParamsSpec.$,ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ResponseParamsSpec.$,impl.completeLast3pDiagnosticsInstallation.bind(impl),false);this.helper_internal_.registerHandler(63,ShimlessRmaService_Show3pDiagnosticsApp_ParamsSpec.$,ShimlessRmaService_Show3pDiagnosticsApp_ResponseParamsSpec.$,impl.show3pDiagnosticsApp.bind(impl),false);this.helper_internal_.registerHandler(64,ShimlessRmaService_ObserveError_ParamsSpec.$,null,impl.observeError.bind(impl),false);this.helper_internal_.registerHandler(65,ShimlessRmaService_ObserveOsUpdateProgress_ParamsSpec.$,null,impl.observeOsUpdateProgress.bind(impl),false);this.helper_internal_.registerHandler(66,ShimlessRmaService_ObserveCalibrationProgress_ParamsSpec.$,null,impl.observeCalibrationProgress.bind(impl),false);this.helper_internal_.registerHandler(67,ShimlessRmaService_ObserveProvisioningProgress_ParamsSpec.$,null,impl.observeProvisioningProgress.bind(impl),false);this.helper_internal_.registerHandler(68,ShimlessRmaService_ObserveHardwareWriteProtectionState_ParamsSpec.$,null,impl.observeHardwareWriteProtectionState.bind(impl),false);this.helper_internal_.registerHandler(69,ShimlessRmaService_ObservePowerCableState_ParamsSpec.$,null,impl.observePowerCableState.bind(impl),false);this.helper_internal_.registerHandler(70,ShimlessRmaService_ObserveExternalDiskState_ParamsSpec.$,null,impl.observeExternalDiskState.bind(impl),false);this.helper_internal_.registerHandler(71,ShimlessRmaService_ObserveHardwareVerificationStatus_ParamsSpec.$,null,impl.observeHardwareVerificationStatus.bind(impl),false);this.helper_internal_.registerHandler(72,ShimlessRmaService_ObserveFinalizationStatus_ParamsSpec.$,null,impl.observeFinalizationStatus.bind(impl),false);this.helper_internal_.registerHandler(73,ShimlessRmaService_ObserveRoFirmwareUpdateProgress_ParamsSpec.$,null,impl.observeRoFirmwareUpdateProgress.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class ShimlessRmaService{static get $interfaceName(){return"ash.shimless_rma.mojom.ShimlessRmaService"}static getRemote(){let remote=new ShimlessRmaServiceRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class ShimlessRmaServiceCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShimlessRmaServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getCurrentState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,ShimlessRmaService_GetCurrentState_ParamsSpec.$,ShimlessRmaService_GetCurrentState_ResponseParamsSpec.$,this.getCurrentState.createReceiverHandler(true),false);this.getStateProperties=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,ShimlessRmaService_GetStateProperties_ParamsSpec.$,ShimlessRmaService_GetStateProperties_ResponseParamsSpec.$,this.getStateProperties.createReceiverHandler(true),false);this.transitionPreviousState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,ShimlessRmaService_TransitionPreviousState_ParamsSpec.$,ShimlessRmaService_TransitionPreviousState_ResponseParamsSpec.$,this.transitionPreviousState.createReceiverHandler(true),false);this.abortRma=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,ShimlessRmaService_AbortRma_ParamsSpec.$,ShimlessRmaService_AbortRma_ResponseParamsSpec.$,this.abortRma.createReceiverHandler(true),false);this.beginFinalization=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,ShimlessRmaService_BeginFinalization_ParamsSpec.$,ShimlessRmaService_BeginFinalization_ResponseParamsSpec.$,this.beginFinalization.createReceiverHandler(true),false);this.trackConfiguredNetworks=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,ShimlessRmaService_TrackConfiguredNetworks_ParamsSpec.$,null,this.trackConfiguredNetworks.createReceiverHandler(false),false);this.networkSelectionComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,ShimlessRmaService_NetworkSelectionComplete_ParamsSpec.$,ShimlessRmaService_NetworkSelectionComplete_ResponseParamsSpec.$,this.networkSelectionComplete.createReceiverHandler(true),false);this.getCurrentOsVersion=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,ShimlessRmaService_GetCurrentOsVersion_ParamsSpec.$,ShimlessRmaService_GetCurrentOsVersion_ResponseParamsSpec.$,this.getCurrentOsVersion.createReceiverHandler(true),false);this.checkForOsUpdates=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,ShimlessRmaService_CheckForOsUpdates_ParamsSpec.$,ShimlessRmaService_CheckForOsUpdates_ResponseParamsSpec.$,this.checkForOsUpdates.createReceiverHandler(true),false);this.updateOs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,ShimlessRmaService_UpdateOs_ParamsSpec.$,ShimlessRmaService_UpdateOs_ResponseParamsSpec.$,this.updateOs.createReceiverHandler(true),false);this.updateOsSkipped=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,ShimlessRmaService_UpdateOsSkipped_ParamsSpec.$,ShimlessRmaService_UpdateOsSkipped_ResponseParamsSpec.$,this.updateOsSkipped.createReceiverHandler(true),false);this.setSameOwner=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,ShimlessRmaService_SetSameOwner_ParamsSpec.$,ShimlessRmaService_SetSameOwner_ResponseParamsSpec.$,this.setSameOwner.createReceiverHandler(true),false);this.setDifferentOwner=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,ShimlessRmaService_SetDifferentOwner_ParamsSpec.$,ShimlessRmaService_SetDifferentOwner_ResponseParamsSpec.$,this.setDifferentOwner.createReceiverHandler(true),false);this.setWipeDevice=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,ShimlessRmaService_SetWipeDevice_ParamsSpec.$,ShimlessRmaService_SetWipeDevice_ResponseParamsSpec.$,this.setWipeDevice.createReceiverHandler(true),false);this.setManuallyDisableWriteProtect=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,ShimlessRmaService_SetManuallyDisableWriteProtect_ParamsSpec.$,ShimlessRmaService_SetManuallyDisableWriteProtect_ResponseParamsSpec.$,this.setManuallyDisableWriteProtect.createReceiverHandler(true),false);this.setRsuDisableWriteProtect=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,ShimlessRmaService_SetRsuDisableWriteProtect_ParamsSpec.$,ShimlessRmaService_SetRsuDisableWriteProtect_ResponseParamsSpec.$,this.setRsuDisableWriteProtect.createReceiverHandler(true),false);this.getRsuDisableWriteProtectChallenge=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ResponseParamsSpec.$,this.getRsuDisableWriteProtectChallenge.createReceiverHandler(true),false);this.getRsuDisableWriteProtectHwid=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,ShimlessRmaService_GetRsuDisableWriteProtectHwid_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectHwid_ResponseParamsSpec.$,this.getRsuDisableWriteProtectHwid.createReceiverHandler(true),false);this.getRsuDisableWriteProtectChallengeQrCode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ParamsSpec.$,ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ResponseParamsSpec.$,this.getRsuDisableWriteProtectChallengeQrCode.createReceiverHandler(true),false);this.setRsuDisableWriteProtectCode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,ShimlessRmaService_SetRsuDisableWriteProtectCode_ParamsSpec.$,ShimlessRmaService_SetRsuDisableWriteProtectCode_ResponseParamsSpec.$,this.setRsuDisableWriteProtectCode.createReceiverHandler(true),false);this.writeProtectManuallyDisabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(20,ShimlessRmaService_WriteProtectManuallyDisabled_ParamsSpec.$,ShimlessRmaService_WriteProtectManuallyDisabled_ResponseParamsSpec.$,this.writeProtectManuallyDisabled.createReceiverHandler(true),false);this.getWriteProtectDisableCompleteAction=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(21,ShimlessRmaService_GetWriteProtectDisableCompleteAction_ParamsSpec.$,ShimlessRmaService_GetWriteProtectDisableCompleteAction_ResponseParamsSpec.$,this.getWriteProtectDisableCompleteAction.createReceiverHandler(true),false);this.confirmManualWpDisableComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(22,ShimlessRmaService_ConfirmManualWpDisableComplete_ParamsSpec.$,ShimlessRmaService_ConfirmManualWpDisableComplete_ResponseParamsSpec.$,this.confirmManualWpDisableComplete.createReceiverHandler(true),false);this.getComponentList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(23,ShimlessRmaService_GetComponentList_ParamsSpec.$,ShimlessRmaService_GetComponentList_ResponseParamsSpec.$,this.getComponentList.createReceiverHandler(true),false);this.setComponentList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(24,ShimlessRmaService_SetComponentList_ParamsSpec.$,ShimlessRmaService_SetComponentList_ResponseParamsSpec.$,this.setComponentList.createReceiverHandler(true),false);this.reworkMainboard=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(25,ShimlessRmaService_ReworkMainboard_ParamsSpec.$,ShimlessRmaService_ReworkMainboard_ResponseParamsSpec.$,this.reworkMainboard.createReceiverHandler(true),false);this.roFirmwareUpdateComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(26,ShimlessRmaService_RoFirmwareUpdateComplete_ParamsSpec.$,ShimlessRmaService_RoFirmwareUpdateComplete_ResponseParamsSpec.$,this.roFirmwareUpdateComplete.createReceiverHandler(true),false);this.shutdownForRestock=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(27,ShimlessRmaService_ShutdownForRestock_ParamsSpec.$,ShimlessRmaService_ShutdownForRestock_ResponseParamsSpec.$,this.shutdownForRestock.createReceiverHandler(true),false);this.continueFinalizationAfterRestock=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(28,ShimlessRmaService_ContinueFinalizationAfterRestock_ParamsSpec.$,ShimlessRmaService_ContinueFinalizationAfterRestock_ResponseParamsSpec.$,this.continueFinalizationAfterRestock.createReceiverHandler(true),false);this.getRegionList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(29,ShimlessRmaService_GetRegionList_ParamsSpec.$,ShimlessRmaService_GetRegionList_ResponseParamsSpec.$,this.getRegionList.createReceiverHandler(true),false);this.getSkuList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(30,ShimlessRmaService_GetSkuList_ParamsSpec.$,ShimlessRmaService_GetSkuList_ResponseParamsSpec.$,this.getSkuList.createReceiverHandler(true),false);this.getCustomLabelList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(31,ShimlessRmaService_GetCustomLabelList_ParamsSpec.$,ShimlessRmaService_GetCustomLabelList_ResponseParamsSpec.$,this.getCustomLabelList.createReceiverHandler(true),false);this.getSkuDescriptionList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(32,ShimlessRmaService_GetSkuDescriptionList_ParamsSpec.$,ShimlessRmaService_GetSkuDescriptionList_ResponseParamsSpec.$,this.getSkuDescriptionList.createReceiverHandler(true),false);this.getOriginalSerialNumber=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(33,ShimlessRmaService_GetOriginalSerialNumber_ParamsSpec.$,ShimlessRmaService_GetOriginalSerialNumber_ResponseParamsSpec.$,this.getOriginalSerialNumber.createReceiverHandler(true),false);this.getOriginalRegion=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(34,ShimlessRmaService_GetOriginalRegion_ParamsSpec.$,ShimlessRmaService_GetOriginalRegion_ResponseParamsSpec.$,this.getOriginalRegion.createReceiverHandler(true),false);this.getOriginalSku=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(35,ShimlessRmaService_GetOriginalSku_ParamsSpec.$,ShimlessRmaService_GetOriginalSku_ResponseParamsSpec.$,this.getOriginalSku.createReceiverHandler(true),false);this.getOriginalCustomLabel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(36,ShimlessRmaService_GetOriginalCustomLabel_ParamsSpec.$,ShimlessRmaService_GetOriginalCustomLabel_ResponseParamsSpec.$,this.getOriginalCustomLabel.createReceiverHandler(true),false);this.getOriginalDramPartNumber=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(37,ShimlessRmaService_GetOriginalDramPartNumber_ParamsSpec.$,ShimlessRmaService_GetOriginalDramPartNumber_ResponseParamsSpec.$,this.getOriginalDramPartNumber.createReceiverHandler(true),false);this.getOriginalFeatureLevel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(38,ShimlessRmaService_GetOriginalFeatureLevel_ParamsSpec.$,ShimlessRmaService_GetOriginalFeatureLevel_ResponseParamsSpec.$,this.getOriginalFeatureLevel.createReceiverHandler(true),false);this.setDeviceInformation=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(39,ShimlessRmaService_SetDeviceInformation_ParamsSpec.$,ShimlessRmaService_SetDeviceInformation_ResponseParamsSpec.$,this.setDeviceInformation.createReceiverHandler(true),false);this.getCalibrationComponentList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(40,ShimlessRmaService_GetCalibrationComponentList_ParamsSpec.$,ShimlessRmaService_GetCalibrationComponentList_ResponseParamsSpec.$,this.getCalibrationComponentList.createReceiverHandler(true),false);this.getCalibrationSetupInstructions=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(41,ShimlessRmaService_GetCalibrationSetupInstructions_ParamsSpec.$,ShimlessRmaService_GetCalibrationSetupInstructions_ResponseParamsSpec.$,this.getCalibrationSetupInstructions.createReceiverHandler(true),false);this.startCalibration=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(42,ShimlessRmaService_StartCalibration_ParamsSpec.$,ShimlessRmaService_StartCalibration_ResponseParamsSpec.$,this.startCalibration.createReceiverHandler(true),false);this.runCalibrationStep=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(43,ShimlessRmaService_RunCalibrationStep_ParamsSpec.$,ShimlessRmaService_RunCalibrationStep_ResponseParamsSpec.$,this.runCalibrationStep.createReceiverHandler(true),false);this.continueCalibration=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(44,ShimlessRmaService_ContinueCalibration_ParamsSpec.$,ShimlessRmaService_ContinueCalibration_ResponseParamsSpec.$,this.continueCalibration.createReceiverHandler(true),false);this.calibrationComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(45,ShimlessRmaService_CalibrationComplete_ParamsSpec.$,ShimlessRmaService_CalibrationComplete_ResponseParamsSpec.$,this.calibrationComplete.createReceiverHandler(true),false);this.retryProvisioning=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(46,ShimlessRmaService_RetryProvisioning_ParamsSpec.$,ShimlessRmaService_RetryProvisioning_ResponseParamsSpec.$,this.retryProvisioning.createReceiverHandler(true),false);this.provisioningComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(47,ShimlessRmaService_ProvisioningComplete_ParamsSpec.$,ShimlessRmaService_ProvisioningComplete_ResponseParamsSpec.$,this.provisioningComplete.createReceiverHandler(true),false);this.retryFinalization=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(48,ShimlessRmaService_RetryFinalization_ParamsSpec.$,ShimlessRmaService_RetryFinalization_ResponseParamsSpec.$,this.retryFinalization.createReceiverHandler(true),false);this.finalizationComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(49,ShimlessRmaService_FinalizationComplete_ParamsSpec.$,ShimlessRmaService_FinalizationComplete_ResponseParamsSpec.$,this.finalizationComplete.createReceiverHandler(true),false);this.writeProtectManuallyEnabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(50,ShimlessRmaService_WriteProtectManuallyEnabled_ParamsSpec.$,ShimlessRmaService_WriteProtectManuallyEnabled_ResponseParamsSpec.$,this.writeProtectManuallyEnabled.createReceiverHandler(true),false);this.getLog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(51,ShimlessRmaService_GetLog_ParamsSpec.$,ShimlessRmaService_GetLog_ResponseParamsSpec.$,this.getLog.createReceiverHandler(true),false);this.saveLog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(52,ShimlessRmaService_SaveLog_ParamsSpec.$,ShimlessRmaService_SaveLog_ResponseParamsSpec.$,this.saveLog.createReceiverHandler(true),false);this.getPowerwashRequired=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(53,ShimlessRmaService_GetPowerwashRequired_ParamsSpec.$,ShimlessRmaService_GetPowerwashRequired_ResponseParamsSpec.$,this.getPowerwashRequired.createReceiverHandler(true),false);this.launchDiagnostics=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(54,ShimlessRmaService_LaunchDiagnostics_ParamsSpec.$,null,this.launchDiagnostics.createReceiverHandler(false),false);this.endRma=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(55,ShimlessRmaService_EndRma_ParamsSpec.$,ShimlessRmaService_EndRma_ResponseParamsSpec.$,this.endRma.createReceiverHandler(true),false);this.shutDownAfterHardwareError=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(56,ShimlessRmaService_ShutDownAfterHardwareError_ParamsSpec.$,null,this.shutDownAfterHardwareError.createReceiverHandler(false),false);this.criticalErrorExitToLogin=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(57,ShimlessRmaService_CriticalErrorExitToLogin_ParamsSpec.$,ShimlessRmaService_CriticalErrorExitToLogin_ResponseParamsSpec.$,this.criticalErrorExitToLogin.createReceiverHandler(true),false);this.criticalErrorReboot=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(58,ShimlessRmaService_CriticalErrorReboot_ParamsSpec.$,ShimlessRmaService_CriticalErrorReboot_ResponseParamsSpec.$,this.criticalErrorReboot.createReceiverHandler(true),false);this.get3pDiagnosticsProvider=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(59,ShimlessRmaService_Get3pDiagnosticsProvider_ParamsSpec.$,ShimlessRmaService_Get3pDiagnosticsProvider_ResponseParamsSpec.$,this.get3pDiagnosticsProvider.createReceiverHandler(true),false);this.getInstallable3pDiagnosticsAppPath=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(60,ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ParamsSpec.$,ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ResponseParamsSpec.$,this.getInstallable3pDiagnosticsAppPath.createReceiverHandler(true),false);this.installLastFound3pDiagnosticsApp=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(61,ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ParamsSpec.$,ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ResponseParamsSpec.$,this.installLastFound3pDiagnosticsApp.createReceiverHandler(true),false);this.completeLast3pDiagnosticsInstallation=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(62,ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ParamsSpec.$,ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ResponseParamsSpec.$,this.completeLast3pDiagnosticsInstallation.createReceiverHandler(true),false);this.show3pDiagnosticsApp=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(63,ShimlessRmaService_Show3pDiagnosticsApp_ParamsSpec.$,ShimlessRmaService_Show3pDiagnosticsApp_ResponseParamsSpec.$,this.show3pDiagnosticsApp.createReceiverHandler(true),false);this.observeError=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(64,ShimlessRmaService_ObserveError_ParamsSpec.$,null,this.observeError.createReceiverHandler(false),false);this.observeOsUpdateProgress=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(65,ShimlessRmaService_ObserveOsUpdateProgress_ParamsSpec.$,null,this.observeOsUpdateProgress.createReceiverHandler(false),false);this.observeCalibrationProgress=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(66,ShimlessRmaService_ObserveCalibrationProgress_ParamsSpec.$,null,this.observeCalibrationProgress.createReceiverHandler(false),false);this.observeProvisioningProgress=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(67,ShimlessRmaService_ObserveProvisioningProgress_ParamsSpec.$,null,this.observeProvisioningProgress.createReceiverHandler(false),false);this.observeHardwareWriteProtectionState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(68,ShimlessRmaService_ObserveHardwareWriteProtectionState_ParamsSpec.$,null,this.observeHardwareWriteProtectionState.createReceiverHandler(false),false);this.observePowerCableState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(69,ShimlessRmaService_ObservePowerCableState_ParamsSpec.$,null,this.observePowerCableState.createReceiverHandler(false),false);this.observeExternalDiskState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(70,ShimlessRmaService_ObserveExternalDiskState_ParamsSpec.$,null,this.observeExternalDiskState.createReceiverHandler(false),false);this.observeHardwareVerificationStatus=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(71,ShimlessRmaService_ObserveHardwareVerificationStatus_ParamsSpec.$,null,this.observeHardwareVerificationStatus.createReceiverHandler(false),false);this.observeFinalizationStatus=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(72,ShimlessRmaService_ObserveFinalizationStatus_ParamsSpec.$,null,this.observeFinalizationStatus.createReceiverHandler(false),false);this.observeRoFirmwareUpdateProgress=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(73,ShimlessRmaService_ObserveRoFirmwareUpdateProgress_ParamsSpec.$,null,this.observeRoFirmwareUpdateProgress.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const StateResultSpec={$:{}};export const QrCodeSpec={$:{}};export const ComponentSpec={$:{}};export const CalibrationComponentStatusSpec={$:{}};export const Shimless3pDiagnosticsAppInfoSpec={$:{}};export const PassHardwareVerificationResultSpec={$:{}};export const FailHardwareVerificationResultSpec={$:{}};export const SkipHardwareVerificationResultSpec={$:{}};export const UpdateDeviceInfoStatePropertySpec={$:{}};export const ErrorObserver_OnError_ParamsSpec={$:{}};export const OsUpdateObserver_OnOsUpdateProgressUpdated_ParamsSpec={$:{}};export const CalibrationObserver_OnCalibrationUpdated_ParamsSpec={$:{}};export const CalibrationObserver_OnCalibrationStepComplete_ParamsSpec={$:{}};export const ProvisioningObserver_OnProvisioningUpdated_ParamsSpec={$:{}};export const HardwareWriteProtectionStateObserver_OnHardwareWriteProtectionStateChanged_ParamsSpec={$:{}};export const PowerCableStateObserver_OnPowerCableStateChanged_ParamsSpec={$:{}};export const ExternalDiskStateObserver_OnExternalDiskStateChanged_ParamsSpec={$:{}};export const HardwareVerificationStatusObserver_OnHardwareVerificationResult_ParamsSpec={$:{}};export const FinalizationObserver_OnFinalizationUpdated_ParamsSpec={$:{}};export const UpdateRoFirmwareObserver_OnUpdateRoFirmwareStatusChanged_ParamsSpec={$:{}};export const ShimlessRmaService_GetCurrentState_ParamsSpec={$:{}};export const ShimlessRmaService_GetCurrentState_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetStateProperties_ParamsSpec={$:{}};export const ShimlessRmaService_GetStateProperties_ResponseParamsSpec={$:{}};export const ShimlessRmaService_TransitionPreviousState_ParamsSpec={$:{}};export const ShimlessRmaService_TransitionPreviousState_ResponseParamsSpec={$:{}};export const ShimlessRmaService_AbortRma_ParamsSpec={$:{}};export const ShimlessRmaService_AbortRma_ResponseParamsSpec={$:{}};export const ShimlessRmaService_BeginFinalization_ParamsSpec={$:{}};export const ShimlessRmaService_BeginFinalization_ResponseParamsSpec={$:{}};export const ShimlessRmaService_TrackConfiguredNetworks_ParamsSpec={$:{}};export const ShimlessRmaService_NetworkSelectionComplete_ParamsSpec={$:{}};export const ShimlessRmaService_NetworkSelectionComplete_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetCurrentOsVersion_ParamsSpec={$:{}};export const ShimlessRmaService_GetCurrentOsVersion_ResponseParamsSpec={$:{}};export const ShimlessRmaService_CheckForOsUpdates_ParamsSpec={$:{}};export const ShimlessRmaService_CheckForOsUpdates_ResponseParamsSpec={$:{}};export const ShimlessRmaService_UpdateOs_ParamsSpec={$:{}};export const ShimlessRmaService_UpdateOs_ResponseParamsSpec={$:{}};export const ShimlessRmaService_UpdateOsSkipped_ParamsSpec={$:{}};export const ShimlessRmaService_UpdateOsSkipped_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetSameOwner_ParamsSpec={$:{}};export const ShimlessRmaService_SetSameOwner_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetDifferentOwner_ParamsSpec={$:{}};export const ShimlessRmaService_SetDifferentOwner_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetWipeDevice_ParamsSpec={$:{}};export const ShimlessRmaService_SetWipeDevice_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetManuallyDisableWriteProtect_ParamsSpec={$:{}};export const ShimlessRmaService_SetManuallyDisableWriteProtect_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetRsuDisableWriteProtect_ParamsSpec={$:{}};export const ShimlessRmaService_SetRsuDisableWriteProtect_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ParamsSpec={$:{}};export const ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetRsuDisableWriteProtectHwid_ParamsSpec={$:{}};export const ShimlessRmaService_GetRsuDisableWriteProtectHwid_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ParamsSpec={$:{}};export const ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetRsuDisableWriteProtectCode_ParamsSpec={$:{}};export const ShimlessRmaService_SetRsuDisableWriteProtectCode_ResponseParamsSpec={$:{}};export const ShimlessRmaService_WriteProtectManuallyDisabled_ParamsSpec={$:{}};export const ShimlessRmaService_WriteProtectManuallyDisabled_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetWriteProtectDisableCompleteAction_ParamsSpec={$:{}};export const ShimlessRmaService_GetWriteProtectDisableCompleteAction_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ConfirmManualWpDisableComplete_ParamsSpec={$:{}};export const ShimlessRmaService_ConfirmManualWpDisableComplete_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetComponentList_ParamsSpec={$:{}};export const ShimlessRmaService_GetComponentList_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetComponentList_ParamsSpec={$:{}};export const ShimlessRmaService_SetComponentList_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ReworkMainboard_ParamsSpec={$:{}};export const ShimlessRmaService_ReworkMainboard_ResponseParamsSpec={$:{}};export const ShimlessRmaService_RoFirmwareUpdateComplete_ParamsSpec={$:{}};export const ShimlessRmaService_RoFirmwareUpdateComplete_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ShutdownForRestock_ParamsSpec={$:{}};export const ShimlessRmaService_ShutdownForRestock_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ContinueFinalizationAfterRestock_ParamsSpec={$:{}};export const ShimlessRmaService_ContinueFinalizationAfterRestock_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetRegionList_ParamsSpec={$:{}};export const ShimlessRmaService_GetRegionList_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetSkuList_ParamsSpec={$:{}};export const ShimlessRmaService_GetSkuList_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetCustomLabelList_ParamsSpec={$:{}};export const ShimlessRmaService_GetCustomLabelList_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetSkuDescriptionList_ParamsSpec={$:{}};export const ShimlessRmaService_GetSkuDescriptionList_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalSerialNumber_ParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalSerialNumber_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalRegion_ParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalRegion_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalSku_ParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalSku_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalCustomLabel_ParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalCustomLabel_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalDramPartNumber_ParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalDramPartNumber_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalFeatureLevel_ParamsSpec={$:{}};export const ShimlessRmaService_GetOriginalFeatureLevel_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SetDeviceInformation_ParamsSpec={$:{}};export const ShimlessRmaService_SetDeviceInformation_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetCalibrationComponentList_ParamsSpec={$:{}};export const ShimlessRmaService_GetCalibrationComponentList_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetCalibrationSetupInstructions_ParamsSpec={$:{}};export const ShimlessRmaService_GetCalibrationSetupInstructions_ResponseParamsSpec={$:{}};export const ShimlessRmaService_StartCalibration_ParamsSpec={$:{}};export const ShimlessRmaService_StartCalibration_ResponseParamsSpec={$:{}};export const ShimlessRmaService_RunCalibrationStep_ParamsSpec={$:{}};export const ShimlessRmaService_RunCalibrationStep_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ContinueCalibration_ParamsSpec={$:{}};export const ShimlessRmaService_ContinueCalibration_ResponseParamsSpec={$:{}};export const ShimlessRmaService_CalibrationComplete_ParamsSpec={$:{}};export const ShimlessRmaService_CalibrationComplete_ResponseParamsSpec={$:{}};export const ShimlessRmaService_RetryProvisioning_ParamsSpec={$:{}};export const ShimlessRmaService_RetryProvisioning_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ProvisioningComplete_ParamsSpec={$:{}};export const ShimlessRmaService_ProvisioningComplete_ResponseParamsSpec={$:{}};export const ShimlessRmaService_RetryFinalization_ParamsSpec={$:{}};export const ShimlessRmaService_RetryFinalization_ResponseParamsSpec={$:{}};export const ShimlessRmaService_FinalizationComplete_ParamsSpec={$:{}};export const ShimlessRmaService_FinalizationComplete_ResponseParamsSpec={$:{}};export const ShimlessRmaService_WriteProtectManuallyEnabled_ParamsSpec={$:{}};export const ShimlessRmaService_WriteProtectManuallyEnabled_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetLog_ParamsSpec={$:{}};export const ShimlessRmaService_GetLog_ResponseParamsSpec={$:{}};export const ShimlessRmaService_SaveLog_ParamsSpec={$:{}};export const ShimlessRmaService_SaveLog_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetPowerwashRequired_ParamsSpec={$:{}};export const ShimlessRmaService_GetPowerwashRequired_ResponseParamsSpec={$:{}};export const ShimlessRmaService_LaunchDiagnostics_ParamsSpec={$:{}};export const ShimlessRmaService_EndRma_ParamsSpec={$:{}};export const ShimlessRmaService_EndRma_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ShutDownAfterHardwareError_ParamsSpec={$:{}};export const ShimlessRmaService_CriticalErrorExitToLogin_ParamsSpec={$:{}};export const ShimlessRmaService_CriticalErrorExitToLogin_ResponseParamsSpec={$:{}};export const ShimlessRmaService_CriticalErrorReboot_ParamsSpec={$:{}};export const ShimlessRmaService_CriticalErrorReboot_ResponseParamsSpec={$:{}};export const ShimlessRmaService_Get3pDiagnosticsProvider_ParamsSpec={$:{}};export const ShimlessRmaService_Get3pDiagnosticsProvider_ResponseParamsSpec={$:{}};export const ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ParamsSpec={$:{}};export const ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ResponseParamsSpec={$:{}};export const ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ParamsSpec={$:{}};export const ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ResponseParamsSpec={$:{}};export const ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ParamsSpec={$:{}};export const ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ResponseParamsSpec={$:{}};export const ShimlessRmaService_Show3pDiagnosticsApp_ParamsSpec={$:{}};export const ShimlessRmaService_Show3pDiagnosticsApp_ResponseParamsSpec={$:{}};export const ShimlessRmaService_ObserveError_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveOsUpdateProgress_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveCalibrationProgress_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveProvisioningProgress_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveHardwareWriteProtectionState_ParamsSpec={$:{}};export const ShimlessRmaService_ObservePowerCableState_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveExternalDiskState_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveHardwareVerificationStatus_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveFinalizationStatus_ParamsSpec={$:{}};export const ShimlessRmaService_ObserveRoFirmwareUpdateProgress_ParamsSpec={$:{}};export const HardwareVerificationResultSpec={$:{}};export const StatePropertySpec={$:{}};export const StatePropertyResultSpec={$:{}};mojo.internal.Struct(StateResultSpec.$,"StateResult",[mojo.internal.StructField("state",0,0,StateSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("canExit",4,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("canGoBack",4,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("error",8,0,RmadErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(QrCodeSpec.$,"QrCode",[mojo.internal.StructField("size",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("data",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ComponentSpec.$,"Component",[mojo.internal.StructField("component",0,0,ComponentTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("state",4,0,ComponentRepairStatusSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("identifier",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CalibrationComponentStatusSpec.$,"CalibrationComponentStatus",[mojo.internal.StructField("component",0,0,ComponentTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("status",4,0,CalibrationStatusSpec.$,1,false,0,undefined,undefined),mojo.internal.StructField("progress",8,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Shimless3pDiagnosticsAppInfoSpec.$,"Shimless3pDiagnosticsAppInfo",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("permissionMessage",8,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PassHardwareVerificationResultSpec.$,"PassHardwareVerificationResult",[],[[0,8]]);mojo.internal.Struct(FailHardwareVerificationResultSpec.$,"FailHardwareVerificationResult",[mojo.internal.StructField("componentInfo",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SkipHardwareVerificationResultSpec.$,"SkipHardwareVerificationResult",[],[[0,8]]);mojo.internal.Struct(UpdateDeviceInfoStatePropertySpec.$,"UpdateDeviceInfoStateProperty",[mojo.internal.StructField("serialNumberModifiable",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("regionModifiable",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("skuModifiable",0,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("customLabelModifiable",0,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("dramPartNumberModifiable",0,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("featureLevelModifiable",0,5,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ErrorObserver_OnError_ParamsSpec.$,"ErrorObserver_OnError_Params",[mojo.internal.StructField("error",0,0,RmadErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OsUpdateObserver_OnOsUpdateProgressUpdated_ParamsSpec.$,"OsUpdateObserver_OnOsUpdateProgressUpdated_Params",[mojo.internal.StructField("operation",0,0,OsUpdateOperationSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("progress",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("updateErrorCode",8,0,UpdateErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CalibrationObserver_OnCalibrationUpdated_ParamsSpec.$,"CalibrationObserver_OnCalibrationUpdated_Params",[mojo.internal.StructField("componentStatus",0,0,CalibrationComponentStatusSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CalibrationObserver_OnCalibrationStepComplete_ParamsSpec.$,"CalibrationObserver_OnCalibrationStepComplete_Params",[mojo.internal.StructField("status",0,0,CalibrationOverallStatusSpec.$,1,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ProvisioningObserver_OnProvisioningUpdated_ParamsSpec.$,"ProvisioningObserver_OnProvisioningUpdated_Params",[mojo.internal.StructField("status",0,0,ProvisioningStatusSpec.$,1,false,0,undefined,undefined),mojo.internal.StructField("progress",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("error",8,0,ProvisioningErrorSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(HardwareWriteProtectionStateObserver_OnHardwareWriteProtectionStateChanged_ParamsSpec.$,"HardwareWriteProtectionStateObserver_OnHardwareWriteProtectionStateChanged_Params",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PowerCableStateObserver_OnPowerCableStateChanged_ParamsSpec.$,"PowerCableStateObserver_OnPowerCableStateChanged_Params",[mojo.internal.StructField("pluggedIn",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ExternalDiskStateObserver_OnExternalDiskStateChanged_ParamsSpec.$,"ExternalDiskStateObserver_OnExternalDiskStateChanged_Params",[mojo.internal.StructField("detected",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(HardwareVerificationStatusObserver_OnHardwareVerificationResult_ParamsSpec.$,"HardwareVerificationStatusObserver_OnHardwareVerificationResult_Params",[mojo.internal.StructField("result",0,0,HardwareVerificationResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(FinalizationObserver_OnFinalizationUpdated_ParamsSpec.$,"FinalizationObserver_OnFinalizationUpdated_Params",[mojo.internal.StructField("status",0,0,FinalizationStatusSpec.$,1,false,0,undefined,undefined),mojo.internal.StructField("progress",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("error",8,0,FinalizationErrorSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UpdateRoFirmwareObserver_OnUpdateRoFirmwareStatusChanged_ParamsSpec.$,"UpdateRoFirmwareObserver_OnUpdateRoFirmwareStatusChanged_Params",[mojo.internal.StructField("status",0,0,UpdateRoFirmwareStatusSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetCurrentState_ParamsSpec.$,"ShimlessRmaService_GetCurrentState_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetCurrentState_ResponseParamsSpec.$,"ShimlessRmaService_GetCurrentState_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetStateProperties_ParamsSpec.$,"ShimlessRmaService_GetStateProperties_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetStateProperties_ResponseParamsSpec.$,"ShimlessRmaService_GetStateProperties_ResponseParams",[mojo.internal.StructField("statePropertyResult",0,0,StatePropertyResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ShimlessRmaService_TransitionPreviousState_ParamsSpec.$,"ShimlessRmaService_TransitionPreviousState_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_TransitionPreviousState_ResponseParamsSpec.$,"ShimlessRmaService_TransitionPreviousState_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_AbortRma_ParamsSpec.$,"ShimlessRmaService_AbortRma_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_AbortRma_ResponseParamsSpec.$,"ShimlessRmaService_AbortRma_ResponseParams",[mojo.internal.StructField("error",0,0,RmadErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_BeginFinalization_ParamsSpec.$,"ShimlessRmaService_BeginFinalization_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_BeginFinalization_ResponseParamsSpec.$,"ShimlessRmaService_BeginFinalization_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_TrackConfiguredNetworks_ParamsSpec.$,"ShimlessRmaService_TrackConfiguredNetworks_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_NetworkSelectionComplete_ParamsSpec.$,"ShimlessRmaService_NetworkSelectionComplete_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_NetworkSelectionComplete_ResponseParamsSpec.$,"ShimlessRmaService_NetworkSelectionComplete_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetCurrentOsVersion_ParamsSpec.$,"ShimlessRmaService_GetCurrentOsVersion_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetCurrentOsVersion_ResponseParamsSpec.$,"ShimlessRmaService_GetCurrentOsVersion_ResponseParams",[mojo.internal.StructField("version",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_CheckForOsUpdates_ParamsSpec.$,"ShimlessRmaService_CheckForOsUpdates_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_CheckForOsUpdates_ResponseParamsSpec.$,"ShimlessRmaService_CheckForOsUpdates_ResponseParams",[mojo.internal.StructField("updateAvailable",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("version",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ShimlessRmaService_UpdateOs_ParamsSpec.$,"ShimlessRmaService_UpdateOs_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_UpdateOs_ResponseParamsSpec.$,"ShimlessRmaService_UpdateOs_ResponseParams",[mojo.internal.StructField("updateStarted",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_UpdateOsSkipped_ParamsSpec.$,"ShimlessRmaService_UpdateOsSkipped_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_UpdateOsSkipped_ResponseParamsSpec.$,"ShimlessRmaService_UpdateOsSkipped_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetSameOwner_ParamsSpec.$,"ShimlessRmaService_SetSameOwner_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_SetSameOwner_ResponseParamsSpec.$,"ShimlessRmaService_SetSameOwner_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetDifferentOwner_ParamsSpec.$,"ShimlessRmaService_SetDifferentOwner_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_SetDifferentOwner_ResponseParamsSpec.$,"ShimlessRmaService_SetDifferentOwner_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetWipeDevice_ParamsSpec.$,"ShimlessRmaService_SetWipeDevice_Params",[mojo.internal.StructField("shouldWipeDevice",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetWipeDevice_ResponseParamsSpec.$,"ShimlessRmaService_SetWipeDevice_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetManuallyDisableWriteProtect_ParamsSpec.$,"ShimlessRmaService_SetManuallyDisableWriteProtect_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_SetManuallyDisableWriteProtect_ResponseParamsSpec.$,"ShimlessRmaService_SetManuallyDisableWriteProtect_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetRsuDisableWriteProtect_ParamsSpec.$,"ShimlessRmaService_SetRsuDisableWriteProtect_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_SetRsuDisableWriteProtect_ResponseParamsSpec.$,"ShimlessRmaService_SetRsuDisableWriteProtect_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ParamsSpec.$,"ShimlessRmaService_GetRsuDisableWriteProtectChallenge_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ResponseParamsSpec.$,"ShimlessRmaService_GetRsuDisableWriteProtectChallenge_ResponseParams",[mojo.internal.StructField("challenge",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetRsuDisableWriteProtectHwid_ParamsSpec.$,"ShimlessRmaService_GetRsuDisableWriteProtectHwid_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetRsuDisableWriteProtectHwid_ResponseParamsSpec.$,"ShimlessRmaService_GetRsuDisableWriteProtectHwid_ResponseParams",[mojo.internal.StructField("hwid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ParamsSpec.$,"ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ResponseParamsSpec.$,"ShimlessRmaService_GetRsuDisableWriteProtectChallengeQrCode_ResponseParams",[mojo.internal.StructField("qrCodeData",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetRsuDisableWriteProtectCode_ParamsSpec.$,"ShimlessRmaService_SetRsuDisableWriteProtectCode_Params",[mojo.internal.StructField("code",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetRsuDisableWriteProtectCode_ResponseParamsSpec.$,"ShimlessRmaService_SetRsuDisableWriteProtectCode_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_WriteProtectManuallyDisabled_ParamsSpec.$,"ShimlessRmaService_WriteProtectManuallyDisabled_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_WriteProtectManuallyDisabled_ResponseParamsSpec.$,"ShimlessRmaService_WriteProtectManuallyDisabled_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetWriteProtectDisableCompleteAction_ParamsSpec.$,"ShimlessRmaService_GetWriteProtectDisableCompleteAction_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetWriteProtectDisableCompleteAction_ResponseParamsSpec.$,"ShimlessRmaService_GetWriteProtectDisableCompleteAction_ResponseParams",[mojo.internal.StructField("action",0,0,WriteProtectDisableCompleteActionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ConfirmManualWpDisableComplete_ParamsSpec.$,"ShimlessRmaService_ConfirmManualWpDisableComplete_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_ConfirmManualWpDisableComplete_ResponseParamsSpec.$,"ShimlessRmaService_ConfirmManualWpDisableComplete_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetComponentList_ParamsSpec.$,"ShimlessRmaService_GetComponentList_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetComponentList_ResponseParamsSpec.$,"ShimlessRmaService_GetComponentList_ResponseParams",[mojo.internal.StructField("components",0,0,mojo.internal.Array(ComponentSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetComponentList_ParamsSpec.$,"ShimlessRmaService_SetComponentList_Params",[mojo.internal.StructField("components",0,0,mojo.internal.Array(ComponentSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetComponentList_ResponseParamsSpec.$,"ShimlessRmaService_SetComponentList_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ReworkMainboard_ParamsSpec.$,"ShimlessRmaService_ReworkMainboard_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_ReworkMainboard_ResponseParamsSpec.$,"ShimlessRmaService_ReworkMainboard_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_RoFirmwareUpdateComplete_ParamsSpec.$,"ShimlessRmaService_RoFirmwareUpdateComplete_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_RoFirmwareUpdateComplete_ResponseParamsSpec.$,"ShimlessRmaService_RoFirmwareUpdateComplete_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ShutdownForRestock_ParamsSpec.$,"ShimlessRmaService_ShutdownForRestock_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_ShutdownForRestock_ResponseParamsSpec.$,"ShimlessRmaService_ShutdownForRestock_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ContinueFinalizationAfterRestock_ParamsSpec.$,"ShimlessRmaService_ContinueFinalizationAfterRestock_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_ContinueFinalizationAfterRestock_ResponseParamsSpec.$,"ShimlessRmaService_ContinueFinalizationAfterRestock_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetRegionList_ParamsSpec.$,"ShimlessRmaService_GetRegionList_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetRegionList_ResponseParamsSpec.$,"ShimlessRmaService_GetRegionList_ResponseParams",[mojo.internal.StructField("regions",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetSkuList_ParamsSpec.$,"ShimlessRmaService_GetSkuList_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetSkuList_ResponseParamsSpec.$,"ShimlessRmaService_GetSkuList_ResponseParams",[mojo.internal.StructField("skus",0,0,mojo.internal.Array(mojo.internal.Uint64,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetCustomLabelList_ParamsSpec.$,"ShimlessRmaService_GetCustomLabelList_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetCustomLabelList_ResponseParamsSpec.$,"ShimlessRmaService_GetCustomLabelList_ResponseParams",[mojo.internal.StructField("customLabels",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetSkuDescriptionList_ParamsSpec.$,"ShimlessRmaService_GetSkuDescriptionList_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetSkuDescriptionList_ResponseParamsSpec.$,"ShimlessRmaService_GetSkuDescriptionList_ResponseParams",[mojo.internal.StructField("skuDescriptions",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalSerialNumber_ParamsSpec.$,"ShimlessRmaService_GetOriginalSerialNumber_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalSerialNumber_ResponseParamsSpec.$,"ShimlessRmaService_GetOriginalSerialNumber_ResponseParams",[mojo.internal.StructField("serialNumber",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalRegion_ParamsSpec.$,"ShimlessRmaService_GetOriginalRegion_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalRegion_ResponseParamsSpec.$,"ShimlessRmaService_GetOriginalRegion_ResponseParams",[mojo.internal.StructField("regionIndex",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalSku_ParamsSpec.$,"ShimlessRmaService_GetOriginalSku_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalSku_ResponseParamsSpec.$,"ShimlessRmaService_GetOriginalSku_ResponseParams",[mojo.internal.StructField("skuIndex",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalCustomLabel_ParamsSpec.$,"ShimlessRmaService_GetOriginalCustomLabel_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalCustomLabel_ResponseParamsSpec.$,"ShimlessRmaService_GetOriginalCustomLabel_ResponseParams",[mojo.internal.StructField("customLabelIndex",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalDramPartNumber_ParamsSpec.$,"ShimlessRmaService_GetOriginalDramPartNumber_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalDramPartNumber_ResponseParamsSpec.$,"ShimlessRmaService_GetOriginalDramPartNumber_ResponseParams",[mojo.internal.StructField("dramPartNumber",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalFeatureLevel_ParamsSpec.$,"ShimlessRmaService_GetOriginalFeatureLevel_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetOriginalFeatureLevel_ResponseParamsSpec.$,"ShimlessRmaService_GetOriginalFeatureLevel_ResponseParams",[mojo.internal.StructField("originalFeatureLevel",0,0,FeatureLevelSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_SetDeviceInformation_ParamsSpec.$,"ShimlessRmaService_SetDeviceInformation_Params",[mojo.internal.StructField("serialNumber",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("regionIndex",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("skuIndex",12,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("customLabelIndex",16,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("dramPartNumber",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isChassisBranded",20,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("hwComplianceVersion",32,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(ShimlessRmaService_SetDeviceInformation_ResponseParamsSpec.$,"ShimlessRmaService_SetDeviceInformation_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetCalibrationComponentList_ParamsSpec.$,"ShimlessRmaService_GetCalibrationComponentList_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetCalibrationComponentList_ResponseParamsSpec.$,"ShimlessRmaService_GetCalibrationComponentList_ResponseParams",[mojo.internal.StructField("components",0,0,mojo.internal.Array(CalibrationComponentStatusSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetCalibrationSetupInstructions_ParamsSpec.$,"ShimlessRmaService_GetCalibrationSetupInstructions_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetCalibrationSetupInstructions_ResponseParamsSpec.$,"ShimlessRmaService_GetCalibrationSetupInstructions_ResponseParams",[mojo.internal.StructField("instructions",0,0,CalibrationSetupInstructionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_StartCalibration_ParamsSpec.$,"ShimlessRmaService_StartCalibration_Params",[mojo.internal.StructField("components",0,0,mojo.internal.Array(CalibrationComponentStatusSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_StartCalibration_ResponseParamsSpec.$,"ShimlessRmaService_StartCalibration_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_RunCalibrationStep_ParamsSpec.$,"ShimlessRmaService_RunCalibrationStep_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_RunCalibrationStep_ResponseParamsSpec.$,"ShimlessRmaService_RunCalibrationStep_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ContinueCalibration_ParamsSpec.$,"ShimlessRmaService_ContinueCalibration_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_ContinueCalibration_ResponseParamsSpec.$,"ShimlessRmaService_ContinueCalibration_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_CalibrationComplete_ParamsSpec.$,"ShimlessRmaService_CalibrationComplete_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_CalibrationComplete_ResponseParamsSpec.$,"ShimlessRmaService_CalibrationComplete_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_RetryProvisioning_ParamsSpec.$,"ShimlessRmaService_RetryProvisioning_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_RetryProvisioning_ResponseParamsSpec.$,"ShimlessRmaService_RetryProvisioning_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ProvisioningComplete_ParamsSpec.$,"ShimlessRmaService_ProvisioningComplete_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_ProvisioningComplete_ResponseParamsSpec.$,"ShimlessRmaService_ProvisioningComplete_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_RetryFinalization_ParamsSpec.$,"ShimlessRmaService_RetryFinalization_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_RetryFinalization_ResponseParamsSpec.$,"ShimlessRmaService_RetryFinalization_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_FinalizationComplete_ParamsSpec.$,"ShimlessRmaService_FinalizationComplete_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_FinalizationComplete_ResponseParamsSpec.$,"ShimlessRmaService_FinalizationComplete_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_WriteProtectManuallyEnabled_ParamsSpec.$,"ShimlessRmaService_WriteProtectManuallyEnabled_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_WriteProtectManuallyEnabled_ResponseParamsSpec.$,"ShimlessRmaService_WriteProtectManuallyEnabled_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetLog_ParamsSpec.$,"ShimlessRmaService_GetLog_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetLog_ResponseParamsSpec.$,"ShimlessRmaService_GetLog_ResponseParams",[mojo.internal.StructField("log",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("error",8,0,RmadErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ShimlessRmaService_SaveLog_ParamsSpec.$,"ShimlessRmaService_SaveLog_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_SaveLog_ResponseParamsSpec.$,"ShimlessRmaService_SaveLog_ResponseParams",[mojo.internal.StructField("savePath",0,0,mojoBase_mojom_FilePathSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("error",8,0,RmadErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ShimlessRmaService_GetPowerwashRequired_ParamsSpec.$,"ShimlessRmaService_GetPowerwashRequired_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetPowerwashRequired_ResponseParamsSpec.$,"ShimlessRmaService_GetPowerwashRequired_ResponseParams",[mojo.internal.StructField("powerwashRequired",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_LaunchDiagnostics_ParamsSpec.$,"ShimlessRmaService_LaunchDiagnostics_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_EndRma_ParamsSpec.$,"ShimlessRmaService_EndRma_Params",[mojo.internal.StructField("shutdownMethod",0,0,ShutdownMethodSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_EndRma_ResponseParamsSpec.$,"ShimlessRmaService_EndRma_ResponseParams",[mojo.internal.StructField("stateResult",0,0,StateResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ShutDownAfterHardwareError_ParamsSpec.$,"ShimlessRmaService_ShutDownAfterHardwareError_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_CriticalErrorExitToLogin_ParamsSpec.$,"ShimlessRmaService_CriticalErrorExitToLogin_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_CriticalErrorExitToLogin_ResponseParamsSpec.$,"ShimlessRmaService_CriticalErrorExitToLogin_ResponseParams",[mojo.internal.StructField("error",0,0,RmadErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_CriticalErrorReboot_ParamsSpec.$,"ShimlessRmaService_CriticalErrorReboot_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_CriticalErrorReboot_ResponseParamsSpec.$,"ShimlessRmaService_CriticalErrorReboot_ResponseParams",[mojo.internal.StructField("error",0,0,RmadErrorCodeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_Get3pDiagnosticsProvider_ParamsSpec.$,"ShimlessRmaService_Get3pDiagnosticsProvider_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_Get3pDiagnosticsProvider_ResponseParamsSpec.$,"ShimlessRmaService_Get3pDiagnosticsProvider_ResponseParams",[mojo.internal.StructField("provider",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ParamsSpec.$,"ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ResponseParamsSpec.$,"ShimlessRmaService_GetInstallable3pDiagnosticsAppPath_ResponseParams",[mojo.internal.StructField("appPath",0,0,mojoBase_mojom_FilePathSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ParamsSpec.$,"ShimlessRmaService_InstallLastFound3pDiagnosticsApp_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ResponseParamsSpec.$,"ShimlessRmaService_InstallLastFound3pDiagnosticsApp_ResponseParams",[mojo.internal.StructField("appInfo",0,0,Shimless3pDiagnosticsAppInfoSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ParamsSpec.$,"ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_Params",[mojo.internal.StructField("isApproved",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ResponseParamsSpec.$,"ShimlessRmaService_CompleteLast3pDiagnosticsInstallation_ResponseParams",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_Show3pDiagnosticsApp_ParamsSpec.$,"ShimlessRmaService_Show3pDiagnosticsApp_Params",[],[[0,8]]);mojo.internal.Struct(ShimlessRmaService_Show3pDiagnosticsApp_ResponseParamsSpec.$,"ShimlessRmaService_Show3pDiagnosticsApp_ResponseParams",[mojo.internal.StructField("result",0,0,Show3pDiagnosticsAppResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveError_ParamsSpec.$,"ShimlessRmaService_ObserveError_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(ErrorObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveOsUpdateProgress_ParamsSpec.$,"ShimlessRmaService_ObserveOsUpdateProgress_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(OsUpdateObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveCalibrationProgress_ParamsSpec.$,"ShimlessRmaService_ObserveCalibrationProgress_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(CalibrationObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveProvisioningProgress_ParamsSpec.$,"ShimlessRmaService_ObserveProvisioningProgress_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(ProvisioningObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveHardwareWriteProtectionState_ParamsSpec.$,"ShimlessRmaService_ObserveHardwareWriteProtectionState_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(HardwareWriteProtectionStateObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObservePowerCableState_ParamsSpec.$,"ShimlessRmaService_ObservePowerCableState_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(PowerCableStateObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveExternalDiskState_ParamsSpec.$,"ShimlessRmaService_ObserveExternalDiskState_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(ExternalDiskStateObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveHardwareVerificationStatus_ParamsSpec.$,"ShimlessRmaService_ObserveHardwareVerificationStatus_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(HardwareVerificationStatusObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveFinalizationStatus_ParamsSpec.$,"ShimlessRmaService_ObserveFinalizationStatus_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(FinalizationObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ShimlessRmaService_ObserveRoFirmwareUpdateProgress_ParamsSpec.$,"ShimlessRmaService_ObserveRoFirmwareUpdateProgress_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(UpdateRoFirmwareObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(HardwareVerificationResultSpec.$,"HardwareVerificationResult",{passResult:{ordinal:0,type:PassHardwareVerificationResultSpec.$},failResult:{ordinal:1,type:FailHardwareVerificationResultSpec.$},skipResult:{ordinal:2,type:SkipHardwareVerificationResultSpec.$}});export var HardwareVerificationResultFieldTags;(function(HardwareVerificationResultFieldTags){HardwareVerificationResultFieldTags[HardwareVerificationResultFieldTags["PASS_RESULT"]=0]="PASS_RESULT";HardwareVerificationResultFieldTags[HardwareVerificationResultFieldTags["FAIL_RESULT"]=1]="FAIL_RESULT";HardwareVerificationResultFieldTags[HardwareVerificationResultFieldTags["SKIP_RESULT"]=2]="SKIP_RESULT"})(HardwareVerificationResultFieldTags||(HardwareVerificationResultFieldTags={}));export function whichHardwareVerificationResult(u){if(u.passResult!==null&&u.passResult!==undefined){return HardwareVerificationResultFieldTags.PASS_RESULT}if(u.failResult!==null&&u.failResult!==undefined){return HardwareVerificationResultFieldTags.FAIL_RESULT}if(u.skipResult!==null&&u.skipResult!==undefined){return HardwareVerificationResultFieldTags.SKIP_RESULT}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(StatePropertySpec.$,"StateProperty",{updateDeviceInfoStateProperty:{ordinal:0,type:UpdateDeviceInfoStatePropertySpec.$}});export var StatePropertyFieldTags;(function(StatePropertyFieldTags){StatePropertyFieldTags[StatePropertyFieldTags["UPDATE_DEVICE_INFO_STATE_PROPERTY"]=0]="UPDATE_DEVICE_INFO_STATE_PROPERTY"})(StatePropertyFieldTags||(StatePropertyFieldTags={}));export function whichStateProperty(u){if(u.updateDeviceInfoStateProperty!==null&&u.updateDeviceInfoStateProperty!==undefined){return StatePropertyFieldTags.UPDATE_DEVICE_INFO_STATE_PROPERTY}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(StatePropertyResultSpec.$,"StatePropertyResult",{property:{ordinal:0,type:StatePropertySpec.$},error:{ordinal:1,type:StatePropertyErrorSpec.$}});export var StatePropertyResultFieldTags;(function(StatePropertyResultFieldTags){StatePropertyResultFieldTags[StatePropertyResultFieldTags["PROPERTY"]=0]="PROPERTY";StatePropertyResultFieldTags[StatePropertyResultFieldTags["ERROR"]=1]="ERROR"})(StatePropertyResultFieldTags||(StatePropertyResultFieldTags={}));export function whichStatePropertyResult(u){if(u.property!==null&&u.property!==undefined){return StatePropertyResultFieldTags.PROPERTY}if(u.error!==null&&u.error!==undefined){return StatePropertyResultFieldTags.ERROR}throw new Error("no union field has been set, this is an illegal state")}