// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{afterNextRender}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CLICK_NEXT_BUTTON,createCustomEvent,DISABLE_ALL_BUTTONS,DISABLE_NEXT_BUTTON,ENABLE_ALL_BUTTONS,TRANSITION_STATE}from"./events.js";function makeElementTabbable(element){element.setAttribute("tabindex","0")}function removeElementFromKeyboardNavigation(element){element.setAttribute("tabindex","-1")}export function disableNextButton(element){element.dispatchEvent(createCustomEvent(DISABLE_NEXT_BUTTON,true))}export function enableNextButton(element){element.dispatchEvent(createCustomEvent(DISABLE_NEXT_BUTTON,false))}export function disableAllButtons(element,showBusyStateOverlay){element.dispatchEvent(createCustomEvent(DISABLE_ALL_BUTTONS,{showBusyStateOverlay:showBusyStateOverlay}))}export function enableAllButtons(element){element.dispatchEvent(createCustomEvent(ENABLE_ALL_BUTTONS,{}))}export function executeThenTransitionState(element,fn){element.dispatchEvent(createCustomEvent(TRANSITION_STATE,fn))}export function dispatchNextButtonClick(element){element.dispatchEvent(createCustomEvent(CLICK_NEXT_BUTTON,{}))}export function modifyTabbableElement(element,isFirstClickableComponent){isFirstClickableComponent?makeElementTabbable(element):removeElementFromKeyboardNavigation(element)}export function focusPageTitle(element){const pageTitle=element.shadowRoot.querySelector("h1");assert(pageTitle);afterNextRender(element,(()=>{pageTitle.focus()}))}