// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"./shimless_rma_shared.css.js";import"./base_page.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{createCustomEvent,FATAL_HARDWARE_ERROR}from"./events.js";import{getShimlessRmaService}from"./mojo_interface_provider.js";import{FinalizationObserverReceiver,FinalizationStatus,RmadErrorCode}from"./shimless_rma.mojom-webui.js";import{executeThenTransitionState,focusPageTitle}from"./shimless_rma_util.js";import{getTemplate}from"./wrapup_finalize_page.html.js";const finalizationStatusTextKeys={[FinalizationStatus.kInProgress]:"finalizePageProgressText",[FinalizationStatus.kComplete]:"finalizePageCompleteText",[FinalizationStatus.kFailedBlocking]:"",[FinalizationStatus.kFailedNonBlocking]:""};export const FINALIZATION_ERROR_CODE_PREFIX=2e3;const WrapupFinalizePageBase=I18nMixin(PolymerElement);export class WrapupFinalizePage extends WrapupFinalizePageBase{static get is(){return"wrapup-finalize-page"}static get template(){return getTemplate()}static get properties(){return{allButtonsDisabled:Boolean,finalizationMessage:{type:String,value:""}}}constructor(){super();this.finalizationObserverReceiver=new FinalizationObserverReceiver(this);this.shimlessRmaService=getShimlessRmaService();this.shimlessRmaService.observeFinalizationStatus(this.finalizationObserverReceiver.$.bindNewPipeAndPassRemote())}ready(){super.ready();focusPageTitle(this)}onFinalizationUpdated(status,_progress,error){if(status===FinalizationStatus.kFailedBlocking||status===FinalizationStatus.kFailedNonBlocking){this.dispatchEvent(createCustomEvent(FATAL_HARDWARE_ERROR,{rmadErrorCode:RmadErrorCode.kFinalizationFailed,fatalErrorCode:FINALIZATION_ERROR_CODE_PREFIX+error}))}else{this.finalizationMessage=this.i18n(finalizationStatusTextKeys[status]);if(status===FinalizationStatus.kComplete){executeThenTransitionState(this,(()=>this.shimlessRmaService.finalizationComplete()));return}}}}customElements.define(WrapupFinalizePage.is,WrapupFinalizePage);