// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/polymer/v3_0/paper-tooltip/paper-tooltip.js";import"./base_page.js";import"./shimless_rma_shared.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{createCustomEvent,OPEN_LOGS_DIALOG}from"./events.js";import{getShimlessRmaService}from"./mojo_interface_provider.js";import{PowerCableStateObserverReceiver,ShutdownMethod}from"./shimless_rma.mojom-webui.js";import{executeThenTransitionState,focusPageTitle}from"./shimless_rma_util.js";import{getTemplate}from"./wrapup_repair_complete_page.html.js";const WrapupRepairCompletePageBase=I18nMixin(PolymerElement);var FinishRmaOption;(function(FinishRmaOption){FinishRmaOption["SHUTDOWN"]="shutdown";FinishRmaOption["REBOOT"]="reboot"})(FinishRmaOption||(FinishRmaOption={}));export class WrapupRepairCompletePage extends WrapupRepairCompletePageBase{static get is(){return"wrapup-repair-complete-page"}static get template(){return getTemplate()}static get properties(){return{allButtonsDisabled:{reflectToAttribute:true,type:Boolean},shutdownButtonsDisabled:{type:Boolean,value:false},pluggedIn:{reflectToAttribute:true,type:Boolean,value:true},selectedFinishRmaOption:{type:String,value:""},batteryTimeoutID:{type:Number,value:-1},batteryTimeoutInMs:{type:Number,value:5e3}}}constructor(){super();this.shimlessRmaService=getShimlessRmaService();this.powerCableStateReceiver=new PowerCableStateObserverReceiver(this);this.shimlessRmaService.observePowerCableState(this.powerCableStateReceiver.$.bindNewPipeAndPassRemote())}ready(){super.ready();focusPageTitle(this)}onDiagnosticsButtonClick(){this.shimlessRmaService.launchDiagnostics()}onShutDownButtonClick(e){e.preventDefault();this.selectedFinishRmaOption=FinishRmaOption.SHUTDOWN;this.shimlessRmaService.getPowerwashRequired().then((result=>{this.handlePowerwash(result.powerwashRequired)}))}handlePowerwash(powerwashRequired){if(powerwashRequired){const dialog=this.shadowRoot.querySelector("#powerwashDialog");assert(dialog);if(!dialog.open){dialog.showModal()}}else{this.shutDownOrReboot()}}shutDownOrReboot(){this.shutdownButtonsDisabled=true;if(this.selectedFinishRmaOption===FinishRmaOption.SHUTDOWN){this.endRmaAndShutdown()}else{this.endRmaAndReboot()}}endRmaAndShutdown(){executeThenTransitionState(this,(()=>this.shimlessRmaService.endRma(ShutdownMethod.kShutdown)))}getPowerwashDescriptionString(){return this.selectedFinishRmaOption===FinishRmaOption.SHUTDOWN?this.i18n("powerwashDialogShutdownDescription"):this.i18n("powerwashDialogRebootDescription")}onPowerwashButtonClick(e){e.preventDefault();const dialog=this.shadowRoot.querySelector("#powerwashDialog");assert(dialog);dialog.close();this.shutDownOrReboot()}onRebootButtonClick(e){e.preventDefault();this.selectedFinishRmaOption=FinishRmaOption.REBOOT;this.shimlessRmaService.getPowerwashRequired().then((result=>{this.handlePowerwash(result.powerwashRequired)}))}endRmaAndReboot(){executeThenTransitionState(this,(()=>this.shimlessRmaService.endRma(ShutdownMethod.kReboot)))}onRmaLogButtonClick(){this.dispatchEvent(createCustomEvent(OPEN_LOGS_DIALOG,{}))}onBatteryCutButtonClick(){const dialog=this.shadowRoot.querySelector("#batteryCutoffDialog");assert(dialog);if(!dialog.open){dialog.showModal()}const cutoffBattery=function(wrapupRepairCompletePage){assert(wrapupRepairCompletePage);const dialog=wrapupRepairCompletePage.shadowRoot.querySelector("#batteryCutoffDialog");assert(dialog);dialog.close();executeThenTransitionState(wrapupRepairCompletePage,(()=>wrapupRepairCompletePage.shimlessRmaService.endRma(ShutdownMethod.kBatteryCutoff)))};if(this.batteryTimeoutID===-1){this.batteryTimeoutID=setTimeout((()=>cutoffBattery(this)),this.batteryTimeoutInMs)}}cutoffBattery(){const dialog=this.shadowRoot.querySelector("#batteryCutoffDialog");assert(dialog);dialog.close();executeThenTransitionState(this,(()=>this.shimlessRmaService.endRma(ShutdownMethod.kBatteryCutoff)))}onCutoffShutdownButtonClick(){this.cutoffBattery()}closePowerwashDialog(){const dialog=this.shadowRoot.querySelector("#powerwashDialog");assert(dialog);dialog.close()}onCutoffCancelClick(){this.cancelBatteryCutoff()}cancelBatteryCutoff(){const batteryCutoffDialog=this.shadowRoot.querySelector("#batteryCutoffDialog");assert(batteryCutoffDialog);batteryCutoffDialog.close();if(this.batteryTimeoutID!==-1){clearTimeout(this.batteryTimeoutID);this.batteryTimeoutID=-1}}onPowerCableStateChanged(pluggedIn){this.pluggedIn=pluggedIn;if(this.pluggedIn){this.cancelBatteryCutoff()}const icon=this.shadowRoot.querySelector("#batteryCutoffIcon");assert(icon);icon.setAttribute("icon",this.pluggedIn?"shimless-icon:battery-cutoff-disabled":"shimless-icon:battery-cutoff")}disableBatteryCutButton(){return this.pluggedIn||this.allButtonsDisabled}getDiagnosticsIcon(){return this.allButtonsDisabled?"shimless-icon:diagnostics-disabled":"shimless-icon:diagnostics"}getRmaLogIcon(){return this.allButtonsDisabled?"shimless-icon:rma-log-disabled":"shimless-icon:rma-log"}getBatteryCutoffIcon(){return this.allButtonsDisabled?"shimless-icon:battery-cutoff-disabled":"shimless-icon:battery-cutoff"}disableShutdownButtons(){return this.shutdownButtonsDisabled||this.allButtonsDisabled}getRepairCompletedShutoffText(){return this.pluggedIn?this.i18n("repairCompletedShutoffInstructionsText"):this.i18n("repairCompletedShutoffDescriptionText")}}customElements.define(WrapupRepairCompletePage.is,WrapupRepairCompletePage);