import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared shimless-fonts">:host{padding:2px}:host([checked]) #componentButton{background-color:var(--google-blue-50)}:host([disabled]) #componentButton{background-color:var(--google-blue-50);opacity:0.38}:focus{outline:rgba(var(--google-blue-600-rgb),.4) solid 2px}#componentButton{--vertical-padding:24px;border:none;border-radius:8px;box-shadow:var(--cros-elevation-2-shadow);font-family:var(--shimless-component-font-family);font-size:var(--shimless-component-font-size);font-weight:var(--shimless-medium-font-weight);height:calc((2 * var(--vertical-padding)) + var(--shimless-component-line-height));line-height:var(--shimless-component-line-height);padding:0;width:100%}#componentName{color:var(--google-blue-600)}#labelDiv{align-items:center;display:flex;flex-basis:155px;inset-inline-start:0;padding-inline-start:24px;position:absolute}:host([checked]) #labelDiv{color:var(--google-blue-700)}#infoIcon{fill:var(--google-blue-600)}#checkIcon{height:20px;inset-inline-end:12px;position:absolute;width:20px}</style>

<cr-button id="componentButton" on-click="onComponentButtonClicked"
    disabled="[[disabled]]" aria-labelledby="componentName componentId"
    aria-pressed$="[[isAriaPressed(checked)]]">
  <div id="labelDiv" aria-hidden="true">
    <iron-icon id="infoIcon" icon="shimless-icon:info" hidden="[[!failed]]"
        class="small-icon">
    </iron-icon>
    <span id="componentName">[[componentName]]</span>
    <div id="componentId">[[componentId]]</div>
  </div>
  <iron-icon id="checkIcon" icon="shimless-icon24:check-circle"
      hidden="[[!shouldShowCheckIcon(checked, disabled)]]">
  </iron-icon>
</cr-button>
<!--_html_template_end_-->`;
}
