import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared">.large-icon{height:200px;width:300px}#navigationButtonWrapper{bottom:var(--header-footer-height);position:absolute}#rebootButton{margin-inline-end:8px}</style>
<base-page>
  <div slot="left-pane">
    <h1 tabindex="-1">[[i18n('criticalErrorTitleText')]]</h1>
    <div class="icon-message">
      <iron-icon icon="shimless-icon:warning" class="warning-icon small-icon">
      </iron-icon>
      <div class="instructions">[[i18n('criticalErrorMessageText')]]</div>
    </div>
    <div id="navigationButtonWrapper">
      <cr-button id="rebootButton" class="action-button"
          on-click="onRebootButtonClicked" disabled="[[allButtonsDisabled]]">
        [[i18n('criticalErrorRebootText')]]
      </cr-button>
      <cr-button id="exitToLoginButton"
          on-click="onExitToLoginButtonClicked"
          disabled="[[allButtonsDisabled]]">
        [[i18n('criticalErrorExitText')]]
      </cr-button>
    </div>
  </div>
  <div slot="right-pane">
    <div class="illustration-wrapper" aria-hidden="true">
      <img class="illustration" src="illustrations/error.svg"
          alt="[[i18n('errorAltText')]]">
    </div>
  </div>
</base-page>
<!--_html_template_end_-->`;
}
