import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared">.large-icon{height:200px;width:300px}#navigationButtonWrapper{bottom:var(--header-footer-height);position:absolute;right:var(--content-container-padding)}#errorMessageDiv{border-bottom:var(--cr-separator-line);margin-bottom:16px}#errorCode{text-align:end}
  </style>
  <base-page>
    <div slot="left-pane">
      <h1 tabindex="-1">[[i18n('hardwareErrorTitle')]]</h1>
      <div id="errorMessageDiv" class="icon-message">
        <iron-icon icon="shimless-icon:warning" class="warning-icon small-icon">
        </iron-icon>
        <div class="instructions">[[i18n('hardwareErrorMessage')]]</div>
      </div>
      <div id="errorCode" class="instructions">
        [[getErrorCodeString(errorCode)]]
      </div>
      <div id="navigationButtonWrapper">
        <cr-button id="shutDownButton" class="action-button"
            on-click="onShutDownButtonClicked" disabled="[[allButtonsDisabled]]">
          [[i18n('hardwareErrorShutDownButton')]]
        </cr-button>
      </div>
    </div>
    <div slot="right-pane">
      <div class="illustration-wrapper" aria-hidden="true">
        <img class="illustration" src="illustrations/error.svg"
            alt="[[i18n('errorAltText')]]">
      </div>
    </div>
  </base-page>
<!--_html_template_end_-->`;
}
